/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import fr.baloomba.feeligo.helper.JSONHelper;
import fr.baloomba.feeligo.model.Sticker;
import fr.baloomba.feeligo.model.StickerImage;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StickerPack
implements Parcelable {
    private Long mId;
    private String mName;
    private String mDescription;
    private String mAuthor;
    private String mIconURL;
    private int mIconId;
    private StickerImage mLogo;
    private ArrayList<Sticker> mStickers;
    private String mDate;
    private Boolean mIsLoading = false;
    public static final Parcelable.Creator<StickerPack> CREATOR = new Parcelable.Creator<StickerPack>(){

        public StickerPack createFromParcel(Parcel in) {
            return new StickerPack(in);
        }

        public StickerPack[] newArray(int size) {
            return new StickerPack[size];
        }
    };

    protected StickerPack(Init<?> builder) {
        this.mId = ((Init)builder).mId;
        this.mName = ((Init)builder).mName;
        this.mDescription = ((Init)builder).mDescription;
        this.mAuthor = ((Init)builder).mAuthor;
        this.mIconURL = ((Init)builder).mIconURL;
        this.mIconId = ((Init)builder).mIconId;
        this.mLogo = ((Init)builder).mLogo;
        this.mStickers = ((Init)builder).mStickers;
        this.mDate = ((Init)builder).mDate;
    }

    protected StickerPack(Parcel in) {
        this.mId = in.readLong();
        this.mName = in.readString();
        this.mDescription = in.readString();
        this.mAuthor = in.readString();
        this.mIconURL = in.readString();
        this.mIconId = in.readInt();
        this.mLogo = (StickerImage)in.readParcelable(StickerImage.class.getClassLoader());
        this.mStickers = new ArrayList();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.mStickers.add((Sticker)in.readParcelable(Sticker.class.getClassLoader()));
        }
        this.mDate = in.readString();
    }

    public Long getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public String getIconURL() {
        return this.mStickers.get(0).getImageURL();
    }

    public int getIconId() {
        return this.mIconId;
    }

    public ArrayList<Sticker> getStickers() {
        return this.mStickers;
    }

    public String getLogo(Context context) {
        return this.mLogo.getUrl(context);
    }

    public String getDate() {
        return this.mDate;
    }

    public Boolean getIsLoading() {
        return this.mIsLoading;
    }

    public void setIsLoading(Boolean isLoading) {
        this.mIsLoading = isLoading;
    }

    public void update(StickerPack otherPack) {
        this.mStickers = otherPack.mStickers;
        this.mDate = otherPack.mDate;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mId.longValue());
        dest.writeString(this.mName);
        dest.writeString(this.mDescription);
        dest.writeString(this.mAuthor);
        dest.writeString(this.mIconURL);
        dest.writeInt(this.mIconId);
        dest.writeParcelable((Parcelable)this.mLogo, flags);
        dest.writeInt(this.mStickers.size());
        for (Sticker sticker : this.mStickers) {
            dest.writeParcelable((Parcelable)sticker, flags);
        }
        dest.writeString(this.mDate);
    }

    public static class Builder
    extends Init<Builder> {
        public Builder(Long id2) {
            super(id2);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    protected static abstract class Init<T extends Init<T>> {
        private Long mId;
        private String mName;
        private String mDescription;
        private String mAuthor;
        private String mIconURL;
        private int mIconId;
        private StickerImage mLogo;
        private ArrayList<Sticker> mStickers;
        private String mDate;

        public Init(Long id2) {
            this.mId = id2;
        }

        public T setName(String name) {
            this.mName = name;
            return this.self();
        }

        public T setDescription(String description) {
            this.mDescription = description;
            return this.self();
        }

        public T setAuthor(String author) {
            this.mAuthor = author;
            return this.self();
        }

        public T setLogo(StickerImage logo) {
            this.mLogo = logo;
            return this.self();
        }

        public T setIconURL(String iconURL) {
            this.mIconURL = iconURL;
            return this.self();
        }

        public T setIconId(int iconId) {
            this.mIconId = iconId;
            return this.self();
        }

        public T setDate(String date) {
            this.mDate = date;
            return this.self();
        }

        public T setStickers(ArrayList<Sticker> stickers) {
            this.mStickers = stickers;
            return this.self();
        }

        protected abstract T self();

        public StickerPack build() {
            return new StickerPack(this);
        }
    }

    public static class Factory {
        private static Factory sInstance = new Factory();

        public static Factory getInstance() {
            return sInstance;
        }

        public StickerPack stickerPack(int iconId, ArrayList<Sticker> stickers) {
            return ((Builder)((Builder)new Builder(-1L).setIconId(iconId)).setStickers(stickers)).build();
        }

        public StickerPack stickerPackFromJSON(JSONObject object) throws JSONException {
            if (object == null) {
                return null;
            }
            if (object.has("sticker_pack")) {
                object = object.getJSONObject("sticker_pack");
            }
            JSONArray array = JSONHelper.getJSONArray(object, "stickers");
            ArrayList<Sticker> stickers = null;
            if (array != null) {
                stickers = new ArrayList<Sticker>();
                for (int i = 0; i < array.length(); ++i) {
                    stickers.add(Sticker.Factory.getInstance().stickerFromJSON(array.getJSONObject(i)));
                }
            }
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(JSONHelper.getLong(object, "id")).setName(JSONHelper.getString(object, "name"))).setAuthor(JSONHelper.getString(object, "author"))).setDescription(JSONHelper.getString(object, "description"))).setIconURL(JSONHelper.getString(object, "icon_url"))).setIconId(JSONHelper.getInt(object, "icon_id"))).setStickers(stickers)).setLogo(StickerImage.Factory.getInstance().stickerImageFromJSON(JSONHelper.getJSONObject(object, "logo")))).setDate(JSONHelper.getString(object, "provided_to_all_users_at"))).build();
        }
    }
}

