/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.network;

import fr.baloomba.feeligo.helper.FeeligoSettings;
import fr.baloomba.feeligo.network.URLBuilder;
import fr.baloomba.wsvolley.WSManager;
import fr.baloomba.wsvolley.WSRequest;
import fr.baloomba.wsvolley.WSResponseListener;

public class RequestBuilder {
    public static void searchStickers(String keyword, WSResponseListener callbacks) {
        String url = URLBuilder.stickerSearch(keyword);
        WSRequest request = ((WSRequest.Builder)((WSRequest.Builder)((WSRequest.Builder)new WSRequest.Builder(0, url, "feeligo_search_stickers").setListener(callbacks)).addHeader("Referer", "http://android-app." + FeeligoSettings.getDomain())).setShouldCache(true)).build();
        WSManager.getInstance().send(request);
    }

    public static void getRecommendedStickers(String phrase, WSResponseListener callbacks) {
        String url = URLBuilder.recommendedStickers(phrase);
        WSRequest request = ((WSRequest.Builder)((WSRequest.Builder)((WSRequest.Builder)new WSRequest.Builder(0, url, "feeligo_recommended_stickers").setListener(callbacks)).addHeader("Referer", "http://android-app." + FeeligoSettings.getDomain())).setShouldCache(true)).build();
        WSManager.getInstance().send(request);
    }

    public static void getPopularStickers(WSResponseListener callbacks) {
        String url = URLBuilder.popularStickers();
        WSRequest request = ((WSRequest.Builder)((WSRequest.Builder)((WSRequest.Builder)new WSRequest.Builder(0, url, "feeligo_popular_stickers").setListener(callbacks)).addHeader("Referer", "http://android-app." + FeeligoSettings.getDomain())).setShouldCache(true)).build();
        WSManager.getInstance().send(request);
    }

    public static void getRecentStickers(String id2, WSResponseListener callbacks) {
        String url = URLBuilder.recentStickers(id2);
        WSRequest request = ((WSRequest.Builder)((WSRequest.Builder)((WSRequest.Builder)new WSRequest.Builder(0, url, "feeligo_get_recent_stickers").setListener(callbacks)).addHeader("Referer", "http://android-app." + FeeligoSettings.getDomain())).setShouldCache(true)).build();
        WSManager.getInstance().send(request);
    }

    public static void setRecentSticker(String id2, Long stickerId, WSResponseListener callbacks) {
        String url = URLBuilder.recentStickers(id2);
        WSRequest request = ((WSRequest.Builder)((WSRequest.Builder)((WSRequest.Builder)new WSRequest.Builder(1, url, "feeligo_set_recent_sticker").setListener(callbacks)).addHeader("Referer", "http://android-app." + FeeligoSettings.getDomain())).addParam("sticker[id]", stickerId.toString())).build();
        WSManager.getInstance().send(request);
    }

    public static void getStickerPack(WSResponseListener callbacks) {
        String url = URLBuilder.stickerPack();
        WSRequest request = ((WSRequest.Builder)((WSRequest.Builder)((WSRequest.Builder)new WSRequest.Builder(0, url, "feeligo_sticker_packs").setListener(callbacks)).addHeader("Referer", "http://android-app." + FeeligoSettings.getDomain())).setShouldCache(true)).build();
        WSManager.getInstance().send(request);
    }

    public static void getUserStickerPack(String id2, WSResponseListener callbacks) {
        String url = URLBuilder.userStickerPack(id2);
        WSRequest request = ((WSRequest.Builder)((WSRequest.Builder)((WSRequest.Builder)new WSRequest.Builder(0, url, "feeligo_user_sticker_packs").setListener(callbacks)).addHeader("Referer", "http://android-app." + FeeligoSettings.getDomain())).setShouldCache(true)).build();
        WSManager.getInstance().send(request);
    }

    public static void addUserStickerPack(String id2, Long packId, WSResponseListener callbacks) {
        String url = URLBuilder.userStickerPack(id2);
        WSRequest request = ((WSRequest.Builder)((WSRequest.Builder)((WSRequest.Builder)((WSRequest.Builder)new WSRequest.Builder(1, url, "feeligo_user_sticker_packs").addParam("user_sticker_pack[sticker_pack_id]", packId.toString())).setListener(callbacks)).addHeader("Referer", "http://android-app." + FeeligoSettings.getDomain())).setShouldCache(false)).build();
        WSManager.getInstance().send(request);
    }

    public static void removeUserStickerPack(String id2, Long packId, WSResponseListener callbacks) {
        String url = URLBuilder.userStickerPack(id2, packId);
        WSRequest request = ((WSRequest.Builder)((WSRequest.Builder)((WSRequest.Builder)new WSRequest.Builder(3, url, "feeligo_user_sticker_packs").setListener(callbacks)).addHeader("Referer", "http://android-app." + FeeligoSettings.getDomain())).setShouldCache(false)).build();
        WSManager.getInstance().send(request);
    }
}

