/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.network;

import fr.baloomba.feeligo.FeeligoLog;
import fr.baloomba.feeligo.helper.FeeligoSettings;
import java.net.URLEncoder;

public class URLBuilder {
    private static final String STICKER_BASE = "/stickers";
    private static final String STICKER_SEARCH = "/search";
    private static final String STICKER_RECOMMEND = "/recommend";
    private static final String STICKER_POPULAR = "/popular";
    private static final String STICKER_USER_BASE = "/users";
    private static final String STICKER_RECENT = "/recent";
    private static final String STICKER_USER_STICKER_PACK = "/user_sticker_packs";
    private static final String STICKER_PACK_BASE = "/sticker_packs";

    private static String base() {
        return "http://stickersapi.feeligo.com/api/" + FeeligoSettings.getDomain();
    }

    private static String stickerBase() {
        return URLBuilder.base() + STICKER_BASE;
    }

    private static String userBase(String user_id) {
        return URLBuilder.base() + STICKER_USER_BASE + "/" + user_id;
    }

    private static String stickerPackBase() {
        return URLBuilder.base() + STICKER_PACK_BASE;
    }

    public static String stickerSearch(String searchString) {
        try {
            searchString = URLEncoder.encode(searchString, "UTF-8");
        }
        catch (Exception e) {
            FeeligoLog.e(e.getMessage());
        }
        searchString = searchString.replaceAll("\\+", "%20");
        return URLBuilder.stickerBase() + STICKER_SEARCH + "/" + searchString;
    }

    public static String recommendedStickers(String searchString) {
        try {
            searchString = URLEncoder.encode(searchString, "UTF-8");
        }
        catch (Exception e) {
            FeeligoLog.e(e.getMessage());
        }
        searchString = searchString.replaceAll("\\+", "%20");
        return URLBuilder.stickerBase() + STICKER_RECOMMEND + "/" + searchString;
    }

    public static String popularStickers() {
        return URLBuilder.stickerBase() + STICKER_POPULAR;
    }

    public static String recentStickers(String user_id) {
        return URLBuilder.userBase(user_id) + STICKER_BASE + STICKER_RECENT;
    }

    public static String userStickerPack(String user_id) {
        return URLBuilder.userBase(user_id) + STICKER_USER_STICKER_PACK;
    }

    public static String userStickerPack(String user_id, Long pack_id) {
        return URLBuilder.userStickerPack(user_id) + "/" + pack_id;
    }

    public static String stickerPack() {
        return URLBuilder.stickerPackBase();
    }
}

