/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.store;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.MenuItem;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.volley.VolleyError;
import fr.baloomba.feeligo.R;
import fr.baloomba.feeligo.helper.ActionBarHelper;
import fr.baloomba.feeligo.helper.FeeligoSettings;
import fr.baloomba.feeligo.model.StickerPack;
import fr.baloomba.feeligo.network.RequestBuilder;
import fr.baloomba.feeligo.store.FeeligoStickerStoreAdapter;
import fr.baloomba.wsvolley.WSResponseListener;
import fr.baloomba.wsvolley.WSStringResponseListener;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FeeligoStickerStoreActivity
extends ActionBarActivity {
    private static final String TAG = FeeligoStickerStoreActivity.class.getSimpleName();
    private Handler mHandler = new Handler();
    private ArrayList<StickerPack> mData;
    private FeeligoStickerStoreAdapter mAdapter = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_sticker_store);
        this.setActionBar();
        this.getData();
    }

    public void onStart() {
        super.onStart();
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void setActionBar() {
        this.getSupportActionBar().setTitle((CharSequence)"Sticker Store");
        this.getSupportActionBar().setDisplayShowHomeEnabled(false);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        ActionBarHelper.setColor(this, FeeligoSettings.getActiveColor(), new Drawable.Callback(){

            public void invalidateDrawable(Drawable who) {
                FeeligoStickerStoreActivity.this.getSupportActionBar().setBackgroundDrawable(who);
            }

            public void scheduleDrawable(Drawable who, Runnable what, long when) {
                FeeligoStickerStoreActivity.this.mHandler.postAtTime(what, when);
            }

            public void unscheduleDrawable(Drawable who, Runnable what) {
                FeeligoStickerStoreActivity.this.mHandler.removeCallbacks(what);
            }
        });
    }

    private void getData() {
        this.findViewById(R.id.activity_sticker_store_loading_layout).setVisibility(0);
        this.mData = new ArrayList();
        RequestBuilder.getStickerPack((WSResponseListener)new WSStringResponseListener(){

            public void onResponse(String response) {
                try {
                    JSONObject object = new JSONObject(response);
                    JSONArray array = object.getJSONArray("sticker_packs");
                    for (int i = 0; i < array.length(); ++i) {
                        FeeligoStickerStoreActivity.this.mData.add(StickerPack.Factory.getInstance().stickerPackFromJSON(array.getJSONObject(i)));
                    }
                    FeeligoStickerStoreActivity.this.setContent();
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)e.getMessage());
                    FeeligoStickerStoreActivity.this.findViewById(R.id.activity_sticker_store_loading_layout).setVisibility(8);
                }
            }

            public void onErrorResponse(VolleyError error) {
                Log.e((String)TAG, (String)error.getMessage());
                FeeligoStickerStoreActivity.this.findViewById(R.id.activity_sticker_store_loading_layout).setVisibility(8);
            }
        });
    }

    private void setContent() {
        this.findViewById(R.id.activity_sticker_store_loading_layout).setVisibility(8);
        this.mAdapter = new FeeligoStickerStoreAdapter((Context)this);
        this.mAdapter.setData(this.mData);
        ListView listView = (ListView)this.findViewById(R.id.activity_sticker_store_list_view);
        listView.setAdapter((ListAdapter)this.mAdapter);
    }
}

