/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.store;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.android.volley.VolleyError;
import fr.baloomba.feeligo.Feeligo;
import fr.baloomba.feeligo.R;
import fr.baloomba.feeligo.helper.ViewHelper;
import fr.baloomba.feeligo.model.StickerPack;
import fr.baloomba.feeligo.store.FeeligoStickerStoreDetailActivity;
import fr.baloomba.feeligo.widget.FeeligoStickerImageView;
import fr.baloomba.wsvolley.WSResponseListener;
import fr.baloomba.wsvolley.WSStringResponseListener;
import java.util.ArrayList;

public class FeeligoStickerStoreAdapter
extends BaseAdapter {
    private static final String TAG = FeeligoStickerStoreAdapter.class.getSimpleName();
    private static LayoutInflater sInflater;
    private Context mContext;
    private ArrayList<StickerPack> mData;

    public FeeligoStickerStoreAdapter(Context context) {
        sInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mContext = context;
    }

    public void setData(ArrayList<StickerPack> data) {
        this.mData = data;
    }

    public int getCount() {
        return this.mData != null ? this.mData.size() : 0;
    }

    public Object getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return this.mData.get(position).getId();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = sInflater.inflate(R.layout.cell_sticker_store, parent, false);
            holder = new ViewHolder();
            if (convertView != null) {
                holder.imageView = (FeeligoStickerImageView)convertView.findViewById(R.id.cell_sticker_store_sticker_image_view);
                holder.nameTextView = (TextView)convertView.findViewById(R.id.cell_sticker_store_name_text_view);
                holder.authorTextView = (TextView)convertView.findViewById(R.id.cell_sticker_store_author_text_view);
                holder.layout = (LinearLayout)convertView.findViewById(R.id.cell_sticker_store_layout);
                holder.button = (RelativeLayout)convertView.findViewById(R.id.cell_sticker_store_button_layout);
                holder.buttonImage = (ImageView)convertView.findViewById(R.id.cell_sticker_store_action_button);
                holder.progressBar = (ProgressBar)convertView.findViewById(R.id.cell_sticker_store_action_progress_bar);
                convertView.setTag((Object)holder);
            }
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        this.setContent(holder, this.mData.get(position));
        return convertView;
    }

    private void setContent(final ViewHolder holder, final StickerPack stickerPack) {
        if (stickerPack.getIsLoading().booleanValue()) {
            holder.progressBar.setVisibility(0);
        } else {
            ViewHelper.setEnabledViewWithAlpha((View)holder.button, true);
            holder.imageView.setImageUrl(stickerPack.getLogo(this.mContext));
            holder.nameTextView.setText((CharSequence)stickerPack.getName());
            holder.authorTextView.setText((CharSequence)stickerPack.getAuthor());
            holder.layout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!stickerPack.getIsLoading().booleanValue()) {
                        FeeligoStickerStoreAdapter.this.goToDetailsActivity(stickerPack);
                    }
                }
            });
            holder.progressBar.setVisibility(8);
            holder.buttonImage.setVisibility(0);
            if (Feeligo.getInstance().isStickerPackPresent(stickerPack.getId())) {
                holder.buttonImage.setImageResource(R.drawable.ic_remove_pack);
                holder.button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        stickerPack.setIsLoading(true);
                        holder.buttonImage.setVisibility(8);
                        holder.progressBar.setVisibility(0);
                        Feeligo.getInstance().removeStickerPack(stickerPack, (WSResponseListener)new WSStringResponseListener(){

                            public void onResponse(String response) {
                                stickerPack.setIsLoading(false);
                                FeeligoStickerStoreAdapter.this.notifyDataSetChanged();
                            }

                            public void onErrorResponse(VolleyError error) {
                                stickerPack.setIsLoading(false);
                                FeeligoStickerStoreAdapter.this.notifyDataSetChanged();
                            }
                        });
                    }
                });
            } else {
                holder.buttonImage.setImageResource(R.drawable.ic_add_pack);
                holder.button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        stickerPack.setIsLoading(true);
                        holder.buttonImage.setVisibility(8);
                        holder.progressBar.setVisibility(0);
                        Feeligo.getInstance().addStickerPack(stickerPack, (WSResponseListener)new WSStringResponseListener(){

                            public void onResponse(String response) {
                                stickerPack.setIsLoading(false);
                                FeeligoStickerStoreAdapter.this.notifyDataSetChanged();
                            }

                            public void onErrorResponse(VolleyError error) {
                                stickerPack.setIsLoading(false);
                                FeeligoStickerStoreAdapter.this.notifyDataSetChanged();
                            }
                        });
                    }
                });
            }
        }
    }

    private void goToDetailsActivity(StickerPack stickerPack) {
        Intent intent = new Intent(this.mContext, FeeligoStickerStoreDetailActivity.class);
        intent.putExtra("sticker_pack", (Parcelable)stickerPack);
        this.mContext.startActivity(intent);
    }

    static class ViewHolder {
        LinearLayout layout;
        FeeligoStickerImageView imageView;
        TextView nameTextView;
        TextView authorTextView;
        ImageView buttonImage;
        RelativeLayout button;
        ProgressBar progressBar;

        ViewHolder() {
        }
    }
}

