/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.store;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.ActionBarActivity;
import android.view.MenuItem;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.android.volley.VolleyError;
import fr.baloomba.feeligo.Feeligo;
import fr.baloomba.feeligo.R;
import fr.baloomba.feeligo.helper.ActionBarHelper;
import fr.baloomba.feeligo.helper.FeeligoSettings;
import fr.baloomba.feeligo.helper.ViewHelper;
import fr.baloomba.feeligo.model.StickerPack;
import fr.baloomba.feeligo.store.FeeligoStoreDetailAdapter;
import fr.baloomba.feeligo.widget.FeeligoStickerImageView;
import fr.baloomba.wsvolley.WSResponseListener;
import fr.baloomba.wsvolley.WSStringResponseListener;

public class FeeligoStickerStoreDetailActivity
extends ActionBarActivity {
    private static final String TAG = FeeligoStickerStoreDetailActivity.class.getSimpleName();
    private Handler mHandler = new Handler();
    private StickerPack mData;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_sticker_store_details);
        this.setActionBar();
        this.getData();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void setActionBar() {
        this.getSupportActionBar().setTitle((CharSequence)"Sticker Store");
        this.getSupportActionBar().setDisplayShowHomeEnabled(false);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        ActionBarHelper.setColor(this, FeeligoSettings.getActiveColor(), new Drawable.Callback(){

            public void invalidateDrawable(Drawable who) {
                FeeligoStickerStoreDetailActivity.this.getSupportActionBar().setBackgroundDrawable(who);
            }

            public void scheduleDrawable(Drawable who, Runnable what, long when) {
                FeeligoStickerStoreDetailActivity.this.mHandler.postAtTime(what, when);
            }

            public void unscheduleDrawable(Drawable who, Runnable what) {
                FeeligoStickerStoreDetailActivity.this.mHandler.removeCallbacks(what);
            }
        });
    }

    private void getData() {
        Bundle extras = this.getIntent().getExtras();
        if (extras != null) {
            this.mData = (StickerPack)extras.getParcelable("sticker_pack");
            this.setContent();
        }
    }

    private void setContent() {
        ((FeeligoStickerImageView)this.findViewById(R.id.activity_sticker_store_details_logo_image_view)).setImageUrl(this.mData.getLogo((Context)this));
        ((TextView)this.findViewById(R.id.activity_sticker_store_details_name_text_view)).setText((CharSequence)this.mData.getName());
        ((TextView)this.findViewById(R.id.activity_sticker_store_details_author_text_view)).setText((CharSequence)this.mData.getAuthor());
        ((TextView)this.findViewById(R.id.activity_sticker_store_details_description_text_view)).setText((CharSequence)this.mData.getDescription());
        this.updateButton();
        FeeligoStoreDetailAdapter adapter = new FeeligoStoreDetailAdapter();
        adapter.init((Context)this);
        adapter.setData(this.mData.getStickers());
        ((GridView)this.findViewById(R.id.activity_sticker_store_details_stickers_grid_view)).setAdapter((ListAdapter)adapter);
    }

    private void updateButton() {
        final View addButton = this.findViewById(R.id.activity_sticker_store_details_add_button);
        final View removeButton = this.findViewById(R.id.activity_sticker_store_details_remove_button);
        ViewHelper.setEnabledViewWithAlpha(addButton, true);
        ViewHelper.setEnabledViewWithAlpha(removeButton, true);
        addButton.setVisibility(8);
        removeButton.setVisibility(8);
        if (Feeligo.getInstance().isStickerPackPresent(this.mData.getId())) {
            removeButton.setVisibility(0);
            removeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ViewHelper.setEnabledViewWithAlpha(removeButton, false);
                    Feeligo.getInstance().removeStickerPack(FeeligoStickerStoreDetailActivity.this.mData, (WSResponseListener)new WSStringResponseListener(){

                        public void onResponse(String response) {
                            FeeligoStickerStoreDetailActivity.this.updateButton();
                        }

                        public void onErrorResponse(VolleyError error) {
                        }
                    });
                }
            });
        } else {
            addButton.setVisibility(0);
            addButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ViewHelper.setEnabledViewWithAlpha(addButton, false);
                    Feeligo.getInstance().addStickerPack(FeeligoStickerStoreDetailActivity.this.mData, (WSResponseListener)new WSStringResponseListener(){

                        public void onResponse(String response) {
                            FeeligoStickerStoreDetailActivity.this.updateButton();
                        }

                        public void onErrorResponse(VolleyError error) {
                        }
                    });
                }
            });
        }
    }
}

