/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.feeligo.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import fr.baloomba.feeligo.R;
import fr.baloomba.feeligo.helper.FeeligoSettings;
import fr.baloomba.wsvolley.WSManager;
import fr.baloomba.wsvolley.WSRequest;
import fr.baloomba.wsvolley.widget.NetworkImageView;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeeligoStickerImageView
extends NetworkImageView {
    private static final String TAG = FeeligoStickerImageView.class.getSimpleName();
    private static final String BASE_STICKER_URL = "http://stkr.es/";
    private static final String SMALL_PREFIX = "p";
    private static final String MEDIUM_PREFIX = "p3w";
    private static final String LARGE_PREFIX = "p7s";
    private Context mContext;
    protected Boolean mIsActive = true;
    private Boolean mFirstShowing = true;

    public FeeligoStickerImageView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public FeeligoStickerImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public FeeligoStickerImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    public void init(Context context, AttributeSet attrs, int defStyle) {
        this.mContext = context;
        this.mRatio = Float.valueOf(1.0f);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FeeligoStickerImageView, defStyle, 0);
            this.mIsActive = a == null || a.getBoolean(0, true);
        }
    }

    public void setImageUrl(String url) {
        super.setImageUrl(url + "?f-ed=1");
        if (this.mIsActive.booleanValue() && this.mFirstShowing.booleanValue()) {
            WSRequest request = ((WSRequest.Builder)((WSRequest.Builder)new WSRequest.Builder(0, url, "feeligo_sticker_image_view").addHeader("Referer", "http://android-app." + FeeligoSettings.getDomain())).setShouldCache(false)).build();
            WSManager.getInstance().send(request);
            this.mFirstShowing = false;
        }
    }

    public void setStickerCode(String code) {
        Pattern pattern = Pattern.compile("\\[s:([a-zA-Z0-9\\/\\.\\?\\=]+[a-zA-Z0-9]*)\\]");
        Matcher matcher = pattern.matcher(code);
        if (matcher.find()) {
            String url;
            String elem = matcher.group(1);
            if (elem.split("/")[0].equalsIgnoreCase(SMALL_PREFIX)) {
                String prefix;
                int density = this.mContext.getResources().getInteger(R.integer.density);
                switch (density) {
                    case 0: {
                        prefix = SMALL_PREFIX;
                        break;
                    }
                    case 2: {
                        prefix = LARGE_PREFIX;
                        break;
                    }
                    default: {
                        prefix = MEDIUM_PREFIX;
                    }
                }
                url = BASE_STICKER_URL + prefix + "/" + matcher.group(1).split("/")[1];
            } else {
                url = BASE_STICKER_URL + elem;
            }
            this.setImageUrl(url);
        }
    }

    public void setStickerCode(String code, Boolean isNew) {
        this.mFirstShowing = isNew;
        this.setStickerCode(code);
    }
}

