/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.helper;

import android.util.Log;

public class LogHelper {
    private static final Boolean SUPER_DEBUG_ENABLED = false;
    public static final int SUPER_DEBUG = 1;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;

    public static void log(int logMode, String message) {
        LogHelper.log(logMode, "", message);
    }

    public static void log(int logMode, String tag, String message) {
        tag = "fr.baloomba.ui_lib:" + tag;
        message = message == null ? "[LOGGER MESSAGE] - null" : (message.length() > 0 ? message : "[LOGGER MESSAGE] - Empty log string");
        switch (logMode) {
            case 1: {
                if (!SUPER_DEBUG_ENABLED.booleanValue()) break;
                Log.d((String)tag, (String)message);
                break;
            }
            case 3: {
                if (!SUPER_DEBUG_ENABLED.booleanValue()) break;
                Log.d((String)tag, (String)message);
                break;
            }
            case 6: {
                if (!SUPER_DEBUG_ENABLED.booleanValue()) break;
                Log.e((String)tag, (String)message);
                break;
            }
            case 4: {
                if (!SUPER_DEBUG_ENABLED.booleanValue()) break;
                Log.i((String)tag, (String)message);
                break;
            }
            case 2: {
                if (!SUPER_DEBUG_ENABLED.booleanValue()) break;
                Log.v((String)tag, (String)message);
                break;
            }
            case 5: {
                if (!SUPER_DEBUG_ENABLED.booleanValue()) break;
                Log.w((String)tag, (String)message);
                break;
            }
        }
    }

    public static void log(int logMode, String app, String tag, String message) {
        LogHelper.log(logMode, app + ":" + tag, message);
    }
}

