/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.widget;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.widget.Button;
import android.widget.TextView;
import fr.baloomba.ui_lib.helper.CharSequenceHelper;

public class CustomButton
extends Button {
    private Boolean mAllCaps = false;

    public CustomButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public CustomButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CustomButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        Typeface tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/FreigSanProBook.otf");
        this.mAllCaps = false;
        if (attrs != null) {
            int textStyle = attrs.getAttributeIntValue("http://schemas.android.com/apk/res-auto", "customTextStyle", 0);
            switch (textStyle) {
                case -2: {
                    tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Museo_SlabBold.otf");
                    break;
                }
                case -1: {
                    tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Museo_Slab.otf");
                    break;
                }
                case 2: {
                    tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/FreigSanProBold.otf");
                    break;
                }
                default: {
                    tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/FreigSanProBook.otf");
                }
            }
            this.mAllCaps = attrs.getAttributeBooleanValue("http://schemas.android.com/apk/res-auto", "uppercase", false);
        }
        this.setTypeface(tf);
        if (this.mAllCaps.booleanValue()) {
            this.setText(CharSequenceHelper.toString(this.getText()).toUpperCase());
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.mAllCaps != null && this.mAllCaps.booleanValue()) {
            text = text.toString().toUpperCase();
        }
        super.setText(text, type);
    }
}

