/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.widget;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.widget.EditText;
import android.widget.TextView;
import fr.baloomba.ui_lib.helper.CharSequenceHelper;
import fr.baloomba.ui_lib.helper.EditableHelper;

public class CustomEditText
extends EditText {
    private Boolean mAllCaps = false;

    public CustomEditText(Context context) {
        super(context);
        this.init(context, null);
    }

    public CustomEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CustomEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.mAllCaps != null && this.mAllCaps.booleanValue()) {
            text = text.toString().toUpperCase();
        }
        super.setText(text, type);
    }

    private void init(Context context, AttributeSet attrs) {
        Typeface tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/FreigSanProBook.otf");
        this.mAllCaps = false;
        if (attrs != null) {
            int textStyle = attrs.getAttributeIntValue("http://schemas.android.com/apk/res-auto", "customTextStyle", 0);
            switch (textStyle) {
                case -2: {
                    tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Museo_SlabBold.otf");
                    break;
                }
                case -1: {
                    tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Museo_Slab.otf");
                    break;
                }
                case 2: {
                    tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/FreigSanProBold.otf");
                    break;
                }
                default: {
                    tf = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/FreigSanProBook.otf");
                }
            }
            this.mAllCaps = attrs.getAttributeBooleanValue("http://schemas.android.com/apk/res-auto", "uppercase", false);
        }
        this.setTypeface(tf);
        if (this.mAllCaps.booleanValue()) {
            this.setText(EditableHelper.toString(this.getText()).toUpperCase());
            this.setHint(CharSequenceHelper.toString(this.getHint()).toUpperCase());
        }
    }
}

