/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.widget;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import fr.baloomba.ui_lib.R;
import fr.baloomba.ui_lib.helper.ViewHelper;
import java.io.IOException;

public class CustomTextView
extends TextView {
    private Context mContext;
    private Boolean mAllCaps = false;
    private Boolean mIsHTML = false;
    private Boolean mCapitalize = false;
    private String mCustomFontFile = null;
    private Boolean mHasLink = false;

    public CustomTextView(Context context) {
        super(context);
        this.initCustomTextView(context);
    }

    public CustomTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initCustomTextView(context);
        this.initCustomTextViewFromAttributes(context, attrs);
    }

    public CustomTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initCustomTextView(context);
        this.initCustomTextViewFromAttributes(context, attrs);
    }

    public void setAllCaps(boolean allCaps) {
        this.mAllCaps = allCaps;
        this.setText(this.getText());
    }

    public void setCapitalize(Boolean capitalize) {
        this.mCapitalize = capitalize;
        this.setText(this.getText());
    }

    public void setIsHTML(Boolean isHTML) {
        this.mIsHTML = isHTML;
        this.setText(this.getText());
    }

    public void setHasLink(Boolean hasLink) {
        this.mHasLink = hasLink;
        this.setText(this.getText());
    }

    public void setCustomFontFile(String customFontFile) {
        this.mCustomFontFile = customFontFile;
        if (this.mCustomFontFile != null) {
            try {
                Typeface tf = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)("fonts/" + this.mCustomFontFile));
                this.setTypeface(tf);
                this.invalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setEnable(boolean enable) {
        ViewHelper.setAlpha((View)this, 0.5f);
    }

    public Boolean getAllCaps() {
        return this.mAllCaps;
    }

    public Boolean getCapitalize() {
        return this.mCapitalize;
    }

    public Boolean getIsHTML() {
        return this.mIsHTML;
    }

    public Boolean getHasLink() {
        return this.mHasLink;
    }

    public String getCustomFontFile() {
        return this.mCustomFontFile;
    }

    private void initCustomTextView(Context context) {
        this.mContext = context;
    }

    private void initCustomTextViewFromAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CustomTextView);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.CustomTextView_customFontFile) {
                this.setCustomFontFile(a.getString(attr));
                continue;
            }
            if (attr == R.styleable.CustomTextView_uppercase) {
                this.setAllCaps(a.getBoolean(attr, false));
                continue;
            }
            if (attr == R.styleable.CustomTextView_capitalize) {
                this.setCapitalize(a.getBoolean(attr, false));
                continue;
            }
            if (attr == R.styleable.CustomTextView_isHtml) {
                this.setIsHTML(a.getBoolean(attr, false));
                continue;
            }
            if (attr != R.styleable.CustomTextView_hasLink) continue;
            this.setIsHTML(a.getBoolean(attr, false));
        }
    }

    public void displayAvailableFonts() {
        Resources res = this.getResources();
        AssetManager am = res.getAssets();
        try {
            String[] fileList;
            for (String file : fileList = am.list("fonts")) {
                Log.d((String)"", (String)file);
            }
        }
        catch (IOException e) {
            Log.e((String)"", (String)e.getMessage());
        }
    }
}

