/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.widget;

import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import fr.baloomba.ui_lib.listener.OnGestureListener;
import fr.baloomba.wsvolley.widget.NetworkImageView;

public class DoubleTapNetworkImageView
extends NetworkImageView {
    private static final String TAG = DoubleTapNetworkImageView.class.getSimpleName();
    private GestureDetectorCompat mGestureDetector;
    private OnGestureListener mListener;

    public DoubleTapNetworkImageView(Context context) {
        super(context);
    }

    public DoubleTapNetworkImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureListener());
    }

    public DoubleTapNetworkImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureListener());
    }

    public void setOnDoubleTapListener(OnGestureListener listener) {
        this.mListener = listener;
    }

    public boolean onTouchEvent(MotionEvent e) {
        return this.mGestureDetector.onTouchEvent(e);
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (DoubleTapNetworkImageView.this.mListener == null) {
                return false;
            }
            return DoubleTapNetworkImageView.this.mListener.onSingleTapConfirmed(e);
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (DoubleTapNetworkImageView.this.mListener == null) {
                return false;
            }
            return DoubleTapNetworkImageView.this.mListener.onDoubleTap(e);
        }
    }
}

