/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.helper;

import android.content.Context;
import android.content.SharedPreferences;

public class SharedPreferencesHelper {
    public static Boolean getBoolean(Context context, String name, String key, Boolean defaultValue) {
        if (context.getApplicationContext() == null) {
            return defaultValue;
        }
        SharedPreferences settings = context.getApplicationContext().getSharedPreferences(name, 0);
        return settings.getBoolean(key, defaultValue.booleanValue());
    }

    public static void putBoolean(Context context, String name, String key, Boolean value) {
        if (context.getApplicationContext() == null) {
            return;
        }
        SharedPreferences.Editor editor = context.getApplicationContext().getSharedPreferences(name, 0).edit();
        editor.putBoolean(key, value.booleanValue());
        editor.apply();
    }

    public static Float getFloat(Context context, String name, String key, Float defaultValue) {
        if (context.getApplicationContext() == null) {
            return defaultValue;
        }
        SharedPreferences settings = context.getApplicationContext().getSharedPreferences(name, 0);
        return Float.valueOf(settings.getFloat(key, defaultValue.floatValue()));
    }

    public static void putFloat(Context context, String name, String key, Float value) {
        if (context.getApplicationContext() == null) {
            return;
        }
        SharedPreferences.Editor editor = context.getApplicationContext().getSharedPreferences(name, 0).edit();
        editor.putFloat(key, value.floatValue());
        editor.apply();
    }

    public static int getInt(Context context, String name, String key, int defaultValue) {
        if (context.getApplicationContext() == null) {
            return defaultValue;
        }
        SharedPreferences settings = context.getApplicationContext().getSharedPreferences(name, 0);
        return settings.getInt(key, defaultValue);
    }

    public static void putInt(Context context, String name, String key, int value) {
        if (context.getApplicationContext() == null) {
            return;
        }
        SharedPreferences.Editor editor = context.getApplicationContext().getSharedPreferences(name, 0).edit();
        editor.putInt(key, value);
        editor.apply();
    }

    public static Long getLong(Context context, String name, String key, Long defaultValue) {
        if (context.getApplicationContext() == null) {
            return defaultValue;
        }
        SharedPreferences settings = context.getApplicationContext().getSharedPreferences(name, 0);
        return settings.getLong(key, defaultValue.longValue());
    }

    public static void putLong(Context context, String name, String key, Long value) {
        if (context.getApplicationContext() == null) {
            return;
        }
        SharedPreferences.Editor editor = context.getApplicationContext().getSharedPreferences(name, 0).edit();
        editor.putLong(key, value.longValue());
        editor.apply();
    }

    public static String getString(Context context, String name, String key, String defaultValue) {
        if (context.getApplicationContext() == null) {
            return defaultValue;
        }
        SharedPreferences settings = context.getApplicationContext().getSharedPreferences(name, 0);
        return settings.getString(key, defaultValue);
    }

    public static void putString(Context context, String name, String key, String value) {
        if (context.getApplicationContext() == null) {
            return;
        }
        SharedPreferences.Editor editor = context.getApplicationContext().getSharedPreferences(name, 0).edit();
        editor.putString(key, value);
        editor.apply();
    }

    public static void remove(Context context, String name, String key) {
        if (context.getApplicationContext() == null) {
            return;
        }
        SharedPreferences.Editor editor = context.getApplicationContext().getSharedPreferences(name, 0).edit();
        editor.remove(key);
        editor.apply();
    }
}

