/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.util.AttributeSet;
import android.view.View;
import fr.baloomba.ui_lib.R;
import fr.baloomba.ui_lib.helper.TypeFaceHelper;
import fr.baloomba.ui_lib.helper.ViewHelper;

public class TextView
extends android.widget.TextView {
    private Context mContext;
    private Boolean mIsUppercase = false;
    private Boolean mIsHTML = false;
    private Boolean mCapitalize = false;

    public TextView(Context context) {
        super(context);
        this.init(context);
    }

    public TextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
        this.initWithAttributes(context, attrs);
    }

    public TextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
        this.initWithAttributes(context, attrs);
    }

    public CharSequence getText() {
        CharSequence charSequence = super.getText();
        if (charSequence != null) {
            if (this.mCapitalize.booleanValue() && !this.mIsUppercase.booleanValue()) {
                charSequence = Character.toUpperCase(charSequence.charAt(0)) + charSequence.toString().substring(1);
            } else if (this.mIsUppercase.booleanValue()) {
                charSequence = charSequence.toString().toUpperCase();
            }
            if (this.mIsHTML.booleanValue()) {
                charSequence = Html.fromHtml((String)charSequence.toString());
            }
            return charSequence;
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ViewHelper.setAlpha((View)this, enabled ? 1.0f : 0.5f);
    }

    public void setIsUppercase(boolean isUppercase) {
        this.mIsUppercase = isUppercase;
        this.setText(this.getText());
    }

    public void setCapitalize(Boolean capitalize) {
        this.mCapitalize = capitalize;
        this.setText(this.getText());
    }

    public void setIsHTML(Boolean isHTML) {
        this.mIsHTML = isHTML;
        this.setText(this.getText());
    }

    public void setHasLink(boolean hasLink) {
        if (hasLink) {
            this.setMovementMethod(LinkMovementMethod.getInstance());
        } else {
            this.setMovementMethod(null);
        }
    }

    public void setCustomFontFile(String customFontFile) {
        if (customFontFile != null) {
            Typeface tf = TypeFaceHelper.getTypeface(this.mContext.getAssets(), customFontFile);
            this.setTypeface(tf);
            this.invalidate();
        }
    }

    private void init(Context context) {
        this.mContext = context;
    }

    private void initWithAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextView);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.TextView_customFontFile) {
                this.setCustomFontFile(a.getString(attr));
                continue;
            }
            if (attr == R.styleable.TextView_uppercase) {
                this.setIsUppercase(a.getBoolean(attr, false));
                continue;
            }
            if (attr == R.styleable.TextView_capitalize) {
                this.setCapitalize(a.getBoolean(attr, false));
                continue;
            }
            if (attr == R.styleable.TextView_isHtml) {
                this.setIsHTML(a.getBoolean(attr, false));
                continue;
            }
            if (attr != R.styleable.TextView_hasLink) continue;
            this.setHasLink(a.getBoolean(attr, false));
        }
    }
}

