/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import fr.baloomba.ui_lib.adapter.CustomFragmentPagerAdapter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class VerticalViewPager
extends ViewGroup {
    private static final String TAG = "VerticalViewPager";
    private static final boolean DEBUG = false;
    private static final boolean USE_CACHE = false;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int[] LAYOUT_ATTRS = new int[]{16842931};
    private static final Comparator<ItemInfo> COMPARATOR = new Comparator<ItemInfo>(){

        @Override
        public int compare(ItemInfo lhs, ItemInfo rhs) {
            return lhs.position - rhs.position;
        }
    };
    private static final Interpolator sInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };
    private final ArrayList<ItemInfo> mItems = new ArrayList();
    private final ItemInfo mTempItem = new ItemInfo();
    private final Rect mTempRect = new Rect();
    private CustomFragmentPagerAdapter mAdapter;
    private int mCurItem;
    private int mRestoredCurItem = -1;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private Scroller mScroller;
    private PagerObserver mObserver;
    private int mPageMargin;
    private Drawable mMarginDrawable;
    private int mLeftPageBounds;
    private int mRightPageBounds;
    private float mFirstOffset = -3.4028235E38f;
    private float mLastOffset = Float.MAX_VALUE;
    private int mChildWidthMeasureSpec;
    private boolean mInLayout;
    private boolean mScrollingCacheEnabled;
    private boolean mPopulatePending;
    private int mOffscreenPageLimit = 1;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private int mDefaultGutterSize;
    private int mGutterSize;
    private int mTouchSlop;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private float mLastMotionX;
    private float mLastMotionY;
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mFlingDistance;
    private int mCloseEnough;
    private int mSeenPositionMin;
    private int mSeenPositionMax;
    private static final int CLOSE_ENOUGH = 2;
    private boolean mFakeDragging;
    private long mFakeDragBeginTime;
    private EdgeEffectCompat mTopEdge;
    private EdgeEffectCompat mBottomEdge;
    private boolean mFirstLayout = true;
    private boolean mCalledSuper;
    private int mDecorChildCount;
    private OnPageChangeListener mOnPageChangeListener;
    private OnPageChangeListener mInternalPageChangeListener;
    private OnAdapterChangeListener mAdapterChangeListener;
    private PageTransformer mPageTransformer;
    private Method mSetChildrenDrawingOrderEnabled;
    private static final int DRAW_ORDER_DEFAULT = 0;
    private static final int DRAW_ORDER_FORWARD = 1;
    private static final int DRAW_ORDER_REVERSE = 2;
    private int mDrawingOrder;
    private ArrayList<View> mDrawingOrderedChildren;
    private static final ViewPositionComparator sPositionComparator = new ViewPositionComparator();
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private final Runnable mEndScrollRunnable = new Runnable(){

        @Override
        public void run() {
            VerticalViewPager.this.setScrollState(0);
            VerticalViewPager.this.populate();
        }
    };
    private int mScrollState = 0;

    public VerticalViewPager(Context context) {
        super(context);
        this.initViewPager();
    }

    public VerticalViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViewPager();
    }

    void initViewPager() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mTopEdge = new EdgeEffectCompat(context);
        this.mBottomEdge = new EdgeEffectCompat(context);
        float density = context.getResources().getDisplayMetrics().density;
        this.mFlingDistance = (int)(25.0f * density);
        this.mCloseEnough = (int)(2.0f * density);
        this.mDefaultGutterSize = (int)(16.0f * density);
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)new MyAccessibilityDelegate());
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, (int)1);
        }
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mEndScrollRunnable);
        super.onDetachedFromWindow();
    }

    private void setScrollState(int newState) {
        if (this.mScrollState == newState) {
            return;
        }
        this.mScrollState = newState;
        if (newState == 1) {
            this.mSeenPositionMax = -1;
            this.mSeenPositionMin = -1;
        }
        if (this.mPageTransformer != null) {
            this.enableLayers(newState != 0);
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(newState);
        }
    }

    public void setAdapter(CustomFragmentPagerAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
            this.mAdapter.startUpdate(this);
            for (int i = 0; i < this.mItems.size(); ++i) {
                ItemInfo ii = this.mItems.get(i);
                this.mAdapter.destroyItem(this, ii.position, ii.object);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeNonDecorViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        CustomFragmentPagerAdapter oldAdapter = this.mAdapter;
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.registerDataSetObserver(this.mObserver);
            this.mPopulatePending = false;
            this.mFirstLayout = true;
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else {
                this.populate();
            }
        }
        if (this.mAdapterChangeListener != null && oldAdapter != adapter) {
            this.mAdapterChangeListener.onAdapterChanged(oldAdapter, adapter);
        }
    }

    private void removeNonDecorViews() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.isDecor) continue;
            this.removeViewAt(i);
            --i;
        }
    }

    public CustomFragmentPagerAdapter getAdapter() {
        return this.mAdapter;
    }

    void setOnAdapterChangeListener(OnAdapterChangeListener listener) {
        this.mAdapterChangeListener = listener;
    }

    public void setCurrentItem(int item) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, !this.mFirstLayout, false);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, smoothScroll, false);
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always) {
        this.setCurrentItemInternal(item, smoothScroll, always, 0);
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always, int velocity) {
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (!always && this.mCurItem == item && this.mItems.size() != 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (item < 0) {
            item = 0;
        } else if (item >= this.mAdapter.getCount()) {
            item = this.mAdapter.getCount() - 1;
        }
        int pageLimit = this.mOffscreenPageLimit;
        if (item > this.mCurItem + pageLimit || item < this.mCurItem - pageLimit) {
            for (int i = 0; i < this.mItems.size(); ++i) {
                this.mItems.get((int)i).scrolling = true;
            }
        }
        boolean dispatchSelected = this.mCurItem != item;
        this.populate(item);
        this.scrollToItem(item, smoothScroll, velocity, dispatchSelected);
    }

    private void scrollToItem(int item, boolean smoothScroll, int velocity, boolean dispatchSelected) {
        ItemInfo curInfo = this.infoForPosition(item);
        int destY = 0;
        if (curInfo != null) {
            int height = this.getHeight();
            destY = (int)((float)height * Math.max(this.mFirstOffset, Math.min(curInfo.offset, this.mLastOffset)));
        }
        if (smoothScroll) {
            this.smoothScrollTo(0, destY, velocity);
            if (dispatchSelected && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(item);
            }
            if (dispatchSelected && this.mInternalPageChangeListener != null) {
                this.mInternalPageChangeListener.onPageSelected(item);
            }
        } else {
            if (dispatchSelected && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(item);
            }
            if (dispatchSelected && this.mInternalPageChangeListener != null) {
                this.mInternalPageChangeListener.onPageSelected(item);
            }
            this.completeScroll(false);
            this.scrollTo(0, destY);
        }
    }

    public void setOnPageChangeListener(OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public void setPageTransformer(boolean reverseDrawingOrder, PageTransformer transformer) {
        if (Build.VERSION.SDK_INT >= 11) {
            boolean hasTransformer = transformer != null;
            boolean needsPopulate = hasTransformer != (this.mPageTransformer != null);
            this.mPageTransformer = transformer;
            this.setChildrenDrawingOrderEnabledCompat(hasTransformer);
            this.mDrawingOrder = hasTransformer ? (reverseDrawingOrder ? 2 : 1) : 0;
            if (needsPopulate) {
                this.populate();
            }
        }
    }

    void setChildrenDrawingOrderEnabledCompat(boolean enable) {
        if (this.mSetChildrenDrawingOrderEnabled == null) {
            try {
                this.mSetChildrenDrawingOrderEnabled = ViewGroup.class.getDeclaredMethod("setChildrenDrawingOrderEnabled", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                Log.e((String)TAG, (String)"Can't find setChildrenDrawingOrderEnabled", (Throwable)e);
            }
        }
        try {
            this.mSetChildrenDrawingOrderEnabled.invoke((Object)this, enable);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error changing children drawing order", (Throwable)e);
        }
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        int index = this.mDrawingOrder == 2 ? childCount - 1 - i : i;
        int result = ((LayoutParams)this.mDrawingOrderedChildren.get((int)index).getLayoutParams()).childIndex;
        return result;
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener listener) {
        OnPageChangeListener oldListener = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = listener;
        return oldListener;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public void setOffscreenPageLimit(int limit) {
        if (limit < 1) {
            Log.w((String)TAG, (String)("Requested offscreen page limit " + limit + " too small; defaulting to " + 1));
            limit = 1;
        }
        if (limit != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = limit;
            this.populate();
        }
    }

    public void setPageMargin(int marginPixels) {
        int oldMargin = this.mPageMargin;
        this.mPageMargin = marginPixels;
        int width = this.getWidth();
        this.recomputeScrollPosition(width, width, marginPixels, oldMargin);
        this.requestLayout();
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    public void setPageMarginDrawable(Drawable d) {
        this.mMarginDrawable = d;
        if (d != null) {
            this.refreshDrawableState();
        }
        this.setWillNotDraw(d == null);
        this.invalidate();
    }

    public void setPageMarginDrawable(int resId) {
        this.setPageMarginDrawable(this.getContext().getResources().getDrawable(resId));
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mMarginDrawable;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable d = this.mMarginDrawable;
        if (d != null && d.isStateful()) {
            d.setState(this.getDrawableState());
        }
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    void smoothScrollTo(int x, int y) {
        this.smoothScrollTo(x, y, 0);
    }

    void smoothScrollTo(int x, int y, int velocity) {
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        if (dx == 0 && dy == 0) {
            this.completeScroll(false);
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.setScrollState(2);
        int height = this.getHeight();
        int halfHeight = height / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dx) / (float)height);
        float distance = (float)halfHeight + (float)halfHeight * this.distanceInfluenceForSnapDuration(distanceRatio);
        int duration = 0;
        velocity = Math.abs(velocity);
        if (velocity > 0) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
        } else {
            float pageHeight = (float)height * this.mAdapter.getPageHeight(this.mCurItem);
            float pageDelta = (float)Math.abs(dx) / (pageHeight + (float)this.mPageMargin);
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, 600);
        this.mScroller.startScroll(sx, sy, dx, dy, duration);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    ItemInfo addNewItem(int position, int index) {
        ItemInfo ii = new ItemInfo();
        ii.position = position;
        ii.object = this.mAdapter.instantiateItem(this, position);
        ii.widthFactor = this.mAdapter.getPageWidth(position);
        ii.heightFactor = this.mAdapter.getPageHeight(position);
        if (index < 0 || index >= this.mItems.size()) {
            this.mItems.add(ii);
        } else {
            this.mItems.add(index, ii);
        }
        return ii;
    }

    void dataSetChanged() {
        boolean needPopulate = this.mItems.size() < this.mOffscreenPageLimit * 2 + 1 && this.mItems.size() < this.mAdapter.getCount();
        int newCurrItem = this.mCurItem;
        boolean isUpdating = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            int newPos = this.mAdapter.getItemPosition(ii.object);
            if (newPos == -1) continue;
            if (newPos == -2) {
                this.mItems.remove(i);
                --i;
                if (!isUpdating) {
                    this.mAdapter.startUpdate(this);
                    isUpdating = true;
                }
                this.mAdapter.destroyItem(this, ii.position, ii.object);
                needPopulate = true;
                if (this.mCurItem != ii.position) continue;
                newCurrItem = Math.max(0, Math.min(this.mCurItem, this.mAdapter.getCount() - 1));
                needPopulate = true;
                continue;
            }
            if (ii.position == newPos) continue;
            if (ii.position == this.mCurItem) {
                newCurrItem = newPos;
            }
            ii.position = newPos;
            needPopulate = true;
        }
        if (isUpdating) {
            this.mAdapter.finishUpdate(this);
        }
        Collections.sort(this.mItems, COMPARATOR);
        if (needPopulate) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.isDecor) continue;
                lp.widthFactor = 0.0f;
                lp.heightFactor = 0.0f;
            }
            this.setCurrentItemInternal(newCurrItem, false, true);
            this.requestLayout();
        }
    }

    void populate() {
        this.populate(this.mCurItem);
    }

    void populate(int newCurrentItem) {
        boolean sort;
        ItemInfo oldCurInfo = null;
        if (this.mCurItem != newCurrentItem) {
            oldCurInfo = this.infoForPosition(this.mCurItem);
            this.mCurItem = newCurrentItem;
        }
        if (this.mAdapter == null) {
            return;
        }
        if (this.mPopulatePending) {
            return;
        }
        if (this.getWindowToken() == null) {
            return;
        }
        this.mAdapter.startUpdate(this);
        int pageLimit = this.mOffscreenPageLimit;
        int startPos = Math.max(0, this.mCurItem - pageLimit);
        int N = this.mAdapter.getCount();
        int endPos = Math.min(N - 1, this.mCurItem + pageLimit);
        int curIndex = -1;
        ItemInfo curItem = null;
        for (curIndex = 0; curIndex < this.mItems.size(); ++curIndex) {
            ItemInfo ii = this.mItems.get(curIndex);
            if (ii.position < this.mCurItem) continue;
            if (ii.position != this.mCurItem) break;
            curItem = ii;
            break;
        }
        if (curItem == null && N > 0) {
            curItem = this.addNewItem(this.mCurItem, curIndex);
        }
        if (curItem != null) {
            float extraHeightLeft = 0.0f;
            int itemIndex = curIndex - 1;
            ItemInfo ii = itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
            float topHeightNeeded = 2.0f - curItem.heightFactor;
            for (int pos = this.mCurItem - 1; pos >= 0; --pos) {
                if (extraHeightLeft >= topHeightNeeded && pos < startPos) {
                    if (ii == null) break;
                    if (pos != ii.position || ii.scrolling) continue;
                    this.mItems.remove(itemIndex);
                    this.mAdapter.destroyItem(this, pos, ii.object);
                    --curIndex;
                    ii = --itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
                    continue;
                }
                if (ii != null && pos == ii.position) {
                    extraHeightLeft += ii.heightFactor;
                    ii = --itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
                    continue;
                }
                ii = this.addNewItem(pos, itemIndex + 1);
                extraHeightLeft += ii.heightFactor;
                ++curIndex;
                ii = itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
            }
            float extraHeightBottom = curItem.heightFactor;
            itemIndex = curIndex + 1;
            if (extraHeightBottom < 2.0f) {
                ii = itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                for (int pos = this.mCurItem + 1; pos < N; ++pos) {
                    if (extraHeightBottom >= 2.0f && pos > endPos) {
                        if (ii == null) break;
                        if (pos != ii.position || ii.scrolling) continue;
                        this.mItems.remove(itemIndex);
                        this.mAdapter.destroyItem(this, pos, ii.object);
                        ii = itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                        continue;
                    }
                    if (ii != null && pos == ii.position) {
                        extraHeightBottom += ii.heightFactor;
                        ii = ++itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                        continue;
                    }
                    ii = this.addNewItem(pos, itemIndex);
                    extraHeightBottom += ii.heightFactor;
                    ii = ++itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                }
            }
            this.calculatePageOffsets(curItem, curIndex, oldCurInfo);
        }
        this.mAdapter.setPrimaryItem(this, this.mCurItem, curItem != null ? curItem.object : null);
        this.mAdapter.finishUpdate(this);
        boolean bl = sort = this.mDrawingOrder != 0;
        if (sort) {
            if (this.mDrawingOrderedChildren == null) {
                this.mDrawingOrderedChildren = new ArrayList();
            } else {
                this.mDrawingOrderedChildren.clear();
            }
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.childIndex = i;
            if (!lp.isDecor && lp.heightFactor == 0.0f && (ii = this.infoForChild(child)) != null) {
                lp.heightFactor = ii.heightFactor;
                lp.position = ii.position;
            }
            if (!sort) continue;
            this.mDrawingOrderedChildren.add(child);
        }
        if (sort) {
            Collections.sort(this.mDrawingOrderedChildren, sPositionComparator);
        }
        if (this.hasFocus()) {
            ItemInfo ii;
            View currentFocused = this.findFocus();
            ItemInfo itemInfo = ii = currentFocused != null ? this.infoForAnyChild(currentFocused) : null;
            if (ii == null || ii.position != this.mCurItem) {
                View child;
                for (int i = 0; !(i >= this.getChildCount() || (ii = this.infoForChild(child = this.getChildAt(i))) != null && ii.position == this.mCurItem && child.requestFocus(2)); ++i) {
                }
            }
        }
    }

    private void calculatePageOffsets(ItemInfo curItem, int curIndex, ItemInfo oldCurInfo) {
        float marginOffset;
        int N = this.mAdapter.getCount();
        int height = this.getHeight();
        float f = marginOffset = height > 0 ? (float)this.mPageMargin / (float)height : 0.0f;
        if (oldCurInfo != null) {
            int pos;
            float offset;
            ItemInfo ii;
            int itemIndex;
            int oldCurPosition = oldCurInfo.position;
            if (oldCurPosition < curItem.position) {
                itemIndex = 0;
                ii = null;
                offset = oldCurInfo.offset + oldCurInfo.heightFactor + marginOffset;
                for (pos = oldCurPosition + 1; pos <= curItem.position && itemIndex < this.mItems.size(); ++pos) {
                    ii = this.mItems.get(itemIndex);
                    while (pos > ii.position && itemIndex < this.mItems.size() - 1) {
                        ii = this.mItems.get(++itemIndex);
                    }
                    while (pos < ii.position) {
                        offset += this.mAdapter.getPageHeight(pos) + marginOffset;
                        ++pos;
                    }
                    ii.offset = offset;
                    offset += ii.heightFactor + marginOffset;
                }
            } else if (oldCurPosition > curItem.position) {
                itemIndex = this.mItems.size() - 1;
                ii = null;
                offset = oldCurInfo.offset;
                for (pos = oldCurPosition - 1; pos >= curItem.position && itemIndex >= 0; --pos) {
                    ii = this.mItems.get(itemIndex);
                    while (pos < ii.position && itemIndex > 0) {
                        ii = this.mItems.get(--itemIndex);
                    }
                    while (pos > ii.position) {
                        offset -= this.mAdapter.getPageHeight(pos) + marginOffset;
                        --pos;
                    }
                    ii.offset = offset -= ii.heightFactor + marginOffset;
                }
            }
        }
        int itemCount = this.mItems.size();
        float offset = curItem.offset;
        int pos = curItem.position - 1;
        this.mFirstOffset = curItem.position == 0 ? curItem.offset : -3.4028235E38f;
        this.mLastOffset = curItem.position == N - 1 ? curItem.offset + curItem.heightFactor - 1.0f : Float.MAX_VALUE;
        int i = curIndex - 1;
        while (i >= 0) {
            ItemInfo ii = this.mItems.get(i);
            while (pos > ii.position) {
                offset -= this.mAdapter.getPageHeight(pos--) + marginOffset;
            }
            ii.offset = offset -= ii.heightFactor + marginOffset;
            if (ii.position == 0) {
                this.mFirstOffset = offset;
            }
            --i;
            --pos;
        }
        offset = curItem.offset + curItem.heightFactor + marginOffset;
        pos = curItem.position + 1;
        i = curIndex + 1;
        while (i < itemCount) {
            ItemInfo ii = this.mItems.get(i);
            while (pos < ii.position) {
                offset += this.mAdapter.getPageHeight(pos++) + marginOffset;
            }
            if (ii.position == N - 1) {
                this.mLastOffset = offset + ii.heightFactor - 1.0f;
            }
            ii.offset = offset;
            offset += ii.heightFactor + marginOffset;
            ++i;
            ++pos;
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.position = this.mCurItem;
        if (this.mAdapter != null) {
            ss.adapterState = this.mAdapter.saveState();
        }
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (this.mAdapter != null) {
            this.mAdapter.restoreState(ss.adapterState, ss.loader);
            this.setCurrentItemInternal(ss.position, false, true);
        } else {
            this.mRestoredCurItem = ss.position;
            this.mRestoredAdapterState = ss.adapterState;
            this.mRestoredClassLoader = ss.loader;
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (!this.checkLayoutParams(params)) {
            params = this.generateLayoutParams(params);
        }
        LayoutParams lp = (LayoutParams)params;
        lp.isDecor |= child instanceof Decor;
        if (this.mInLayout) {
            if (lp != null && lp.isDecor) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            lp.needsMeasure = true;
            this.addViewInLayout(child, index, params);
        } else {
            super.addView(child, index, params);
        }
    }

    ItemInfo infoForChild(View child) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!this.mAdapter.isViewFromObject(child, ii.object)) continue;
            return ii;
        }
        return null;
    }

    ItemInfo infoForAnyChild(View child) {
        ViewParent parent;
        while ((parent = child.getParent()) != this) {
            if (parent == null || !(parent instanceof View)) {
                return null;
            }
            child = (View)parent;
        }
        return this.infoForChild(child);
    }

    ItemInfo infoForPosition(int position) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (ii.position != position) continue;
            return ii;
        }
        return null;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        LayoutParams lp;
        View child;
        int i;
        this.setMeasuredDimension(VerticalViewPager.getDefaultSize((int)0, (int)widthMeasureSpec), VerticalViewPager.getDefaultSize((int)0, (int)heightMeasureSpec));
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        int maxGutterSize = measuredHeight / 10;
        this.mGutterSize = Math.min(maxGutterSize, this.mDefaultGutterSize);
        int childWidthSize = measuredWidth - this.getPaddingLeft() - this.getPaddingRight();
        int childHeightSize = measuredHeight - this.getPaddingTop() - this.getPaddingBottom();
        int size = this.getChildCount();
        for (i = 0; i < size; ++i) {
            boolean consumeHorizontal;
            child = this.getChildAt(i);
            if (child.getVisibility() == 8 || (lp = (LayoutParams)child.getLayoutParams()) == null || !lp.isDecor) continue;
            int hgrav = lp.gravity & 7;
            int vgrav = lp.gravity & 0x70;
            int widthMode = Integer.MIN_VALUE;
            int heightMode = Integer.MIN_VALUE;
            boolean consumeVertical = vgrav == 48 || vgrav == 80;
            boolean bl = consumeHorizontal = hgrav == 3 || hgrav == 5;
            if (consumeVertical) {
                widthMode = 0x40000000;
            } else if (consumeHorizontal) {
                heightMode = 0x40000000;
            }
            int widthSize = childWidthSize;
            int heightSize = childHeightSize;
            if (lp.width != -2) {
                widthMode = 0x40000000;
                if (lp.width != -1) {
                    widthSize = lp.width;
                }
            }
            if (lp.height != -2) {
                heightMode = 0x40000000;
                if (lp.height != -1) {
                    heightSize = lp.height;
                }
            }
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
            child.measure(widthSpec, heightSpec);
            if (consumeVertical) {
                childHeightSize -= child.getMeasuredHeight();
                continue;
            }
            if (!consumeHorizontal) continue;
            childWidthSize -= child.getMeasuredWidth();
        }
        this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        size = this.getChildCount();
        for (i = 0; i < size; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8 || (lp = (LayoutParams)child.getLayoutParams()) != null && lp.isDecor) continue;
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)childHeightSize * lp.heightFactor)), (int)0x40000000);
            child.measure(this.mChildWidthMeasureSpec, heightSpec);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.recomputeScrollPosition(w, oldw, this.mPageMargin, this.mPageMargin);
        }
    }

    private void recomputeScrollPosition(int height, int oldHeight, int margin, int oldMargin) {
        if (oldHeight > 0 && !this.mItems.isEmpty()) {
            int heightWithMargin = height + margin;
            int oldHeightWithMargin = oldHeight + oldMargin;
            int ypos = this.getScrollY();
            float pageOffset = (float)ypos / (float)oldHeightWithMargin;
            int newOffsetPixels = (int)(pageOffset * (float)heightWithMargin);
            this.scrollTo(this.getScrollX(), newOffsetPixels);
            if (!this.mScroller.isFinished()) {
                int newDuration = this.mScroller.getDuration() - this.mScroller.timePassed();
                ItemInfo targetInfo = this.infoForPosition(this.mCurItem);
                this.mScroller.startScroll(0, newOffsetPixels, 0, (int)(targetInfo.offset * (float)height), newDuration);
            }
        } else {
            ItemInfo ii = this.infoForPosition(this.mCurItem);
            float scrollOffset = ii != null ? Math.min(ii.offset, this.mLastOffset) : 0.0f;
            int scrollPos = (int)(scrollOffset * (float)height);
            if (scrollPos != this.getScrollY()) {
                this.completeScroll(false);
                this.scrollTo(this.getScrollX(), scrollPos);
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        LayoutParams lp;
        View child;
        int i;
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int count = this.getChildCount();
        int width = r - l;
        int height = b - t;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int scrollY = this.getScrollY();
        int decorCount = 0;
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            lp = (LayoutParams)child.getLayoutParams();
            int childLeft = 0;
            int childTop = 0;
            if (!lp.isDecor) continue;
            int hgrav = lp.gravity & 7;
            int vgrav = lp.gravity & 0x70;
            switch (hgrav) {
                default: {
                    childLeft = paddingLeft;
                    break;
                }
                case 3: {
                    childLeft = paddingLeft;
                    paddingLeft += child.getMeasuredWidth();
                    break;
                }
                case 1: {
                    childLeft = Math.max((width - child.getMeasuredWidth()) / 2, paddingLeft);
                    break;
                }
                case 5: {
                    childLeft = width - paddingRight - child.getMeasuredWidth();
                    paddingRight += child.getMeasuredWidth();
                }
            }
            switch (vgrav) {
                default: {
                    childTop = paddingTop;
                    break;
                }
                case 48: {
                    childTop = paddingTop;
                    paddingTop += child.getMeasuredHeight();
                    break;
                }
                case 16: {
                    childTop = Math.max((height - child.getMeasuredHeight()) / 2, paddingTop);
                    break;
                }
                case 80: {
                    childTop = height - paddingBottom - child.getMeasuredHeight();
                    paddingBottom += child.getMeasuredHeight();
                }
            }
            child.layout(childLeft, childTop += scrollY, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
            ++decorCount;
        }
        for (i = 0; i < count; ++i) {
            ItemInfo ii;
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            lp = (LayoutParams)child.getLayoutParams();
            if (lp.isDecor || (ii = this.infoForChild(child)) == null) continue;
            int loff = (int)((float)height * ii.offset);
            int childLeft = paddingLeft;
            int childTop = paddingTop = loff;
            if (lp.needsMeasure) {
                lp.needsMeasure = false;
                int widthSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)(width - paddingLeft - paddingRight) * lp.widthFactor)), (int)0x40000000);
                int heightSpec = View.MeasureSpec.makeMeasureSpec((int)(height - paddingTop - paddingBottom), (int)0x40000000);
                child.measure(widthSpec, heightSpec);
            }
            child.layout(childLeft, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
        }
        this.mLeftPageBounds = paddingLeft;
        this.mRightPageBounds = width - paddingRight;
        this.mDecorChildCount = decorCount;
        this.mFirstLayout = false;
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
                if (!this.pageScrolled(x)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, y);
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll(true);
    }

    private boolean pageScrolled(int ypos) {
        if (this.mItems.size() == 0) {
            this.mCalledSuper = false;
            this.onPageScrolled(0, 0.0f, 0);
            if (!this.mCalledSuper) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
            return false;
        }
        ItemInfo ii = this.infoForCurrentScrollPosition();
        int height = this.getHeight();
        int heightWithMargin = height + this.mPageMargin;
        float marginOffset = (float)this.mPageMargin / (float)height;
        int currentPage = ii.position;
        float pageOffset = ((float)ypos / (float)height - ii.offset) / (ii.heightFactor + marginOffset);
        int offsetPixels = (int)(pageOffset * (float)heightWithMargin);
        this.mCalledSuper = false;
        this.onPageScrolled(currentPage, pageOffset, offsetPixels);
        if (!this.mCalledSuper) {
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
        return true;
    }

    protected void onPageScrolled(int position, float offset, int offsetPixels) {
        int scrollY;
        if (this.mDecorChildCount > 0) {
            scrollY = this.getScrollY();
            int paddingTop = this.getPaddingTop();
            int paddingBottom = this.getPaddingBottom();
            int height = this.getHeight();
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (!lp.isDecor) continue;
                int vgrav = lp.gravity & 0x70;
                int childTop = 0;
                switch (vgrav) {
                    default: {
                        childTop = paddingTop;
                        break;
                    }
                    case 48: {
                        childTop = paddingTop;
                        paddingTop += child.getHeight();
                        break;
                    }
                    case 16: {
                        childTop = Math.max((height - child.getMeasuredHeight()) / 2, paddingTop);
                        break;
                    }
                    case 80: {
                        childTop = height - paddingBottom - child.getMeasuredHeight();
                        paddingBottom += child.getMeasuredHeight();
                    }
                }
                int childOffset = (childTop += scrollY) - child.getTop();
                if (childOffset == 0) continue;
                child.offsetTopAndBottom(childOffset);
            }
        }
        if (this.mSeenPositionMin < 0 || position < this.mSeenPositionMin) {
            this.mSeenPositionMin = position;
        }
        if (this.mSeenPositionMax < 0 || FloatMath.ceil((float)((float)position + offset)) > (float)this.mSeenPositionMax) {
            this.mSeenPositionMax = position + 1;
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(position, offset, offsetPixels);
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageScrolled(position, offset, offsetPixels);
        }
        if (this.mPageTransformer != null) {
            scrollY = this.getScrollY();
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.isDecor) continue;
                float transformPos = (float)(child.getTop() - scrollY) / (float)this.getHeight();
                this.mPageTransformer.transformPage(child, transformPos);
            }
        }
        this.mCalledSuper = true;
    }

    private void completeScroll(boolean postEvents) {
        boolean needPopulate;
        boolean bl = needPopulate = this.mScrollState == 2;
        if (needPopulate) {
            this.setScrollingCacheEnabled(false);
            this.mScroller.abortAnimation();
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
            }
        }
        this.mPopulatePending = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!ii.scrolling) continue;
            needPopulate = true;
            ii.scrolling = false;
        }
        if (needPopulate) {
            if (postEvents) {
                ViewCompat.postOnAnimation((View)this, (Runnable)this.mEndScrollRunnable);
            } else {
                this.mEndScrollRunnable.run();
            }
        }
    }

    private boolean isGutterDrag(float y, float dy) {
        return y < (float)this.mGutterSize && dy > 0.0f || y > (float)(this.getHeight() - this.mGutterSize) && dy < 0.0f;
    }

    private void enableLayers(boolean enable) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            int layerType = enable ? 2 : 0;
            ViewCompat.setLayerType((View)this.getChildAt(i), (int)layerType, null);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 3 || action == 1) {
            this.mIsBeingDragged = false;
            this.mIsUnableToDrag = false;
            this.mActivePointerId = -1;
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            return false;
        }
        if (action != 0) {
            if (this.mIsBeingDragged) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (action) {
            case 2: {
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
                float x = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
                float dx = x - this.mLastMotionX;
                float xDiff = Math.abs(dx);
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                float dy = y - this.mLastMotionY;
                float yDiff = Math.abs(y - this.mLastMotionY);
                if (dy != 0.0f && !this.isGutterDrag(this.mLastMotionY, dy) && this.canScroll((View)this, false, (int)dy, (int)x, (int)y)) {
                    this.mInitialMotionY = this.mLastMotionY = y;
                    this.mLastMotionX = x;
                    this.mIsUnableToDrag = true;
                    return false;
                }
                if (yDiff > (float)this.mTouchSlop && yDiff > xDiff) {
                    this.mIsBeingDragged = true;
                    this.setScrollState(1);
                    this.mLastMotionY = dy > 0.0f ? this.mInitialMotionY + (float)this.mTouchSlop : this.mInitialMotionY - (float)this.mTouchSlop;
                    this.setScrollingCacheEnabled(true);
                } else if (xDiff > (float)this.mTouchSlop) {
                    this.mIsUnableToDrag = true;
                }
                if (!this.mIsBeingDragged || !this.performDrag(y)) break;
                ViewCompat.postInvalidateOnAnimation((View)this);
                break;
            }
            case 0: {
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                this.mLastMotionX = ev.getX();
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mIsUnableToDrag = false;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState == 2 && Math.abs(this.mScroller.getFinalY() - this.mScroller.getCurrY()) > this.mCloseEnough) {
                    this.mScroller.abortAnimation();
                    this.mPopulatePending = false;
                    this.populate();
                    this.mIsBeingDragged = true;
                    this.setScrollState(1);
                    break;
                }
                this.completeScroll(false);
                this.mIsBeingDragged = false;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mFakeDragging) {
            return true;
        }
        if (ev.getAction() == 0 && ev.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        boolean needsInvalidate = false;
        switch (action & 0xFF) {
            case 0: {
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mIsBeingDragged = true;
                this.setScrollState(1);
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                break;
            }
            case 2: {
                if (!this.mIsBeingDragged) {
                    int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                    float x = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
                    float xDiff = Math.abs(x - this.mLastMotionX);
                    float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                    float yDiff = Math.abs(y - this.mLastMotionY);
                    if (yDiff > (float)this.mTouchSlop && yDiff > xDiff) {
                        this.mIsBeingDragged = true;
                        this.mLastMotionY = y - this.mInitialMotionY > 0.0f ? this.mInitialMotionY + (float)this.mTouchSlop : this.mInitialMotionY - (float)this.mTouchSlop;
                        this.setScrollState(1);
                        this.setScrollingCacheEnabled(true);
                    }
                }
                if (!this.mIsBeingDragged) break;
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)activePointerIndex);
                needsInvalidate |= this.performDrag(y);
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int initialVelocity = (int)VelocityTrackerCompat.getYVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                this.mPopulatePending = true;
                int height = this.getHeight();
                int scrollY = this.getScrollY();
                ItemInfo ii = this.infoForCurrentScrollPosition();
                int currentPage = ii.position;
                float pageOffset = ((float)scrollY / (float)height - ii.offset) / ii.heightFactor;
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)activePointerIndex);
                int totalDelta = (int)(y - this.mInitialMotionX);
                int nextPage = this.determineTargetPage(currentPage, pageOffset, initialVelocity, totalDelta);
                this.setCurrentItemInternal(nextPage, true, true, initialVelocity);
                this.mActivePointerId = -1;
                this.endDrag();
                needsInvalidate = this.mTopEdge.onRelease() | this.mBottomEdge.onRelease();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.scrollToItem(this.mCurItem, true, 0, false);
                this.mActivePointerId = -1;
                this.endDrag();
                needsInvalidate = this.mTopEdge.onRelease() | this.mBottomEdge.onRelease();
                break;
            }
            case 5: {
                float y;
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mLastMotionY = y = MotionEventCompat.getY((MotionEvent)ev, (int)index);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastMotionY = MotionEventCompat.getY((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
            }
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
        return true;
    }

    private boolean performDrag(float y) {
        boolean needsInvalidate = false;
        float deltaY = this.mLastMotionY - y;
        this.mLastMotionY = y;
        float oldScrollY = this.getScrollY();
        float scrollY = oldScrollY + deltaY;
        int height = this.getHeight();
        float topBound = (float)height * this.mFirstOffset;
        float bottomBound = (float)height * this.mLastOffset;
        boolean topAbsolute = true;
        boolean bottomAbsolute = true;
        ItemInfo firstItem = this.mItems.get(0);
        ItemInfo lastItem = this.mItems.get(this.mItems.size() - 1);
        if (firstItem.position != 0) {
            topAbsolute = false;
            topBound = firstItem.offset * (float)height;
        }
        if (lastItem.position != this.mAdapter.getCount() - 1) {
            bottomAbsolute = false;
            bottomBound = lastItem.offset * (float)height;
        }
        if (scrollY < topBound) {
            if (topAbsolute) {
                float over = topBound - scrollY;
                needsInvalidate = this.mTopEdge.onPull(Math.abs(over) / (float)height);
            }
            scrollY = topBound;
        } else if (scrollY > bottomBound) {
            if (bottomAbsolute) {
                float over = scrollY - bottomBound;
                needsInvalidate = this.mBottomEdge.onPull(Math.abs(over) / (float)height);
            }
            scrollY = bottomBound;
        }
        this.mLastMotionY += scrollY - (float)((int)scrollY);
        this.scrollTo(this.getScrollX(), (int)scrollY);
        this.pageScrolled((int)scrollY);
        return needsInvalidate;
    }

    private ItemInfo infoForCurrentScrollPosition() {
        int height = this.getHeight();
        float scrollOffset = height > 0 ? (float)this.getScrollY() / (float)height : 0.0f;
        float marginOffset = height > 0 ? (float)this.mPageMargin / (float)height : 0.0f;
        int lastPos = -1;
        float lastOffset = 0.0f;
        float lastHeight = 0.0f;
        boolean first = true;
        ItemInfo lastItem = null;
        for (int i = 0; i < this.mItems.size(); ++i) {
            float offset;
            ItemInfo ii = this.mItems.get(i);
            if (!first && ii.position != lastPos + 1) {
                ii = this.mTempItem;
                ii.offset = lastOffset + lastHeight + marginOffset;
                ii.position = lastPos + 1;
                ii.widthFactor = this.mAdapter.getPageWidth(ii.position);
                --i;
            }
            float topBound = offset = ii.offset;
            float bottomBound = offset + ii.heightFactor + marginOffset;
            if (first || scrollOffset >= topBound) {
                if (scrollOffset < bottomBound || i == this.mItems.size() - 1) {
                    return ii;
                }
            } else {
                return lastItem;
            }
            first = false;
            lastPos = ii.position;
            lastOffset = offset;
            lastHeight = ii.heightFactor;
            lastItem = ii;
        }
        return lastItem;
    }

    private int determineTargetPage(int currentPage, float pageOffset, int velocity, int deltaY) {
        int targetPage = Math.abs(deltaY) > this.mFlingDistance && Math.abs(velocity) > this.mMinimumVelocity ? (velocity > 0 ? currentPage : currentPage + 1) : (this.mSeenPositionMin >= 0 && this.mSeenPositionMin < currentPage && pageOffset < 0.5f ? currentPage + 1 : (this.mSeenPositionMax >= 0 && this.mSeenPositionMax > currentPage + 1 && pageOffset >= 0.5f ? currentPage - 1 : (int)((float)currentPage + pageOffset + 0.5f)));
        if (this.mItems.size() > 0) {
            ItemInfo firstItem = this.mItems.get(0);
            ItemInfo lastItem = this.mItems.get(this.mItems.size() - 1);
            targetPage = Math.max(firstItem.position, Math.min(targetPage, lastItem.position));
        }
        return targetPage;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        boolean needsInvalidate = false;
        int overScrollMode = ViewCompat.getOverScrollMode((View)this);
        if (overScrollMode == 0 || overScrollMode == 1 && this.mAdapter != null && this.mAdapter.getCount() > 1) {
            int width;
            int height;
            if (!this.mTopEdge.isFinished()) {
                height = this.getHeight();
                width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                this.mTopEdge.setSize(width, height);
                needsInvalidate |= this.mTopEdge.draw(canvas);
            }
            if (!this.mBottomEdge.isFinished()) {
                height = this.getHeight();
                width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                this.mBottomEdge.setSize(width, height);
                needsInvalidate |= this.mBottomEdge.draw(canvas);
            }
        } else {
            this.mTopEdge.finish();
            this.mBottomEdge.finish();
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && this.mItems.size() > 0 && this.mAdapter != null) {
            int scrollY = this.getScrollY();
            int height = this.getHeight();
            float marginOffset = (float)this.mPageMargin / (float)height;
            int itemIndex = 0;
            ItemInfo ii = this.mItems.get(0);
            float offset = ii.offset;
            int itemCount = this.mItems.size();
            int firstPos = ii.position;
            int lastPos = this.mItems.get((int)(itemCount - 1)).position;
            for (int pos = firstPos; pos < lastPos; ++pos) {
                float drawAt;
                while (pos > ii.position && itemIndex < itemCount) {
                    ii = this.mItems.get(++itemIndex);
                }
                if (pos == ii.position) {
                    drawAt = (ii.offset + ii.heightFactor) * (float)height;
                    offset = ii.offset + ii.heightFactor + marginOffset;
                } else {
                    float heightFactor = this.mAdapter.getPageHeight(pos);
                    drawAt = (offset + heightFactor) * (float)height;
                    offset += heightFactor + marginOffset;
                }
                if (drawAt + (float)this.mPageMargin > (float)scrollY) {
                    this.mMarginDrawable.setBounds(this.mLeftPageBounds, (int)drawAt, this.mRightPageBounds, (int)(drawAt + (float)this.mPageMargin + 0.5f));
                    this.mMarginDrawable.draw(canvas);
                }
                if (drawAt > (float)(scrollY + height)) break;
            }
        }
    }

    public boolean beginFakeDrag() {
        if (this.mIsBeingDragged) {
            return false;
        }
        this.mFakeDragging = true;
        this.setScrollState(1);
        this.mLastMotionY = 0.0f;
        this.mInitialMotionY = 0.0f;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
        long time = SystemClock.uptimeMillis();
        MotionEvent ev = MotionEvent.obtain((long)time, (long)time, (int)0, (float)0.0f, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(ev);
        ev.recycle();
        this.mFakeDragBeginTime = time;
        return true;
    }

    public void endFakeDrag() {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        VelocityTracker velocityTracker = this.mVelocityTracker;
        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
        int initialVelocity = (int)VelocityTrackerCompat.getYVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
        this.mPopulatePending = true;
        int height = this.getHeight();
        int scrollY = this.getScrollY();
        ItemInfo ii = this.infoForCurrentScrollPosition();
        int currentPage = ii.position;
        float pageOffset = ((float)scrollY / (float)height - ii.offset) / ii.heightFactor;
        int totalDelta = (int)(this.mLastMotionY - this.mInitialMotionY);
        int nextPage = this.determineTargetPage(currentPage, pageOffset, initialVelocity, totalDelta);
        this.setCurrentItemInternal(nextPage, true, true, initialVelocity);
        this.endDrag();
        this.mFakeDragging = false;
    }

    public void fakeDragBy(float yOffset) {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        this.mLastMotionY += yOffset;
        float oldScrollY = this.getScrollY();
        float scrollY = oldScrollY - yOffset;
        int height = this.getHeight();
        float topBound = (float)height * this.mFirstOffset;
        float bottomBound = (float)height * this.mLastOffset;
        ItemInfo firstItem = this.mItems.get(0);
        ItemInfo lastItem = this.mItems.get(this.mItems.size() - 1);
        if (firstItem.position != 0) {
            topBound = firstItem.offset * (float)height;
        }
        if (lastItem.position != this.mAdapter.getCount() - 1) {
            bottomBound = lastItem.offset * (float)height;
        }
        if (scrollY < topBound) {
            scrollY = topBound;
        } else if (scrollY > bottomBound) {
            scrollY = bottomBound;
        }
        this.mLastMotionY += scrollY - (float)((int)scrollY);
        this.scrollTo(this.getScrollX(), (int)scrollY);
        this.pageScrolled((int)scrollY);
        long time = SystemClock.uptimeMillis();
        MotionEvent ev = MotionEvent.obtain((long)this.mFakeDragBeginTime, (long)time, (int)2, (float)0.0f, (float)this.mLastMotionY, (int)0);
        this.mVelocityTracker.addMovement(ev);
        ev.recycle();
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionY = MotionEventCompat.getY((MotionEvent)ev, (int)newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void setScrollingCacheEnabled(boolean enabled) {
        if (this.mScrollingCacheEnabled != enabled) {
            this.mScrollingCacheEnabled = enabled;
        }
    }

    protected boolean canScroll(View v, boolean checkV, int dy, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dy, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                return true;
            }
        }
        return checkV && ViewCompat.canScrollVertically((View)v, (int)(-dy));
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    public boolean executeKeyEvent(KeyEvent event) {
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 21: {
                    handled = this.arrowScroll(17);
                    break;
                }
                case 22: {
                    handled = this.arrowScroll(66);
                    break;
                }
                case 61: {
                    if (Build.VERSION.SDK_INT < 11) break;
                    if (KeyEventCompat.hasNoModifiers((KeyEvent)event)) {
                        handled = this.arrowScroll(2);
                        break;
                    }
                    if (!KeyEventCompat.hasModifiers((KeyEvent)event, (int)1)) break;
                    handled = this.arrowScroll(1);
                }
            }
        }
        return handled;
    }

    public boolean arrowScroll(int direction) {
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        }
        boolean handled = false;
        View nextFocused = FocusFinder.getInstance().findNextFocus((ViewGroup)this, currentFocused, direction);
        if (nextFocused != null && nextFocused != currentFocused) {
            if (direction == 33) {
                int nextUp = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)nextFocused).top;
                int currUp = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)currentFocused).top;
                handled = currentFocused != null && nextUp >= currUp ? this.pageUp() : nextFocused.requestFocus();
            } else if (direction == 66) {
                int nextDown = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)nextFocused).bottom;
                int currDown = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)currentFocused).bottom;
                handled = currentFocused != null && nextDown <= currDown ? this.pageDown() : nextFocused.requestFocus();
            }
        } else if (direction == 17 || direction == 1) {
            handled = this.pageUp();
        } else if (direction == 66 || direction == 2) {
            handled = this.pageDown();
        }
        if (handled) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)direction));
        }
        return handled;
    }

    private Rect getChildRectInPagerCoordinates(Rect outRect, View child) {
        if (outRect == null) {
            outRect = new Rect();
        }
        if (child == null) {
            outRect.set(0, 0, 0, 0);
            return outRect;
        }
        outRect.left = child.getLeft();
        outRect.right = child.getRight();
        outRect.top = child.getTop();
        outRect.bottom = child.getBottom();
        ViewParent parent = child.getParent();
        while (parent instanceof ViewGroup && parent != this) {
            ViewGroup group = (ViewGroup)parent;
            outRect.left += group.getLeft();
            outRect.right += group.getRight();
            outRect.top += group.getTop();
            outRect.bottom += group.getBottom();
            parent = group.getParent();
        }
        return outRect;
    }

    boolean pageUp() {
        if (this.mCurItem > 0) {
            this.setCurrentItem(this.mCurItem - 1, true);
            return true;
        }
        return false;
    }

    boolean pageDown() {
        if (this.mAdapter != null && this.mCurItem < this.mAdapter.getCount() - 1) {
            this.setCurrentItem(this.mCurItem + 1, true);
            return true;
        }
        return false;
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        int focusableCount = views.size();
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability != 393216) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ItemInfo ii;
                View child = this.getChildAt(i);
                if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem) continue;
                child.addFocusables(views, direction, focusableMode);
            }
        }
        if (descendantFocusability != 262144 || focusableCount == views.size()) {
            if (!this.isFocusable()) {
                return;
            }
            if ((focusableMode & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                return;
            }
            if (views != null) {
                views.add((View)this);
            }
        }
    }

    public void addTouchables(ArrayList<View> views) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem) continue;
            child.addTouchables(views);
        }
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        int end;
        int increment;
        int index;
        int count = this.getChildCount();
        if ((direction & 0x82) != 0) {
            index = 0;
            increment = 1;
            end = count;
        } else {
            index = count - 1;
            increment = -1;
            end = -1;
        }
        for (int i = index; i != end; i += increment) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem || !child.requestFocus(direction, previouslyFocusedRect)) continue;
            return true;
        }
        return false;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem || !child.dispatchPopulateAccessibilityEvent(event)) continue;
            return true;
        }
        return false;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return this.generateDefaultLayoutParams();
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    static class ViewPositionComparator
    implements Comparator<View> {
        ViewPositionComparator() {
        }

        @Override
        public int compare(View lhs, View rhs) {
            LayoutParams llp = (LayoutParams)lhs.getLayoutParams();
            LayoutParams rlp = (LayoutParams)rhs.getLayoutParams();
            if (llp.isDecor != rlp.isDecor) {
                return llp.isDecor ? 1 : -1;
            }
            return llp.position - rlp.position;
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public boolean isDecor;
        public int gravity;
        float widthFactor = 0.0f;
        float heightFactor = 0.0f;
        boolean needsMeasure;
        int position;
        int childIndex;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, LAYOUT_ATTRS);
            this.gravity = a.getInteger(0, 48);
            a.recycle();
        }
    }

    private class PagerObserver
    extends DataSetObserver {
        private PagerObserver() {
        }

        public void onChanged() {
            VerticalViewPager.this.dataSetChanged();
        }

        public void onInvalidated() {
            VerticalViewPager.this.dataSetChanged();
        }
    }

    class MyAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        MyAccessibilityDelegate() {
        }

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(host, event);
            event.setClassName((CharSequence)VerticalViewPager.class.getName());
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.setClassName((CharSequence)VerticalViewPager.class.getName());
            info.setScrollable(VerticalViewPager.this.mAdapter != null && VerticalViewPager.this.mAdapter.getCount() > 1);
            if (VerticalViewPager.this.mAdapter != null && VerticalViewPager.this.mCurItem >= 0 && VerticalViewPager.this.mCurItem < VerticalViewPager.this.mAdapter.getCount() - 1) {
                info.addAction(4096);
            }
            if (VerticalViewPager.this.mAdapter != null && VerticalViewPager.this.mCurItem > 0 && VerticalViewPager.this.mCurItem < VerticalViewPager.this.mAdapter.getCount()) {
                info.addAction(8192);
            }
        }

        public boolean performAccessibilityAction(View host, int action, Bundle args) {
            if (super.performAccessibilityAction(host, action, args)) {
                return true;
            }
            switch (action) {
                case 4096: {
                    if (VerticalViewPager.this.mAdapter != null && VerticalViewPager.this.mCurItem >= 0 && VerticalViewPager.this.mCurItem < VerticalViewPager.this.mAdapter.getCount() - 1) {
                        VerticalViewPager.this.setCurrentItem(VerticalViewPager.this.mCurItem + 1);
                        return true;
                    }
                    return false;
                }
                case 8192: {
                    if (VerticalViewPager.this.mAdapter != null && VerticalViewPager.this.mCurItem > 0 && VerticalViewPager.this.mCurItem < VerticalViewPager.this.mAdapter.getCount()) {
                        VerticalViewPager.this.setCurrentItem(VerticalViewPager.this.mCurItem - 1);
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        int position;
        Parcelable adapterState;
        ClassLoader loader;
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        });

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.position);
            out.writeParcelable(this.adapterState, flags);
        }

        public String toString() {
            return "FragmentPager.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " position=" + this.position + "}";
        }

        SavedState(Parcel in, ClassLoader loader) {
            super(in);
            if (loader == null) {
                loader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.position = in.readInt();
            this.adapterState = in.readParcelable(loader);
            this.loader = loader;
        }
    }

    static interface Decor {
    }

    static interface OnAdapterChangeListener {
        public void onAdapterChanged(FragmentPagerAdapter var1, FragmentPagerAdapter var2);
    }

    public static interface PageTransformer {
        public void transformPage(View var1, float var2);
    }

    public static class SimpleOnPageChangeListener
    implements OnPageChangeListener {
        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        @Override
        public void onPageSelected(int position) {
        }

        @Override
        public void onPageScrollStateChanged(int state) {
        }
    }

    public static interface OnPageChangeListener {
        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);

        public void onPageScrollStateChanged(int var1);
    }

    static class ItemInfo {
        Object object;
        int position;
        boolean scrolling;
        float widthFactor;
        float heightFactor;
        float offset;

        ItemInfo() {
        }
    }
}

