/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import fr.baloomba.ui_lib.R;
import fr.baloomba.ui_lib.helper.TypeFaceHelper;
import fr.baloomba.ui_lib.helper.ViewHelper;

public class EditText
extends android.widget.EditText {
    private Context mContext;

    public EditText(Context context) {
        super(context);
        this.init(context);
    }

    public EditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
        this.initWithAttributes(context, attrs);
    }

    public EditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
        this.initWithAttributes(context, attrs);
    }

    public void setCustomFontFile(String customFontFile) {
        if (customFontFile != null) {
            Typeface tf = TypeFaceHelper.getTypeface(this.mContext.getAssets(), customFontFile);
            this.setTypeface(tf);
            this.invalidate();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ViewHelper.setAlpha((View)this, enabled ? 1.0f : 0.5f);
    }

    private void init(Context context) {
        this.mContext = context;
    }

    private void initWithAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EditText);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr != R.styleable.EditText_customFontFile) continue;
            this.setCustomFontFile(a.getString(attr));
        }
    }
}

