/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import fr.baloomba.ui_lib.R;
import fr.baloomba.ui_lib.helper.TypeFaceHelper;
import fr.baloomba.ui_lib.helper.ViewHelper;

public class RadioButton
extends android.widget.RadioButton {
    private Context mContext;
    private Boolean mIsUppercase = false;

    public RadioButton(Context context) {
        super(context);
        this.init(context);
    }

    public RadioButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
        this.initWithAttributes(context, attrs);
    }

    public RadioButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
        this.initWithAttributes(context, attrs);
    }

    private void init(Context context) {
        this.mContext = context;
    }

    private void initWithAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RadioButton);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.RadioButton_customFontFile) {
                this.setCustomFontFile(a.getString(attr));
                continue;
            }
            if (attr != R.styleable.RadioButton_uppercase) continue;
            this.setIsUppercase(a.getBoolean(attr, false));
        }
    }

    public CharSequence getText() {
        CharSequence charSequence = super.getText();
        return charSequence != null && this.mIsUppercase != false ? charSequence.toString().toUpperCase() : charSequence;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ViewHelper.setAlpha((View)this, enabled ? 1.0f : 0.5f);
    }

    public void setIsUppercase(boolean isUppercase) {
        this.mIsUppercase = isUppercase;
        this.setText(this.getText());
    }

    public void setCustomFontFile(String customFontFile) {
        if (customFontFile != null) {
            Typeface tf = TypeFaceHelper.getTypeface(this.mContext.getAssets(), customFontFile);
            this.setTypeface(tf);
            this.invalidate();
        }
    }
}

