/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import fr.baloomba.ui_lib.R;

public class RatioImageView
extends ImageView {
    private static final String TAG = RatioImageView.class.getSimpleName();
    private Boolean mRatio = false;

    public RatioImageView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public RatioImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public RatioImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        Drawable drawable = this.getDrawable();
        if (this.mRatio.booleanValue() && drawable != null) {
            float ratio = (float)drawable.getIntrinsicHeight() / (float)drawable.getIntrinsicWidth();
            height = (int)(ratio * (float)width);
        }
        this.setMeasuredDimension(width, height);
    }

    public void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a;
        if (attrs != null && (a = context.obtainStyledAttributes(attrs, R.styleable.RatioImageView, defStyle, 0)) != null) {
            this.mRatio = a.getBoolean(R.styleable.RatioImageView_use_ratio, false);
            a.recycle();
        }
    }
}

