/*
 * Decompiled with CFR 0.152.
 */
package fr.baloomba.ui_lib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import fr.baloomba.ui_lib.R;

public class WebView
extends android.webkit.WebView {
    protected String mContentHead;
    protected String mContentBody;
    protected Boolean mTransparentBackground = false;

    public WebView(Context context) {
        super(context);
        this.init(context);
        this.init(context, null, 0);
    }

    public WebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
        this.initWithAttributes(context, attrs);
        this.init(context, attrs, 0);
    }

    public WebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
        this.initWithAttributes(context, attrs);
        this.init(context, attrs, defStyle);
    }

    public void setContentHead(String contentHead) {
        this.mContentHead = contentHead;
        this.fill();
    }

    public void setContentBody(String contentBody) {
        this.mContentBody = contentBody;
        this.fill();
    }

    protected void init(Context context) {
    }

    protected void initWithAttributes(Context context, AttributeSet attrs) {
    }

    protected void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a;
        if (attrs != null && (a = context.obtainStyledAttributes(attrs, R.styleable.WebView, defStyle, 0)) != null) {
            this.mContentHead = a.getString(R.styleable.WebView_head);
            this.mContentBody = a.getString(R.styleable.WebView_body);
            this.mTransparentBackground = a.getBoolean(R.styleable.WebView_transparentBackground, false);
            a.recycle();
        }
        this.fill();
    }

    public void fill() {
        String content = "<!DOCTYPE html><html>";
        if (this.mContentHead != null) {
            content = content + "<head>" + this.mContentHead + "</head>";
        }
        content = content + "<body>" + this.mContentBody + "</body>" + "</html>";
        this.loadDataWithBaseURL("file:///android_asset/", content, "text/html", "utf-8", null);
        if (this.mTransparentBackground.booleanValue()) {
            this.setBackgroundColor(0);
        }
    }
}

