/*
 * Decompiled with CFR 0.152.
 */
package fr.bigray.json;

import fr.bigray.json.JsonValue;
import fr.bigray.json.utils.SafeValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public class JsonNumber
implements JsonValue {
    private BigDecimal value;

    public JsonNumber(BigDecimal value) {
        this.value = SafeValue.safe(value);
    }

    public JsonNumber(BigInteger value) {
        this.value = SafeValue.safe(new BigDecimal(value));
    }

    public JsonNumber(Integer value) {
        this.value = SafeValue.safe(new BigDecimal(value));
    }

    public JsonNumber(Long value) {
        this.value = SafeValue.safe(BigDecimal.valueOf(value));
    }

    public JsonNumber(Double value) {
        this.value = SafeValue.safe(BigDecimal.valueOf(value));
    }

    @Override
    public String toJson() {
        return this.value.toPlainString();
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String toString() {
        return "JsonNumber{value=" + this.value + '}';
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof JsonNumber)) {
            return true;
        }
        JsonNumber jsonNumber = (JsonNumber)obj;
        return Objects.equals(this.value, jsonNumber.getValue());
    }
}

