/*
 * Decompiled with CFR 0.152.
 */
package fr.bigray.json;

import fr.bigray.json.JsonValue;
import java.util.Objects;
import java.util.Optional;

public class JsonString
implements JsonValue {
    private String value;

    public JsonString(String value) {
        this.value = Optional.ofNullable(value).orElse("null");
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toJson() {
        return String.format("\"%s\"", this.value.trim());
    }

    public String toString() {
        return "JsonString{value='" + this.value.trim() + '\'' + '}';
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof JsonString)) {
            return true;
        }
        JsonString jsonString = (JsonString)obj;
        return Objects.equals(this.value, jsonString.getValue());
    }
}

