/*
 * Decompiled with CFR 0.152.
 */
package fr.bigray.json.parser;

import fr.bigray.json.JsonArray;
import fr.bigray.json.JsonBoolean;
import fr.bigray.json.JsonNull;
import fr.bigray.json.JsonNumber;
import fr.bigray.json.JsonObject;
import fr.bigray.json.JsonString;
import fr.bigray.json.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class JsonParser {
    private static final int OPEN_BRACE = 123;
    private static final int CLOSE_BRACE = 125;
    private static final int OPEN_BRACKET = 91;
    private static final int CLOSE_BRACKET = 93;
    private static final int DBL_QUOTE = 34;
    private static final int COMMA = 44;

    public static JsonValue parse(String json) {
        char firstCharacter = json.charAt(0);
        char lastCharacter = json.charAt(json.length() - 1);
        if (JsonParser.isJson(123, 125).test(Character.valueOf(firstCharacter), Character.valueOf(lastCharacter))) {
            JsonObject jsonValue = JsonObject.createObject();
            JsonParser.split(json).stream().map(entry -> entry.trim().split(":", 2)).forEach(keysValues -> {
                String key = keysValues[0];
                String value = keysValues[1];
                char firstChar = value.charAt(0);
                char lastChar = value.charAt(value.length() - 1);
                if (JsonParser.isJson(123, 125).or(JsonParser.isJson(91, 93)).test(Character.valueOf(firstChar), Character.valueOf(lastChar))) {
                    jsonValue.$(key.trim(), JsonParser.parse(value));
                } else {
                    jsonValue.$(key.trim(), JsonParser.wrap(value.trim()));
                }
            });
            return jsonValue;
        }
        if (JsonParser.isJson(91, 93).test(Character.valueOf(firstCharacter), Character.valueOf(lastCharacter))) {
            JsonArray jsonValue = JsonArray.createArray();
            JsonParser.split(json).forEach(value -> {
                char firstChar = value.charAt(0);
                char lastChar = value.charAt(value.length() - 1);
                if (JsonParser.isJson(123, 125).or(JsonParser.isJson(91, 93)).test(Character.valueOf(firstChar), Character.valueOf(lastChar))) {
                    jsonValue.$(JsonParser.parse(value));
                } else {
                    jsonValue.$(JsonParser.wrap(value.trim()));
                }
            });
            return jsonValue;
        }
        throw new RuntimeException("Is not a valid json!");
    }

    private static BiPredicate<Character, Character> isJson(int open, int close) {
        return (firstChar, lastChar) -> firstChar.charValue() == open && lastChar.charValue() == close;
    }

    private static List<Character> splitToCharList(String jsonToSplit) {
        return jsonToSplit.trim().chars().mapToObj(item -> Character.valueOf((char)item)).collect(Collectors.toList());
    }

    private static boolean stringIsNumber(String value) {
        try {
            new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean stringIsBoolean(String value) {
        return Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value);
    }

    private static boolean stringIsNull(String value) {
        return value == null || value.isEmpty() || value.equals("null");
    }

    private static JsonValue wrap(String value) {
        if (JsonParser.stringIsBoolean(value)) {
            return new JsonBoolean(Boolean.valueOf(value));
        }
        if (JsonParser.stringIsNull(value)) {
            return new JsonNull();
        }
        if (JsonParser.stringIsNumber(value)) {
            return new JsonNumber(new BigDecimal(value));
        }
        return new JsonString(value);
    }

    private static List<String> split(String json) {
        ArrayList<String> jsonEntryList = new ArrayList<String>();
        List<Character> jsonChar = JsonParser.splitToCharList(json);
        jsonChar.remove(0);
        jsonChar.remove(jsonChar.size() - 1);
        int lastCharacterIdx = jsonChar.size() - 1;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder jsValueBuilder = new StringBuilder();
        boolean inJsValue = false;
        block8: for (int i = 0; i < jsonChar.size(); ++i) {
            switch (jsonChar.get(i).charValue()) {
                case '{': {
                    jsValueBuilder.append(jsonChar.get(i));
                    inJsValue = true;
                    continue block8;
                }
                case '}': {
                    jsValueBuilder.append(jsonChar.get(i));
                    stringBuilder.append(jsValueBuilder.toString());
                    if (lastCharacterIdx == i) {
                        jsonEntryList.add(stringBuilder.toString());
                    }
                    jsValueBuilder = new StringBuilder();
                    inJsValue = false;
                    continue block8;
                }
                case '[': {
                    jsValueBuilder.append(jsonChar.get(i));
                    inJsValue = true;
                    continue block8;
                }
                case ']': {
                    jsValueBuilder.append(jsonChar.get(i));
                    stringBuilder.append(jsValueBuilder.toString());
                    if (lastCharacterIdx == i) {
                        jsonEntryList.add(stringBuilder.toString());
                    }
                    jsValueBuilder = new StringBuilder();
                    inJsValue = false;
                    continue block8;
                }
                case ',': {
                    if (inJsValue) {
                        jsValueBuilder.append(jsonChar.get(i));
                        continue block8;
                    }
                    jsonEntryList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    continue block8;
                }
                case '\"': {
                    if (i != jsonChar.size() - 1) continue block8;
                    jsonEntryList.add(stringBuilder.toString());
                    continue block8;
                }
                default: {
                    if (inJsValue) {
                        jsValueBuilder.append(jsonChar.get(i));
                        continue block8;
                    }
                    if (lastCharacterIdx == i) {
                        stringBuilder.append(jsonChar.get(i));
                        jsonEntryList.add(stringBuilder.toString());
                        continue block8;
                    }
                    stringBuilder.append(jsonChar.get(i));
                }
            }
        }
        return jsonEntryList;
    }
}

