package fr.bmartel.bboxapi.manager

import fr.bmartel.bboxapi.BboxApiProto
import java.io.PrintWriter
import java.io.StringWriter
import java.util.*

class Utils {

    companion object {

        fun buildActionResponseError(type: BboxApiProto.ErrorType, message: String, stacktrace: String? = null): BboxApiProto.ActionResponse {
            return BboxApiProto.ActionResponse.newBuilder()
                    .setError(buildError(type, message, stacktrace)).build()
        }

        fun buildResourceResponseError(type: BboxApiProto.ErrorType, message: String, stacktrace: String? = null): BboxApiProto.ResourceResponse {
            return BboxApiProto.ResourceResponse.newBuilder()
                    .setError(buildError(type, message, stacktrace)).build()
        }

        fun buildResponseMessage(builder: BboxApiProto.BboxApiResponse.Builder, serverSentAt: Long, receivedAt: Long): BboxApiProto.BboxApiResponse.Builder {
            val timingBuilder = BboxApiProto.Timing.newBuilder()
                    .setClientReceivedAt(receivedAt)
                    .setClientSentAt(Date().time)
            if (serverSentAt > 0) {
                timingBuilder.serverSentAt = serverSentAt
            }
            return builder.setTiming(timingBuilder)
        }

        private fun buildError(type: BboxApiProto.ErrorType, message: String, stacktrace: String?): BboxApiProto.ErrorResponse.Builder? {
            val error = BboxApiProto.ErrorResponse.newBuilder()
                    .setType(type)
                    .setMessage(message)
            if (stacktrace != null) {
                error.stacktrace = stacktrace
            }
            return error
        }

        /**
         * Convert map<string, list<string>> to map<string, HeaderItem>
         */
        fun convertHeaders(headers: Map<String, List<String>>): Map<String, BboxApiProto.HeaderItem> {
            val protoHeaders = mutableMapOf<String, BboxApiProto.HeaderItem>()
            for (entry in headers) {
                protoHeaders[entry.key] = BboxApiProto.HeaderItem.newBuilder().addAllData(entry.value).build()
            }
            return protoHeaders
        }

        /**
         * convert exception to string (https://stackoverflow.com/a/7242653/2614364).
         */
        fun exceptionToString(exception: Exception): String {
            val writer = StringWriter()
            exception.printStackTrace(PrintWriter(writer))
            return writer.toString()
        }
    }
}