/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.bboxapi.manager;

import android.content.Context;
import android.os.Handler;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import fr.bmartel.bboxapi.BboxApiProto;
import fr.bmartel.bboxapi.manager.ApiUtils;
import fr.bmartel.bboxapi.manager.Utils;
import fr.bmartel.bboxapi.router.BboxApiRouter;
import fr.bmartel.bboxapi.stb.BboxApiStb;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lfr/bmartel/bboxapi/manager/ApiManager;", "", "context", "Landroid/content/Context;", "appId", "", "appSecret", "handler", "Landroid/os/Handler;", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Landroid/os/Handler;)V", "bboxApiRouter", "Lfr/bmartel/bboxapi/router/BboxApiRouter;", "getBboxApiRouter", "()Lfr/bmartel/bboxapi/router/BboxApiRouter;", "bboxApiStb", "Lfr/bmartel/bboxapi/stb/BboxApiStb;", "getBboxApiStb", "()Lfr/bmartel/bboxapi/stb/BboxApiStb;", "process", "Lfr/bmartel/bboxapi/BboxApiProto$BboxApiResponse;", "json", "bboxapi-manager_release"})
public final class ApiManager {
    @NotNull
    private final BboxApiRouter bboxApiRouter;
    @NotNull
    private final BboxApiStb bboxApiStb;
    private final Context context;
    private final Handler handler;

    @NotNull
    public final BboxApiRouter getBboxApiRouter() {
        return this.bboxApiRouter;
    }

    @NotNull
    public final BboxApiStb getBboxApiStb() {
        return this.bboxApiStb;
    }

    @Nullable
    public final BboxApiProto.BboxApiResponse process(@NotNull String json) {
        BboxApiProto.BboxApiResponse response;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        try {
            BboxApiProto.BboxApiRequest.Builder builder = BboxApiProto.BboxApiRequest.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"BboxApiProto.BboxApiRequest.newBuilder()");
            Message.Builder builder2 = (Message.Builder)builder;
            JsonFormat.parser().ignoringUnknownFields().merge(json, builder2);
            Message message = builder2.build();
            if (message == null) {
                throw new TypeCastException("null cannot be cast to non-null type fr.bmartel.bboxapi.BboxApiProto.BboxApiRequest");
            }
            BboxApiProto.BboxApiRequest bboxApiRequest = (BboxApiProto.BboxApiRequest)message;
            long receivedAt = new Date().getTime();
            if (bboxApiRequest.hasPing()) {
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                BboxApiProto.BboxApiResponse.Builder builder3 = BboxApiProto.BboxApiResponse.newBuilder().setPing(BboxApiProto.PingResponse.newBuilder());
                Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"BboxApiProto.BboxApiResp\u2026ingResponse.newBuilder())");
                BboxApiProto.BboxApiResponse.Builder builder4 = builder3;
                long l2 = 0L;
                long l3 = l;
                response = Utils.Companion.buildResponseMessage(builder4, l3, l2).build();
            } else if (bboxApiRequest.hasStartApp()) {
                BboxApiProto.StartAppRequest startAppRequest = bboxApiRequest.getStartApp();
                Intrinsics.checkExpressionValueIsNotNull((Object)startAppRequest, (String)"bboxApiRequest.startApp");
                BboxApiProto.BboxApiResponse actionResponse = ApiUtils.Companion.startApp(this.context, startAppRequest);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l4 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder5 = BboxApiProto.BboxApiResponse.newBuilder((BboxApiProto.BboxApiResponse)actionResponse);
                Intrinsics.checkExpressionValueIsNotNull((Object)builder5, (String)"BboxApiProto.BboxApiResp\u2026ewBuilder(actionResponse)");
                BboxApiProto.BboxApiResponse.Builder builder6 = builder5;
                long l5 = l4;
                long l6 = l;
                response = Utils.Companion.buildResponseMessage(builder6, l6, l5).build();
            } else if (bboxApiRequest.hasBroadcastMessage()) {
                BboxApiProto.BroadcastMessageRequest broadcastMessageRequest = bboxApiRequest.getBroadcastMessage();
                Intrinsics.checkExpressionValueIsNotNull((Object)broadcastMessageRequest, (String)"bboxApiRequest.broadcastMessage");
                BboxApiProto.BboxApiResponse actionResponse = ApiUtils.Companion.sendBroadcastMessage(this.context, broadcastMessageRequest);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                BboxApiProto.BboxApiResponse.Builder builder7 = BboxApiProto.BboxApiResponse.newBuilder((BboxApiProto.BboxApiResponse)actionResponse);
                Intrinsics.checkExpressionValueIsNotNull((Object)builder7, (String)"BboxApiProto.BboxApiResp\u2026ewBuilder(actionResponse)");
                BboxApiProto.BboxApiResponse.Builder builder8 = builder7;
                long l7 = 0L;
                long l8 = l;
                response = Utils.Companion.buildResponseMessage(builder8, l8, l7).build();
            } else if (bboxApiRequest.hasSetVolume()) {
                BboxApiProto.VolumeRequest volumeRequest = bboxApiRequest.getSetVolume();
                Intrinsics.checkExpressionValueIsNotNull((Object)volumeRequest, (String)"bboxApiRequest.setVolume");
                int n = volumeRequest.getValue();
                BboxApiProto.VolumeRequest volumeRequest2 = bboxApiRequest.getSetVolume();
                Intrinsics.checkExpressionValueIsNotNull((Object)volumeRequest2, (String)"bboxApiRequest.setVolume");
                BboxApiProto.AudioType audioType = volumeRequest2.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)audioType, (String)"bboxApiRequest.setVolume.type");
                BboxApiProto.VolumeResponse actionResponse = ApiUtils.Companion.setVolume(this.context, n, audioType);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l9 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder9 = BboxApiProto.BboxApiResponse.newBuilder().setVolume(BboxApiProto.VolumeResponse.newBuilder((BboxApiProto.VolumeResponse)actionResponse));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder9, (String)"BboxApiProto.BboxApiResp\u2026wBuilder(actionResponse))");
                BboxApiProto.BboxApiResponse.Builder builder10 = builder9;
                long l10 = l9;
                long l11 = l;
                response = Utils.Companion.buildResponseMessage(builder10, l11, l10).build();
            } else if (bboxApiRequest.hasVolumeUp()) {
                BboxApiProto.VolumeUpRequest volumeUpRequest = bboxApiRequest.getVolumeUp();
                Intrinsics.checkExpressionValueIsNotNull((Object)volumeUpRequest, (String)"bboxApiRequest.volumeUp");
                BboxApiProto.AudioType audioType = volumeUpRequest.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)audioType, (String)"bboxApiRequest.volumeUp.type");
                BboxApiProto.VolumeResponse actionResponse = ApiUtils.Companion.setVolumeUp(this.context, audioType);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l12 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder11 = BboxApiProto.BboxApiResponse.newBuilder().setVolume(BboxApiProto.VolumeResponse.newBuilder((BboxApiProto.VolumeResponse)actionResponse));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder11, (String)"BboxApiProto.BboxApiResp\u2026wBuilder(actionResponse))");
                BboxApiProto.BboxApiResponse.Builder builder12 = builder11;
                long l13 = l12;
                long l14 = l;
                response = Utils.Companion.buildResponseMessage(builder12, l14, l13).build();
            } else if (bboxApiRequest.hasVolumeDown()) {
                BboxApiProto.VolumeDownRequest volumeDownRequest = bboxApiRequest.getVolumeDown();
                Intrinsics.checkExpressionValueIsNotNull((Object)volumeDownRequest, (String)"bboxApiRequest.volumeDown");
                BboxApiProto.AudioType audioType = volumeDownRequest.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)audioType, (String)"bboxApiRequest.volumeDown.type");
                BboxApiProto.VolumeResponse actionResponse = ApiUtils.Companion.setVolumeDown(this.context, audioType);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l15 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder13 = BboxApiProto.BboxApiResponse.newBuilder().setVolume(BboxApiProto.VolumeResponse.newBuilder((BboxApiProto.VolumeResponse)actionResponse));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder13, (String)"BboxApiProto.BboxApiResp\u2026wBuilder(actionResponse))");
                BboxApiProto.BboxApiResponse.Builder builder14 = builder13;
                long l16 = l15;
                long l17 = l;
                response = Utils.Companion.buildResponseMessage(builder14, l17, l16).build();
            } else if (bboxApiRequest.hasDisplayToast()) {
                BboxApiProto.ToastRequest toastRequest = bboxApiRequest.getDisplayToast();
                Intrinsics.checkExpressionValueIsNotNull((Object)toastRequest, (String)"bboxApiRequest.displayToast");
                BboxApiProto.BboxApiResponse actionResponse = ApiUtils.Companion.displayToast(this.context, this.handler, toastRequest);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l18 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder15 = BboxApiProto.BboxApiResponse.newBuilder((BboxApiProto.BboxApiResponse)actionResponse);
                Intrinsics.checkExpressionValueIsNotNull((Object)builder15, (String)"BboxApiProto.BboxApiResp\u2026ewBuilder(actionResponse)");
                BboxApiProto.BboxApiResponse.Builder builder16 = builder15;
                long l19 = l18;
                long l20 = l;
                response = Utils.Companion.buildResponseMessage(builder16, l20, l19).build();
            } else if (bboxApiRequest.hasMute()) {
                BboxApiProto.MuteRequest muteRequest = bboxApiRequest.getMute();
                Intrinsics.checkExpressionValueIsNotNull((Object)muteRequest, (String)"bboxApiRequest.mute");
                BboxApiProto.AudioType audioType = muteRequest.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)audioType, (String)"bboxApiRequest.mute.type");
                BboxApiProto.MuteRequest muteRequest2 = bboxApiRequest.getMute();
                Intrinsics.checkExpressionValueIsNotNull((Object)muteRequest2, (String)"bboxApiRequest.mute");
                BboxApiProto.VolumeResponse actionResponse = ApiUtils.Companion.muteVolume(this.context, audioType, muteRequest2.getState());
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l21 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder17 = BboxApiProto.BboxApiResponse.newBuilder().setVolume(BboxApiProto.VolumeResponse.newBuilder((BboxApiProto.VolumeResponse)actionResponse));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder17, (String)"BboxApiProto.BboxApiResp\u2026wBuilder(actionResponse))");
                BboxApiProto.BboxApiResponse.Builder builder18 = builder17;
                long l22 = l21;
                long l23 = l;
                response = Utils.Companion.buildResponseMessage(builder18, l23, l22).build();
            } else if (bboxApiRequest.hasWakeUp()) {
                BboxApiProto.BboxApiResponse actionResponse = ApiUtils.Companion.wakeUp(this.context);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l24 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder19 = BboxApiProto.BboxApiResponse.newBuilder((BboxApiProto.BboxApiResponse)actionResponse);
                Intrinsics.checkExpressionValueIsNotNull((Object)builder19, (String)"BboxApiProto.BboxApiResp\u2026ewBuilder(actionResponse)");
                BboxApiProto.BboxApiResponse.Builder builder20 = builder19;
                long l25 = l24;
                long l26 = l;
                response = Utils.Companion.buildResponseMessage(builder20, l26, l25).build();
            } else if (bboxApiRequest.hasGetSpideoId()) {
                BboxApiProto.SpideoIdResponse spideoIdResponse = ApiUtils.Companion.getSpideoId();
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l27 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder21 = BboxApiProto.BboxApiResponse.newBuilder().setSpideo(BboxApiProto.SpideoIdResponse.newBuilder((BboxApiProto.SpideoIdResponse)spideoIdResponse));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder21, (String)"BboxApiProto.BboxApiResp\u2026uilder(spideoIdResponse))");
                BboxApiProto.BboxApiResponse.Builder builder22 = builder21;
                long l28 = l27;
                long l29 = l;
                response = Utils.Companion.buildResponseMessage(builder22, l29, l28).build();
            } else if (bboxApiRequest.hasRouterApi()) {
                BboxApiProto.HttpRequest httpRequest = bboxApiRequest.getRouterApi();
                Intrinsics.checkExpressionValueIsNotNull((Object)httpRequest, (String)"bboxApiRequest.routerApi");
                BboxApiProto.RouterResponse actionResponse = ApiUtils.Companion.callRouterApi(this.bboxApiRouter, httpRequest);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l30 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder23 = BboxApiProto.BboxApiResponse.newBuilder().setRouter(BboxApiProto.RouterResponse.newBuilder((BboxApiProto.RouterResponse)actionResponse));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder23, (String)"BboxApiProto.BboxApiResp\u2026wBuilder(actionResponse))");
                BboxApiProto.BboxApiResponse.Builder builder24 = builder23;
                long l31 = l30;
                long l32 = l;
                response = Utils.Companion.buildResponseMessage(builder24, l32, l31).build();
            } else if (bboxApiRequest.hasStbApi()) {
                BboxApiProto.HttpRequest httpRequest = bboxApiRequest.getStbApi();
                Intrinsics.checkExpressionValueIsNotNull((Object)httpRequest, (String)"bboxApiRequest.stbApi");
                BboxApiProto.StbResponse actionResponse = ApiUtils.Companion.callStbApi(this.bboxApiStb, httpRequest);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l33 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder25 = BboxApiProto.BboxApiResponse.newBuilder().setStb(BboxApiProto.StbResponse.newBuilder((BboxApiProto.StbResponse)actionResponse));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder25, (String)"BboxApiProto.BboxApiResp\u2026wBuilder(actionResponse))");
                BboxApiProto.BboxApiResponse.Builder builder26 = builder25;
                long l34 = l33;
                long l35 = l;
                response = Utils.Companion.buildResponseMessage(builder26, l35, l34).build();
            } else if (bboxApiRequest.hasListApp()) {
                ArrayList<BboxApiProto.AndroidApp> resourceResponse = ApiUtils.Companion.buildAppList(this.context);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l36 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder27 = BboxApiProto.BboxApiResponse.newBuilder().setListApp(BboxApiProto.ListAppResponse.newBuilder().addAllApp((Iterable)resourceResponse));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder27, (String)"BboxApiProto.BboxApiResp\u2026                        )");
                BboxApiProto.BboxApiResponse.Builder builder28 = builder27;
                long l37 = l36;
                long l38 = l;
                response = Utils.Companion.buildResponseMessage(builder28, l38, l37).build();
            } else if (bboxApiRequest.hasGetVolume()) {
                Map<Integer, Integer> resourceResponse = ApiUtils.Companion.buildVolumeMap(this.context);
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                long l39 = new Date().getTime() - receivedAt;
                BboxApiProto.BboxApiResponse.Builder builder29 = BboxApiProto.BboxApiResponse.newBuilder().setVolume(BboxApiProto.VolumeResponse.newBuilder().putAllStreams(resourceResponse));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder29, (String)"BboxApiProto.BboxApiResp\u2026                        )");
                BboxApiProto.BboxApiResponse.Builder builder30 = builder29;
                long l40 = l39;
                long l41 = l;
                response = Utils.Companion.buildResponseMessage(builder30, l41, l40).build();
            } else {
                BboxApiProto.Timing timing = bboxApiRequest.getTiming();
                Intrinsics.checkExpressionValueIsNotNull((Object)timing, (String)"bboxApiRequest.timing");
                long l = timing.getServerSentAt();
                BboxApiProto.BboxApiResponse.Builder builder31 = BboxApiProto.BboxApiResponse.newBuilder().setError(Utils.Companion.buildErrorResponse$default(Utils.Companion, BboxApiProto.ErrorType.BAD_FORMAT, "bad format - invalid action", null, 4, null));
                Intrinsics.checkExpressionValueIsNotNull((Object)builder31, (String)"BboxApiProto.BboxApiResp\u2026ormat - invalid action\"))");
                BboxApiProto.BboxApiResponse.Builder builder32 = builder31;
                long l42 = 0L;
                long l43 = l;
                response = Utils.Companion.buildResponseMessage(builder32, l43, l42).build();
            }
            if (bboxApiRequest.getFf()) {
                return null;
            }
        }
        catch (InvalidProtocolBufferException e) {
            BboxApiProto.BboxApiResponse.Builder builder = BboxApiProto.BboxApiResponse.newBuilder().setError(Utils.Companion.buildErrorResponse$default(Utils.Companion, BboxApiProto.ErrorType.BAD_FORMAT, "bad format - invalid action", null, 4, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"BboxApiProto.BboxApiResp\u2026ormat - invalid action\"))");
            BboxApiProto.BboxApiResponse.Builder builder33 = builder;
            long l = 0L;
            long l44 = 0L;
            response = Utils.Companion.buildResponseMessage(builder33, l44, l).build();
        }
        return response;
    }

    public ApiManager(@NotNull Context context, @NotNull String appId, @NotNull String appSecret, @NotNull Handler handler) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        Intrinsics.checkParameterIsNotNull((Object)appSecret, (String)"appSecret");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        this.context = context;
        this.handler = handler;
        this.bboxApiRouter = new BboxApiRouter(null, null, 3, null);
        this.bboxApiStb = new BboxApiStb(appId, appSecret);
    }
}

