package fr.bmartel.bboxapi.manager

import fr.bmartel.bboxapi.BboxApiProto
import java.io.PrintWriter
import java.io.StringWriter

class Utils {

    companion object {

        fun buildErrorResponse(type: BboxApiProto.ErrorType, message: String, stacktrace: String? = null): BboxApiProto.ErrorResponse {
            return buildError(type, message, stacktrace).build()
        }

        fun buildResponseMessage(builder: BboxApiProto.BboxApiResponse.Builder, serverSentAt: Long, executionTime: Long): BboxApiProto.BboxApiResponse.Builder {
            val timingBuilder = BboxApiProto.Timing.newBuilder()
                    .setClientExecutionTime(executionTime)
            if (serverSentAt > 0) {
                timingBuilder.serverSentAt = serverSentAt
            }
            return builder.setTiming(timingBuilder)
        }

        private fun buildError(type: BboxApiProto.ErrorType, message: String, stacktrace: String?): BboxApiProto.ErrorResponse.Builder {
            val error = BboxApiProto.ErrorResponse.newBuilder()
                    .setType(type)
                    .setMessage(message)
            if (stacktrace != null) {
                error.stacktrace = stacktrace
            }
            return error
        }

        /**
         * Convert map<string, list<string>> to map<string, HeaderItem>
         */
        fun convertHeaders(headers: Map<String, List<String>>): Map<String, String> {
            val protoHeaders = mutableMapOf<String, String>()
            for (entry in headers) {
                if (entry.value.isNotEmpty()) {
                    protoHeaders[entry.key] = entry.value[0]
                }
            }
            return protoHeaders
        }

        /**
         * convert exception to string (https://stackoverflow.com/a/7242653/2614364).
         */
        fun exceptionToString(exception: Exception): String {
            val writer = StringWriter()
            exception.printStackTrace(PrintWriter(writer))
            return writer.toString()
        }
    }
}