/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.bboxapi.manager;

import fr.bmartel.bboxapi.BboxApiProto;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lfr/bmartel/bboxapi/manager/Utils;", "", "()V", "Companion", "bboxapi-manager_release"})
public final class Utils {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J,\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00150\u0013J\u0012\u0010\u0016\u001a\u00020\b2\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019J\u0006\u0010\u001a\u001a\u00020\bJ\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002\u00a8\u0006\u001d"}, d2={"Lfr/bmartel/bboxapi/manager/Utils$Companion;", "", "()V", "buildError", "Lfr/bmartel/bboxapi/BboxApiProto$ErrorResponse$Builder;", "type", "Lfr/bmartel/bboxapi/BboxApiProto$ErrorType;", "message", "", "stacktrace", "buildErrorResponse", "Lfr/bmartel/bboxapi/BboxApiProto$ErrorResponse;", "buildResponseMessage", "Lfr/bmartel/bboxapi/BboxApiProto$BboxApiResponse$Builder;", "builder", "serverSentAt", "", "executionTime", "convertHeaders", "", "headers", "", "exceptionToString", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getSpideoId", "sha256", "base", "bboxapi-manager_release"})
    public static final class Companion {
        @NotNull
        public final BboxApiProto.ErrorResponse buildErrorResponse(@NotNull BboxApiProto.ErrorType type, @NotNull String message, @Nullable String stacktrace) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            BboxApiProto.ErrorResponse errorResponse = this.buildError(type, message, stacktrace).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)errorResponse, (String)"buildError(type, message, stacktrace).build()");
            return errorResponse;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ BboxApiProto.ErrorResponse buildErrorResponse$default(Companion companion, BboxApiProto.ErrorType errorType, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.buildErrorResponse(errorType, string, string2);
        }

        @NotNull
        public final BboxApiProto.BboxApiResponse.Builder buildResponseMessage(@NotNull BboxApiProto.BboxApiResponse.Builder builder, long serverSentAt, long executionTime) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            BboxApiProto.Timing.Builder timingBuilder = BboxApiProto.Timing.newBuilder().setClientExecutionTime(executionTime);
            if (serverSentAt > 0L) {
                BboxApiProto.Timing.Builder builder2 = timingBuilder;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"timingBuilder");
                builder2.setServerSentAt(serverSentAt);
            }
            BboxApiProto.BboxApiResponse.Builder builder3 = builder.setTiming(timingBuilder);
            Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"builder.setTiming(timingBuilder)");
            return builder3;
        }

        private final BboxApiProto.ErrorResponse.Builder buildError(BboxApiProto.ErrorType type, String message, String stacktrace) {
            BboxApiProto.ErrorResponse.Builder error = BboxApiProto.ErrorResponse.newBuilder().setType(type).setMessage(message);
            if (stacktrace != null) {
                BboxApiProto.ErrorResponse.Builder builder = error;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"error");
                builder.setStacktrace(stacktrace);
            }
            BboxApiProto.ErrorResponse.Builder builder = error;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"error");
            return builder;
        }

        @NotNull
        public final Map<String, String> convertHeaders(@NotNull Map<String, ? extends List<String>> headers) {
            Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
            Map protoHeaders = new LinkedHashMap();
            Object object = headers;
            for (Map.Entry<String, ? extends List<String>> entry : object.entrySet()) {
                object = entry.getValue();
                if (!(!object.isEmpty())) continue;
                object = protoHeaders;
                String string = entry.getKey();
                String string2 = entry.getValue().get(0);
                object.put(string, string2);
            }
            return protoHeaders;
        }

        @NotNull
        public final String exceptionToString(@NotNull Exception exception) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            StringWriter writer = new StringWriter();
            exception.printStackTrace(new PrintWriter(writer));
            String string = writer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.toString()");
            return string;
        }

        @NotNull
        public final String getSpideoId() {
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface;
                    NetworkInterface networkInterface2 = networkInterface = networkInterfaces.nextElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)networkInterface2, (String)"networkInterface");
                    String networkInterfaceName = networkInterface2.getName();
                    if (!Intrinsics.areEqual((Object)"eth0", (Object)networkInterfaceName) && !Intrinsics.areEqual((Object)"wlan0", (Object)networkInterfaceName)) continue;
                    byte[] hardwareAddress = networkInterface.getHardwareAddress();
                    StringBuilder buf = new StringBuilder();
                    for (byte hardwareAddressIterator : hardwareAddress) {
                        String string;
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string2 = "%02X:";
                        Object[] objectArray = new Object[]{hardwareAddressIterator};
                        StringBuilder stringBuilder = buf;
                        Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                        stringBuilder.append(string);
                    }
                    buf.deleteCharAt(buf.length() - 1);
                    String mac = buf.toString();
                    if (!Intrinsics.areEqual((Object)"eth0", (Object)networkInterfaceName)) continue;
                    String string = mac;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mac");
                    return this.sha256(string);
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            return "";
        }

        private final String sha256(String base) {
            try {
                Object object;
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                String string = base;
                Object object2 = "UTF-8";
                MessageDigest messageDigest = digest;
                Charset charset = Charset.forName((String)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                object2 = object = charset;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes((Charset)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                object = byArray;
                byte[] hash = messageDigest.digest((byte[])object);
                StringBuilder hexString = new StringBuilder();
                for (byte aHash : hash) {
                    String hex = Integer.toHexString(aHash & 0xFF);
                    if (hex.length() == 1) {
                        hexString.append('0');
                    }
                    hexString.append(hex);
                }
                String string3 = hexString.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"hexString.toString()");
                return string3;
            }
            catch (Exception ex) {
                throw (Throwable)new RuntimeException(ex);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

