/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.bboxapi.manager;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.github.kittinunf.fuel.core.FuelError;
import com.github.kittinunf.fuel.core.FuelManager;
import com.github.kittinunf.fuel.core.HttpException;
import com.github.kittinunf.fuel.core.Method;
import com.github.kittinunf.fuel.core.Response;
import com.github.kittinunf.result.Result;
import com.google.gson.JsonSyntaxException;
import fr.bmartel.bboxapi.BboxApiProto;
import fr.bmartel.bboxapi.manager.Utils;
import fr.bmartel.bboxapi.router.BboxApiRouter;
import fr.bmartel.bboxapi.stb.BboxApiStb;
import fr.bmartel.bboxapi.stb.model.StbService;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lfr/bmartel/bboxapi/manager/ApiUtils;", "", "()V", "Companion", "bboxapi-manager_release"})
public final class ApiUtils {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$J\u001e\u0010%\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010'\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010(\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010)\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006-"}, d2={"Lfr/bmartel/bboxapi/manager/ApiUtils$Companion;", "", "()V", "buildAppList", "Ljava/util/ArrayList;", "Lfr/bmartel/bboxapi/BboxApiProto$AndroidApp;", "context", "Landroid/content/Context;", "buildVolumeMap", "", "", "callRouterApi", "Lfr/bmartel/bboxapi/BboxApiProto$RouterResponse;", "bboxapi", "Lfr/bmartel/bboxapi/router/BboxApiRouter;", "request", "Lfr/bmartel/bboxapi/BboxApiProto$HttpRequest;", "callStbApi", "Lfr/bmartel/bboxapi/BboxApiProto$StbResponse;", "Lfr/bmartel/bboxapi/stb/BboxApiStb;", "displayToast", "Lfr/bmartel/bboxapi/BboxApiProto$BboxApiResponse;", "handler", "Landroid/os/Handler;", "toastRequest", "Lfr/bmartel/bboxapi/BboxApiProto$ToastRequest;", "getSpideoId", "Lfr/bmartel/bboxapi/BboxApiProto$SpideoIdResponse;", "muteVolume", "Lfr/bmartel/bboxapi/BboxApiProto$VolumeResponse;", "type", "Lfr/bmartel/bboxapi/BboxApiProto$AudioType;", "state", "", "sendBroadcastMessage", "broadcastRequest", "Lfr/bmartel/bboxapi/BboxApiProto$BroadcastMessageRequest;", "setVolume", "volume", "setVolumeDown", "setVolumeUp", "startApp", "appRequest", "Lfr/bmartel/bboxapi/BboxApiProto$StartAppRequest;", "wakeUp", "bboxapi-manager_release"})
    public static final class Companion {
        @NotNull
        public final ArrayList<BboxApiProto.AndroidApp> buildAppList(@NotNull Context context) {
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            PackageManager pm = context.getPackageManager();
            List appList = pm.getInstalledApplications(0);
            ArrayList<BboxApiProto.AndroidApp> apps = new ArrayList<BboxApiProto.AndroidApp>();
            List list = appList;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"appList");
            Iterable iterable = list;
            void var6_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                ApplicationInfo it = (ApplicationInfo)element$iv$iv;
                if (!(pm.getLeanbackLaunchIntentForPackage(it.packageName) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                ApplicationInfo it = (ApplicationInfo)element$iv;
                apps.add(BboxApiProto.AndroidApp.newBuilder().setPackageName(it.packageName).setAppName(((Object)pm.getApplicationLabel(it)).toString()).build());
            }
            $receiver$iv = apps;
            if ($receiver$iv.size() > 1) {
                CollectionsKt.sortWith((List)$receiver$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        BboxApiProto.AndroidApp it = (BboxApiProto.AndroidApp)a;
                        Comparable comparable = (Comparable)((Object)it.getAppName());
                        it = (BboxApiProto.AndroidApp)b;
                        Comparable comparable2 = comparable;
                        String string = it.getAppName();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                });
            }
            return apps;
        }

        @NotNull
        public final Map<Integer, Integer> buildVolumeMap(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Map volumeMap = new LinkedHashMap();
            Object object = context.getSystemService("audio");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
            }
            AudioManager audio = (AudioManager)object;
            for (BboxApiProto.AudioType type : BboxApiProto.AudioType.values()) {
                Map map = volumeMap;
                Integer n = type.getNumber();
                Integer n2 = audio.getStreamVolume(type.getNumber()) * 100 / audio.getStreamMaxVolume(type.getNumber());
                map.put(n, n2);
            }
            return volumeMap;
        }

        @NotNull
        public final BboxApiProto.BboxApiResponse startApp(@NotNull Context context, @NotNull BboxApiProto.StartAppRequest appRequest) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)appRequest, (String)"appRequest");
            Intent appIntent = new Intent(appRequest.getAction());
            String launchPackage = appRequest.getPackageName();
            PackageManager pm = context.getPackageManager();
            if (appRequest.hasComponentName() && Intrinsics.areEqual((Object)appRequest.getComponentName(), (Object)"") ^ true) {
                String string = appRequest.getComponentName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"appRequest.componentName");
                if (StringsKt.indexOf$default((CharSequence)string, (char)'/', (int)0, (boolean)false, (int)6, null) != -1) {
                    ComponentName component;
                    ComponentName componentName = component = ComponentName.unflattenFromString((String)appRequest.getComponentName());
                    Intrinsics.checkExpressionValueIsNotNull((Object)componentName, (String)"component");
                    launchPackage = componentName.getPackageName();
                    appIntent.setComponent(component);
                    appIntent.setPackage(launchPackage);
                } else {
                    appIntent.setClassName(launchPackage, appRequest.getComponentName());
                    appIntent.setPackage(launchPackage);
                }
            } else if (appRequest.hasAction() && Intrinsics.areEqual((Object)appRequest.getAction(), (Object)"") ^ true) {
                appIntent.setPackage(launchPackage);
            } else {
                Intent intent = pm.getLeanbackLaunchIntentForPackage(launchPackage);
                if (intent == null) {
                    intent = appIntent = pm.getLaunchIntentForPackage(launchPackage);
                }
            }
            if (appRequest.hasData() && Intrinsics.areEqual((Object)appRequest.getData(), (Object)"") ^ true) {
                Intent intent = appIntent;
                if (intent != null) {
                    intent.setData(Uri.parse((String)appRequest.getData()));
                }
            }
            Intent intent = appIntent;
            if (intent != null) {
                intent.setFlags(0x10000000);
            }
            if (appIntent != null && pm.resolveActivity(appIntent, 0) != null) {
                context.startActivity(appIntent);
                BboxApiProto.BboxApiResponse bboxApiResponse = BboxApiProto.BboxApiResponse.newBuilder().setStatus(BboxApiProto.ActionStatus.newBuilder().setSuccess(true).setModified(false)).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)bboxApiResponse, (String)"BboxApiProto.BboxApiResp\u2026tModified(false)).build()");
                return bboxApiResponse;
            }
            BboxApiProto.BboxApiResponse bboxApiResponse = BboxApiProto.BboxApiResponse.newBuilder().setError(BboxApiProto.ErrorResponse.newBuilder().setType(BboxApiProto.ErrorType.ACTION_FAILED).setMessage("activity not found")).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)bboxApiResponse, (String)"BboxApiProto.BboxApiResp\u2026vity not found\")).build()");
            return bboxApiResponse;
        }

        @NotNull
        public final BboxApiProto.VolumeResponse setVolume(@NotNull Context context, int volume, @NotNull BboxApiProto.AudioType type) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Object object = context.getSystemService("audio");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
            }
            AudioManager audio = (AudioManager)object;
            int vol = volume;
            if (vol < 0) {
                vol = 0;
            } else if (vol > 100) {
                vol = 100;
            }
            vol = vol * audio.getStreamMaxVolume(type.getNumber()) / 100;
            if (Build.VERSION.SDK_INT >= 24) {
                vol = vol == 0 ? 1 : vol;
            }
            audio.setStreamVolume(type.getNumber(), vol, 1);
            BboxApiProto.VolumeResponse volumeResponse = BboxApiProto.VolumeResponse.newBuilder().putAllStreams(this.buildVolumeMap(context)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)volumeResponse, (String)"BboxApiProto.VolumeRespo\u2026lumeMap(context)).build()");
            return volumeResponse;
        }

        @NotNull
        public final BboxApiProto.VolumeResponse setVolumeUp(@NotNull Context context, @NotNull BboxApiProto.AudioType type) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Object object = context.getSystemService("audio");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
            }
            ((AudioManager)object).adjustStreamVolume(type.ordinal(), 1, 1);
            BboxApiProto.VolumeResponse volumeResponse = BboxApiProto.VolumeResponse.newBuilder().putAllStreams(this.buildVolumeMap(context)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)volumeResponse, (String)"BboxApiProto.VolumeRespo\u2026lumeMap(context)).build()");
            return volumeResponse;
        }

        @NotNull
        public final BboxApiProto.VolumeResponse setVolumeDown(@NotNull Context context, @NotNull BboxApiProto.AudioType type) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            if (Build.VERSION.SDK_INT >= 24) {
                int volumes;
                Integer n = this.buildVolumeMap(context).get(type.getNumber());
                int n2 = volumes = n != null ? n : 0;
                if (volumes >= 15) {
                    Object object = context.getSystemService("audio");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
                    }
                    ((AudioManager)object).adjustStreamVolume(type.ordinal(), -1, 1);
                }
            } else {
                Object object = context.getSystemService("audio");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
                }
                ((AudioManager)object).adjustStreamVolume(type.ordinal(), -1, 1);
            }
            BboxApiProto.VolumeResponse volumeResponse = BboxApiProto.VolumeResponse.newBuilder().putAllStreams(this.buildVolumeMap(context)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)volumeResponse, (String)"BboxApiProto.VolumeRespo\u2026lumeMap(context)).build()");
            return volumeResponse;
        }

        @NotNull
        public final BboxApiProto.VolumeResponse muteVolume(@NotNull Context context, @NotNull BboxApiProto.AudioType type, boolean state) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Object object = context.getSystemService("audio");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
            }
            AudioManager audio = (AudioManager)object;
            if (Build.VERSION.SDK_INT >= 24) {
                BboxApiProto.VolumeResponse volumeResponse = BboxApiProto.VolumeResponse.newBuilder().putAllStreams(this.buildVolumeMap(context)).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)volumeResponse, (String)"BboxApiProto.VolumeRespo\u2026lumeMap(context)).build()");
                return volumeResponse;
            }
            if (Build.VERSION.SDK_INT == 23) {
                audio.adjustStreamVolume(type.ordinal(), state ? -100 : 100, 1);
            } else {
                audio.setStreamMute(type.ordinal(), state);
            }
            BboxApiProto.VolumeResponse volumeResponse = BboxApiProto.VolumeResponse.newBuilder().putAllStreams(this.buildVolumeMap(context)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)volumeResponse, (String)"BboxApiProto.VolumeRespo\u2026lumeMap(context)).build()");
            return volumeResponse;
        }

        @NotNull
        public final BboxApiProto.BboxApiResponse displayToast(@NotNull Context context, @NotNull Handler handler, @NotNull BboxApiProto.ToastRequest toastRequest) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
            Intrinsics.checkParameterIsNotNull((Object)toastRequest, (String)"toastRequest");
            handler.post(new Runnable(context, toastRequest){
                final /* synthetic */ Context $context;
                final /* synthetic */ BboxApiProto.ToastRequest $toastRequest;

                public final void run() {
                    int gy;
                    int y;
                    int gx;
                    int x;
                    Pattern colorPattern;
                    Matcher m;
                    Toast toast;
                    CharSequence charSequence = this.$toastRequest.getMessage();
                    BboxApiProto.ToastDuration toastDuration = this.$toastRequest.getDuration();
                    Intrinsics.checkExpressionValueIsNotNull((Object)toastDuration, (String)"toastRequest.duration");
                    Toast toast2 = toast = Toast.makeText((Context)this.$context, (CharSequence)charSequence, (int)toastDuration.getNumber());
                    Intrinsics.checkExpressionValueIsNotNull((Object)toast2, (String)"toast");
                    View view = toast2.getView().findViewById(16908299);
                    if (view == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
                    }
                    TextView v = (TextView)view;
                    if (this.$toastRequest.hasColor() && Intrinsics.areEqual((Object)this.$toastRequest.getColor(), (Object)"") ^ true && (m = (colorPattern = Pattern.compile("#([0-9a-fA-F]{3}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})")).matcher(this.$toastRequest.getColor())).matches()) {
                        int color = Color.parseColor((String)this.$toastRequest.getColor());
                        v.setTextColor(color);
                    }
                    if (!this.$toastRequest.hasPosX() || this.$toastRequest.getPosX() < 0) {
                        x = 0;
                        gx = 1;
                    } else {
                        x = this.$toastRequest.getPosX();
                        gx = 3;
                    }
                    if (!this.$toastRequest.hasPosY() || this.$toastRequest.getPosY() < 0) {
                        y = toast.getYOffset();
                        gy = 80;
                    } else {
                        y = this.$toastRequest.getPosY();
                        gy = 48;
                    }
                    toast.setGravity(gx | gy, x, y);
                    toast.show();
                }
                {
                    this.$context = context;
                    this.$toastRequest = toastRequest;
                }
            });
            BboxApiProto.BboxApiResponse bboxApiResponse = BboxApiProto.BboxApiResponse.newBuilder().setStatus(BboxApiProto.ActionStatus.newBuilder().setModified(false).setSuccess(true)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)bboxApiResponse, (String)"BboxApiProto.BboxApiResp\u2026setSuccess(true)).build()");
            return bboxApiResponse;
        }

        @NotNull
        public final BboxApiProto.BboxApiResponse wakeUp(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("power");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.os.PowerManager");
            }
            PowerManager pm = (PowerManager)object;
            if (pm.isInteractive()) {
                BboxApiProto.BboxApiResponse bboxApiResponse = BboxApiProto.BboxApiResponse.newBuilder().setStatus(BboxApiProto.ActionStatus.newBuilder().setModified(false).setSuccess(true)).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)bboxApiResponse, (String)"BboxApiProto.BboxApiResp\u2026setSuccess(true)).build()");
                return bboxApiResponse;
            }
            PowerManager.WakeLock wakeLock = pm.newWakeLock(0x1000001A, "TAG");
            wakeLock.acquire();
            BboxApiProto.BboxApiResponse bboxApiResponse = BboxApiProto.BboxApiResponse.newBuilder().setStatus(BboxApiProto.ActionStatus.newBuilder().setModified(true).setSuccess(true)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)bboxApiResponse, (String)"BboxApiProto.BboxApiResp\u2026setSuccess(true)).build()");
            return bboxApiResponse;
        }

        @Nullable
        public final BboxApiProto.BboxApiResponse sendBroadcastMessage(@NotNull Context context, @NotNull BboxApiProto.BroadcastMessageRequest broadcastRequest) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)broadcastRequest, (String)"broadcastRequest");
            Intent intent = new Intent();
            intent.setAction(broadcastRequest.getAction());
            Map map = broadcastRequest.getExtrasMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"broadcastRequest.extrasMap");
            Map map2 = map;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                String key = (String)entry2.getKey();
                entry2 = entry;
                String value = (String)entry2.getValue();
                intent.putExtra(key, value);
            }
            iterator = broadcastRequest.getFlagList().iterator();
            while (iterator.hasNext()) {
                int flag = ((Number)((Object)iterator.next())).intValue();
                intent.addFlags(flag);
            }
            if (broadcastRequest.hasComponentName()) {
                intent.setComponent(ComponentName.unflattenFromString((String)broadcastRequest.getComponentName()));
            }
            context.sendBroadcast(intent);
            return BboxApiProto.BboxApiResponse.newBuilder().setStatus(BboxApiProto.ActionStatus.newBuilder().setSuccess(true).setModified(false)).build();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BboxApiProto.RouterResponse callRouterApi(@NotNull BboxApiRouter bboxapi, @NotNull BboxApiProto.HttpRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)bboxapi, (String)"bboxapi");
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            BboxApiProto.RouterResponse.Builder routerResponse = BboxApiProto.RouterResponse.newBuilder().setRequest(request);
            if (request.getAuth() && bboxapi.getBlocked()) {
                BboxApiProto.RouterResponse routerResponse2 = routerResponse.setError(BboxApiProto.ErrorResponse.newBuilder().setType(BboxApiProto.ErrorType.USER_BLOCKED).setMessage("user is blocked, wait until " + bboxapi.getBlockedUntil())).setAuthStatus(BboxApiProto.AuthStatus.newBuilder().setAttempts(bboxapi.getAttempts()).setAuthenticated(bboxapi.getAuthenticated()).setBlocked(bboxapi.getBlocked()).setBlockedUntil(bboxapi.getBlockedUntil().getTime())).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)routerResponse2, (String)"routerResponse\n         \u2026ockedUntil.time)).build()");
                return routerResponse2;
            }
            try {
                void response;
                FuelManager fuelManager = bboxapi.getManager();
                Method method = Method.valueOf((String)request.getMethod().name());
                String string = request.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.url");
                Triple triple = bboxapi.createCustomRequestSync(FuelManager.request$default((FuelManager)fuelManager, (Method)method, (String)string, null, (int)4, null), request.getAuth());
                Response response2 = (Response)triple.component2();
                Result result = (Result)triple.component3();
                triple = result;
                if (triple instanceof Result.Failure) {
                    FuelError ex = (FuelError)((Result.Failure)result).getException();
                    BboxApiProto.ErrorType type = BboxApiProto.ErrorType.OTHER;
                    if (ex.getException() instanceof UnknownHostException) {
                        type = BboxApiProto.ErrorType.UNKNOWN_HOST;
                    } else if (ex.getException() instanceof HttpException) {
                        type = BboxApiProto.ErrorType.HTTP_ERROR;
                    } else if (ex.getException() instanceof JsonSyntaxException) {
                        type = BboxApiProto.ErrorType.JSON_SYNTAX;
                    }
                    routerResponse.setError(BboxApiProto.ErrorResponse.newBuilder().setMessage("router request failed").setType(type).setStacktrace(Utils.Companion.exceptionToString((Exception)ex))).setAuthStatus(BboxApiProto.AuthStatus.newBuilder().setAttempts(bboxapi.getAttempts()).setAuthenticated(bboxapi.getAuthenticated()).setBlocked(bboxapi.getBlocked()).setBlockedUntil(bboxapi.getBlockedUntil().getTime()));
                    if (BboxApiProto.HttpStatus.forNumber((int)response.getStatusCode()) != null) {
                        byte[] byArray = response.getData();
                        BboxApiProto.HttpResponse.Builder builder = BboxApiProto.HttpResponse.newBuilder();
                        BboxApiProto.RouterResponse.Builder builder2 = routerResponse;
                        String string2 = new String(byArray, Charsets.UTF_8);
                        builder2.setResponse(builder.setBody(string2).putAllHeaders(Utils.Companion.convertHeaders(response.getHeaders())).setStatus(BboxApiProto.HttpStatus.forNumber((int)response.getStatusCode())));
                    }
                    BboxApiProto.RouterResponse routerResponse3 = routerResponse.build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)routerResponse3, (String)"routerResponse.build()");
                    return routerResponse3;
                }
                if (triple instanceof Result.Success) {
                    BboxApiProto.RouterResponse routerResponse4 = routerResponse.setResponse(BboxApiProto.HttpResponse.newBuilder().setBody((String)result.get()).putAllHeaders(Utils.Companion.convertHeaders(response.getHeaders())).setStatus(BboxApiProto.HttpStatus.forNumber((int)response.getStatusCode()))).setAuthStatus(BboxApiProto.AuthStatus.newBuilder().setAttempts(bboxapi.getAttempts()).setAuthenticated(bboxapi.getAuthenticated()).setBlocked(bboxapi.getBlocked()).setBlockedUntil(bboxapi.getBlockedUntil().getTime())).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)routerResponse4, (String)"routerResponse\n         \u2026ockedUntil.time)).build()");
                    return routerResponse4;
                }
                throw new NoWhenBranchMatchedException();
            }
            catch (IllegalArgumentException e) {
                BboxApiProto.RouterResponse routerResponse5 = routerResponse.setError(BboxApiProto.ErrorResponse.newBuilder().setType(BboxApiProto.ErrorType.METHOD_NOT_SUPPORTED).setMessage("method " + request.getMethod() + " is not supported")).setAuthStatus(BboxApiProto.AuthStatus.newBuilder().setAttempts(bboxapi.getAttempts()).setAuthenticated(bboxapi.getAuthenticated()).setBlocked(bboxapi.getBlocked()).setBlockedUntil(bboxapi.getBlockedUntil().getTime())).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)routerResponse5, (String)"routerResponse\n         \u2026ockedUntil.time)).build()");
                return routerResponse5;
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BboxApiProto.StbResponse callStbApi(@NotNull BboxApiStb bboxapi, @NotNull BboxApiProto.HttpRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)bboxapi, (String)"bboxapi");
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            BboxApiProto.StbResponse.Builder stbResponse = BboxApiProto.StbResponse.newBuilder().setRequest(request);
            BboxApiProto.StbServiceStatus.Builder stbServiceStatus = BboxApiProto.StbServiceStatus.newBuilder();
            if (bboxapi.getRestService() != null) {
                StbService stbService = bboxapi.getRestService();
                StbService stbService2 = bboxapi.getRestService();
                stbServiceStatus.setSelectedService(BboxApiProto.StbService.newBuilder().setIp(stbService != null ? stbService.getIp() : null).setPort(stbService2 != null ? stbService2.getPort() : -1));
            }
            for (StbService it : bboxapi.getRestServiceList()) {
                stbServiceStatus.addServices(BboxApiProto.StbService.newBuilder().setIp(it.getIp()).setPort(it.getPort()));
            }
            stbResponse.setServiceStatus(stbServiceStatus);
            if (bboxapi.getManager().getBasePath() == null) {
                stbResponse.setError(BboxApiProto.ErrorResponse.newBuilder().setMessage("no bbox api stb found on network").setType(BboxApiProto.ErrorType.BBOXAPI_UNAVAILABLE));
                BboxApiProto.StbResponse stbResponse2 = stbResponse.build();
                Intrinsics.checkExpressionValueIsNotNull((Object)stbResponse2, (String)"stbResponse.build()");
                return stbResponse2;
            }
            try {
                void response;
                StbService it;
                FuelManager fuelManager = bboxapi.getManager();
                Method method = Method.valueOf((String)request.getMethod().name());
                String string = request.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.url");
                Triple triple = bboxapi.createCustomRequestSync(FuelManager.request$default((FuelManager)fuelManager, (Method)method, (String)string, null, (int)4, null));
                it = (Response)triple.component2();
                Result result = (Result)triple.component3();
                triple = result;
                if (triple instanceof Result.Failure) {
                    FuelError ex = (FuelError)((Result.Failure)result).getException();
                    BboxApiProto.ErrorType type = BboxApiProto.ErrorType.OTHER;
                    if (ex.getException() instanceof UnknownHostException) {
                        type = BboxApiProto.ErrorType.UNKNOWN_HOST;
                    } else if (ex.getException() instanceof HttpException) {
                        type = BboxApiProto.ErrorType.HTTP_ERROR;
                    } else if (ex.getException() instanceof JsonSyntaxException) {
                        type = BboxApiProto.ErrorType.JSON_SYNTAX;
                    }
                    stbResponse.setError(BboxApiProto.ErrorResponse.newBuilder().setMessage("stb request failed").setType(type).setStacktrace(Utils.Companion.exceptionToString((Exception)ex)));
                    if (BboxApiProto.HttpStatus.forNumber((int)response.getStatusCode()) != null) {
                        byte[] byArray = response.getData();
                        BboxApiProto.HttpResponse.Builder builder = BboxApiProto.HttpResponse.newBuilder();
                        BboxApiProto.StbResponse.Builder builder2 = stbResponse;
                        String string2 = new String(byArray, Charsets.UTF_8);
                        builder2.setResponse(builder.setBody(string2).putAllHeaders(Utils.Companion.convertHeaders(response.getHeaders())).setStatus(BboxApiProto.HttpStatus.forNumber((int)response.getStatusCode())));
                    }
                    BboxApiProto.StbResponse stbResponse3 = stbResponse.build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)stbResponse3, (String)"stbResponse.build()");
                    return stbResponse3;
                }
                if (triple instanceof Result.Success) {
                    byte[] byArray = (byte[])result.get();
                    BboxApiProto.HttpResponse.Builder builder = BboxApiProto.HttpResponse.newBuilder();
                    BboxApiProto.StbResponse.Builder builder3 = stbResponse;
                    String string3 = new String(byArray, Charsets.UTF_8);
                    BboxApiProto.StbResponse stbResponse4 = builder3.setResponse(builder.setBody(string3).putAllHeaders(Utils.Companion.convertHeaders(response.getHeaders())).setStatus(BboxApiProto.HttpStatus.forNumber((int)response.getStatusCode()))).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)stbResponse4, (String)"stbResponse\n            \u2026                 .build()");
                    return stbResponse4;
                }
                throw new NoWhenBranchMatchedException();
            }
            catch (IllegalArgumentException e) {
                BboxApiProto.StbResponse stbResponse5 = stbResponse.setError(BboxApiProto.ErrorResponse.newBuilder().setType(BboxApiProto.ErrorType.METHOD_NOT_SUPPORTED).setMessage("method " + request.getMethod() + " is not supported")).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)stbResponse5, (String)"stbResponse\n            \u2026                 .build()");
                return stbResponse5;
            }
            catch (MalformedURLException e) {
                BboxApiProto.StbResponse stbResponse6 = stbResponse.setError(BboxApiProto.ErrorResponse.newBuilder().setType(BboxApiProto.ErrorType.HTTP_ERROR).setMessage("url malformed : " + request.getUrl())).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)stbResponse6, (String)"stbResponse\n            \u2026                 .build()");
                return stbResponse6;
            }
        }

        @NotNull
        public final BboxApiProto.SpideoIdResponse getSpideoId() {
            BboxApiProto.SpideoIdResponse spideoIdResponse = BboxApiProto.SpideoIdResponse.newBuilder().setId(Utils.Companion.getSpideoId()).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)spideoIdResponse, (String)"BboxApiProto.SpideoIdRes\u2026                 .build()");
            return spideoIdResponse;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

