package fr.bmartel.bboxapi.manager

import fr.bmartel.bboxapi.BboxApiProto
import java.io.PrintWriter
import java.io.StringWriter
import java.net.NetworkInterface
import java.net.NetworkInterface.getNetworkInterfaces
import java.net.SocketException
import java.security.MessageDigest
import kotlin.experimental.and


class Utils {

    companion object {

        fun buildErrorResponse(type: BboxApiProto.ErrorType, message: String, stacktrace: String? = null): BboxApiProto.ErrorResponse {
            return buildError(type, message, stacktrace).build()
        }

        fun buildResponseMessage(builder: BboxApiProto.BboxApiResponse.Builder, serverSentAt: Long, executionTime: Long): BboxApiProto.BboxApiResponse.Builder {
            val timingBuilder = BboxApiProto.Timing.newBuilder()
                    .setClientExecutionTime(executionTime)
            if (serverSentAt > 0) {
                timingBuilder.serverSentAt = serverSentAt
            }
            return builder.setTiming(timingBuilder)
        }

        private fun buildError(type: BboxApiProto.ErrorType, message: String, stacktrace: String?): BboxApiProto.ErrorResponse.Builder {
            val error = BboxApiProto.ErrorResponse.newBuilder()
                    .setType(type)
                    .setMessage(message)
            if (stacktrace != null) {
                error.stacktrace = stacktrace
            }
            return error
        }

        /**
         * Convert map<string, list<string>> to map<string, HeaderItem>
         */
        fun convertHeaders(headers: Map<String, List<String>>): Map<String, String> {
            val protoHeaders = mutableMapOf<String, String>()
            for (entry in headers) {
                if (entry.value.isNotEmpty()) {
                    protoHeaders[entry.key] = entry.value[0]
                }
            }
            return protoHeaders
        }

        /**
         * convert exception to string (https://stackoverflow.com/a/7242653/2614364).
         */
        fun exceptionToString(exception: Exception): String {
            val writer = StringWriter()
            exception.printStackTrace(PrintWriter(writer))
            return writer.toString()
        }

        fun getSpideoId(): String {
            try {
                val networkInterfaces = NetworkInterface.getNetworkInterfaces()
                while (networkInterfaces.hasMoreElements()) {
                    val networkInterface = networkInterfaces.nextElement()
                    val networkInterfaceName = networkInterface.name
                    if (!("eth0" == networkInterfaceName || "wlan0" == networkInterfaceName)) {
                        continue
                    }
                    val hardwareAddress = networkInterface.hardwareAddress
                    val buf = StringBuilder()
                    for (hardwareAddressIterator in hardwareAddress) {
                        buf.append(String.format("%02X:", hardwareAddressIterator))
                    }
                    buf.deleteCharAt(buf.length - 1)
                    val mac = buf.toString()
                    if ("eth0" == networkInterfaceName) {
                        return sha256(mac)
                    }
                }
            } catch (e: SocketException) {
                e.printStackTrace()
            }
            return ""
        }

        private fun sha256(base: String): String {
            try {
                val digest = MessageDigest.getInstance("SHA-256")
                val hash = digest.digest(base.toByteArray(charset("UTF-8")))
                val hexString = StringBuilder()

                for (aHash in hash) {
                    val hex = Integer.toHexString((aHash.toInt() and 0xff))
                    if (hex.length == 1) hexString.append('0')
                    hexString.append(hex)
                }

                return hexString.toString()
            } catch (ex: Exception) {
                throw RuntimeException(ex)
            }

        }

    }
}