/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.protocol.http;

import fr.bmartel.protocol.http.HttpReader;
import fr.bmartel.protocol.http.HttpVersion;
import fr.bmartel.protocol.http.inter.IHttpFrame;
import fr.bmartel.protocol.http.states.HttpStates;
import fr.bmartel.protocol.http.utils.IByteList;
import fr.bmartel.protocol.http.utils.ListOfBytes;
import fr.bmartel.protocol.http.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;

public class HttpFrame
implements IHttpFrame {
    private HttpVersion httpVersion = new HttpVersion(1, 1);
    private boolean isResponseFrame = false;
    private boolean isRequestFrame = false;
    private boolean chunked = false;
    private HttpReader reader = new HttpReader();
    private String host = "";
    private HashMap<String, String> headers = new HashMap();
    private String method = "";
    private String uri = "";
    private String queryString = "";
    private IByteList body = new ListOfBytes();
    private int statusCode = -1;
    private String reasonPhrase = "";

    public HttpFrame() {
        this.reader = new HttpReader();
    }

    public HttpFrame(String method, HttpVersion httpVersion, HashMap<String, String> headers, String uri, IByteList body) {
        this.httpVersion = new HttpVersion(1, 1);
        this.headers = headers;
        this.method = method;
        this.uri = uri;
        this.body = body;
    }

    public String toString() {
        String ret = "";
        ret = !this.method.equals("") ? this.method + " " + this.uri + " " + this.httpVersion.toString() + "\r\n" : this.uri + " " + this.httpVersion.toString() + "\r\n";
        if (!this.headers.containsKey("Content-Length") && this.body.getSize() > 0) {
            this.headers.put("Content-Length", String.valueOf(new String(this.body.getBytes()).length()));
        }
        Set<String> cles = this.headers.keySet();
        for (String cle : cles) {
            String valeur = this.headers.get(cle);
            ret = ret + cle.toString() + ": " + " " + valeur.toString() + "\r\n";
        }
        ret = ret + "\r\n";
        try {
            ret = ret + new String(this.body.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ret = ret + "\r\n";
        return ret;
    }

    private void cleanParser() {
        this.httpVersion = new HttpVersion(1, 1);
        this.headers = new HashMap();
        this.method = "";
        this.uri = "";
        this.body = new ListOfBytes();
        this.statusCode = -1;
        this.reasonPhrase = "";
        this.isRequestFrame = false;
        this.isResponseFrame = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpStates parseHttp(InputStream in) throws IOException, InterruptedException {
        try {
            HttpStates errorCode = HttpStates.HTTP_STATE_NONE;
            this.cleanParser();
            InputStream inputStream = in;
            synchronized (inputStream) {
                errorCode = this.decodeFrame(in);
                if (errorCode == HttpStates.HTTP_FRAME_OK) {
                    HttpStates headerError = this.parseHeader(in);
                    if (headerError == HttpStates.HTTP_FRAME_OK && this.getHeaders().containsKey("Transfer-Encoding".toLowerCase()) && this.getHeaders().get("Transfer-Encoding".toLowerCase()).toString().equals("chunked")) {
                        String t;
                        this.setChunked(true);
                        BufferedReader br = new BufferedReader(new InputStreamReader(in));
                        String ret = "";
                        boolean init = false;
                        int numberOfChar = 0;
                        boolean text = false;
                        while ((t = br.readLine()) != null) {
                            text = true;
                            if (!init || numberOfChar == 0) {
                                try {
                                    numberOfChar = (int)Long.parseLong(t.toUpperCase(), 16);
                                }
                                catch (NumberFormatException e) {
                                    break;
                                }
                                if (numberOfChar == 0) break;
                                text = false;
                                if (!init) {
                                    init = true;
                                }
                            }
                            if (!text) continue;
                            if (t.trim().equals("0")) {
                                numberOfChar = 0;
                                continue;
                            }
                            ret = ret + t;
                            numberOfChar -= t.length();
                        }
                        br.close();
                        this.body = new ListOfBytes(ret);
                    } else if (headerError == HttpStates.HTTP_FRAME_OK) {
                        this.setChunked(false);
                        return this.parseBody(in);
                    }
                    return headerError;
                }
            }
            return errorCode;
        }
        catch (SocketTimeoutException e) {
            return HttpStates.SOCKET_ERROR;
        }
    }

    private void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    public HttpStates decodeFrame(InputStream inputstream) throws IOException, InterruptedException {
        String httpFrame = null;
        httpFrame = this.reader.readLine(inputstream);
        if (httpFrame == null) {
            return HttpStates.HTTP_READING_ERROR;
        }
        if (!httpFrame.contains("HTTP")) {
            return HttpStates.MALFORMED_HTTP_FRAME;
        }
        StringTokenizer st = new StringTokenizer(httpFrame, " ");
        String firstToken = st.nextToken();
        if (firstToken.equals("POST") || firstToken.equals("GET") || firstToken.equals("OPTIONS") || firstToken.equals("DELETE") || firstToken.equals("PUT")) {
            this.method = firstToken;
            if (!st.hasMoreTokens()) {
                return HttpStates.MALFORMED_HTTP_FRAME;
            }
            this.uri = st.nextToken();
            if (!st.hasMoreTokens()) {
                return HttpStates.MALFORMED_HTTP_FRAME;
            }
            String httpVersion = st.nextToken();
            if (!httpVersion.startsWith("HTTP/")) {
                return HttpStates.HTTP_WRONG_VERSION;
            }
            this.httpVersion = new HttpVersion(httpVersion);
            this.isRequestFrame = true;
        } else if (firstToken.startsWith("HTTP/")) {
            this.httpVersion = new HttpVersion(firstToken);
            if (this.httpVersion.versionDigit1 == 0) {
                return HttpStates.HTTP_WRONG_VERSION;
            }
            if (!st.hasMoreTokens()) {
                return HttpStates.MALFORMED_HTTP_FRAME;
            }
            String statusCodeTemp = st.nextToken();
            if (!StringUtils.isInteger(statusCodeTemp)) {
                return HttpStates.MALFORMED_HTTP_FRAME;
            }
            this.statusCode = Integer.parseInt(statusCodeTemp);
            if (!st.hasMoreTokens()) {
                return HttpStates.MALFORMED_HTTP_FRAME;
            }
            this.reasonPhrase = st.nextToken();
            this.isResponseFrame = true;
        } else {
            return HttpStates.MALFORMED_HTTP_FRAME;
        }
        return HttpStates.HTTP_FRAME_OK;
    }

    public HttpStates parseHeader(InputStream inputstream) throws IOException {
        String s = this.reader.readLine(inputstream);
        while (s != null && s.length() != 0) {
            int index = s.indexOf(":");
            if (index > 0) {
                String header = s.substring(0, index).trim();
                String value = s.substring(index + 1).trim();
                String key = header.toLowerCase();
                this.headers.put(key, value);
            }
            s = this.reader.readLine(inputstream);
        }
        if (this.headers.containsKey("Host".toLowerCase())) {
            this.host = this.headers.get("Host".toLowerCase()).toString();
        }
        return HttpStates.HTTP_FRAME_OK;
    }

    public HttpStates parseBody(InputStream inputstream) throws IOException {
        int length = this.getContentLength();
        if (length > 0) {
            int numberOfBlockToWrite = length % 4089;
            int numberOfBlock = 0;
            numberOfBlock = numberOfBlockToWrite == 0 ? length / 4089 : length / 4089 + 1;
            ListOfBytes list = new ListOfBytes();
            for (int i = 0; i < numberOfBlock; ++i) {
                if (numberOfBlockToWrite != 0 && i == numberOfBlock - 1) {
                    int size = length - i * 4089;
                    byte[] data = new byte[size];
                    for (int j = 0; j < data.length; ++j) {
                        byte byteToBeRead;
                        data[j] = byteToBeRead = (byte)inputstream.read();
                    }
                    list.add(data);
                    continue;
                }
                byte[] data = new byte[4089];
                for (int j = 0; j < data.length; ++j) {
                    byte byteToBeRead;
                    data[j] = byteToBeRead = (byte)inputstream.read();
                }
                list.add(data);
            }
            if (inputstream.available() > 0) {
                if (inputstream.read() == 13) {
                    if (inputstream.read() != 10) {
                        return HttpStates.HTTP_BODY_PARSE_ERROR;
                    }
                } else {
                    return HttpStates.HTTP_BODY_PARSE_ERROR;
                }
            }
            this.body = list;
        } else {
            this.body = new ListOfBytes();
        }
        return HttpStates.HTTP_FRAME_OK;
    }

    public int getContentLength() {
        if (this.headers.containsKey("Content-Length".toLowerCase())) {
            try {
                int length = Integer.parseInt(this.headers.get("Content-Length".toLowerCase()));
                return length;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    @Override
    public HttpReader getReader() {
        return this.reader;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(HashMap<String, String> newHeaders) {
        this.headers = newHeaders;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public IByteList getBody() {
        return this.body;
    }

    @Override
    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public boolean isHttpRequestFrame() {
        return this.isRequestFrame;
    }

    @Override
    public boolean isHttpResponseFrame() {
        return this.isResponseFrame;
    }
}

