/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.protocol.http;

import fr.bmartel.protocol.http.HttpVersion;
import fr.bmartel.protocol.http.StatusCodeObject;
import fr.bmartel.protocol.http.inter.IHttpResponseFrame;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Set;

public class HttpResponseFrame
implements IHttpResponseFrame {
    private StatusCodeObject returnCode;
    private HttpVersion httpVersion;
    private HashMap<String, String> headers = new HashMap();
    private byte[] body = new byte[0];

    public HttpResponseFrame(StatusCodeObject returnCode, HttpVersion httpVersion, HashMap<String, String> headers, byte[] body) {
        this.returnCode = returnCode;
        this.httpVersion = httpVersion;
        this.headers = headers;
        this.body = body;
    }

    public String toString() {
        String ret = this.httpVersion.toString() + " " + this.returnCode.toString() + "\r\n";
        if (!this.headers.containsKey("Content-Length") && this.body.length > 0) {
            this.headers.put("Content-Length", String.valueOf(this.body.length));
        }
        Set<String> cles = this.headers.keySet();
        for (String cle : cles) {
            String valeur = this.headers.get(cle);
            ret = ret + cle.toString() + ": " + " " + valeur.toString() + "\r\n";
        }
        if (this.body.length > 0) {
            ret = ret + "\r\n";
            try {
                ret = ret + new String(this.body, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            ret = ret + "\r\n";
        } else {
            ret = ret + "\r\n";
        }
        return ret;
    }

    @Override
    public StatusCodeObject getReturnCode() {
        return this.returnCode;
    }

    @Override
    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    @Override
    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }
}

