/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest;

import fr.bmartel.speedtest.SpeedTestConst;
import fr.bmartel.speedtest.SpeedTestReport;
import fr.bmartel.speedtest.inter.IRepeatListener;
import fr.bmartel.speedtest.inter.ISpeedTestListener;
import fr.bmartel.speedtest.inter.ISpeedTestSocket;
import fr.bmartel.speedtest.model.SpeedTestError;
import fr.bmartel.speedtest.model.SpeedTestMode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class RepeatWrapper {
    private List<BigDecimal> mRepeatTransferRateList = Collections.synchronizedList(new ArrayList());
    private boolean mRepeatFinished;
    private long mRepeatTempPckSize;
    private boolean mRepeatUpload;
    private long mStartDateRepeat;
    private int mRepeatWindows;
    private int mRepeatRequestNum;
    private boolean mRepeatDownload;
    private BigDecimal mRepeatPacketSize = BigDecimal.ZERO;
    private boolean mFirstDownloadRepeat;
    private boolean mFirstUploadRepeat;
    private final ISpeedTestSocket mSpeedTestSocket;
    private Timer mTimer;

    public RepeatWrapper(ISpeedTestSocket socket) {
        this.mSpeedTestSocket = socket;
    }

    public SpeedTestReport getRepeatReport(int scale, RoundingMode roundingMode, SpeedTestMode speedTestMode, long reportTime, BigDecimal transferRateOctet) {
        BigDecimal progressPercent = BigDecimal.ZERO;
        long temporaryPacketSize = 0L;
        BigDecimal downloadRepeatRateOctet = transferRateOctet;
        long downloadRepeatReportTime = reportTime;
        if (this.mStartDateRepeat != 0L) {
            if (!this.mRepeatFinished) {
                long test = System.nanoTime() - this.mStartDateRepeat;
                progressPercent = new BigDecimal(test).multiply(SpeedTestConst.PERCENT_MAX).divide(new BigDecimal(this.mRepeatWindows).multiply(new BigDecimal(1000000)), scale, roundingMode);
            } else {
                progressPercent = SpeedTestConst.PERCENT_MAX;
            }
        } else {
            progressPercent = BigDecimal.ZERO;
        }
        BigDecimal rates = BigDecimal.ZERO;
        for (BigDecimal rate : this.mRepeatTransferRateList) {
            rates = rates.add(rate);
        }
        if (!this.mRepeatTransferRateList.isEmpty()) {
            downloadRepeatRateOctet = rates.add(downloadRepeatRateOctet).divide(new BigDecimal(this.mRepeatTransferRateList.size()).add(new BigDecimal(this.mRepeatTempPckSize).divide(this.mRepeatPacketSize, scale, roundingMode)), scale, roundingMode);
        }
        BigDecimal transferRateBit = downloadRepeatRateOctet.multiply(SpeedTestConst.BIT_MULTIPLIER);
        if (!this.mRepeatFinished) {
            temporaryPacketSize = this.mRepeatTempPckSize;
        } else {
            temporaryPacketSize = this.mRepeatTempPckSize;
            downloadRepeatReportTime = new BigDecimal(this.mStartDateRepeat).add(new BigDecimal(this.mRepeatWindows).multiply(new BigDecimal(1000000))).longValue();
        }
        return new SpeedTestReport(speedTestMode, progressPercent.floatValue(), this.mStartDateRepeat, downloadRepeatReportTime, temporaryPacketSize, this.mRepeatPacketSize.longValueExact(), downloadRepeatRateOctet, transferRateBit, this.mRepeatRequestNum);
    }

    private void startDownloadRepeat(String uri) {
        this.mRepeatDownload = true;
        this.mSpeedTestSocket.startDownload(uri);
    }

    private void startUploadRepeat(String uri, int fileSizeOctet) {
        this.mSpeedTestSocket.startUpload(uri, fileSizeOctet);
    }

    public void startDownloadRepeat(final String uri, int repeatWindow, int reportPeriodMillis, final IRepeatListener repeatListener) {
        this.initRepeat(true);
        this.mTimer = new Timer();
        final ISpeedTestListener speedTestListener = new ISpeedTestListener(){

            @Override
            public void onCompletion(SpeedTestReport report) {
                RepeatWrapper.this.mRepeatTransferRateList.add(report.getTransferRateOctet());
                RepeatWrapper.this.startDownloadRepeat(uri);
                RepeatWrapper.this.mRepeatRequestNum++;
            }

            @Override
            public void onProgress(float percent, SpeedTestReport report) {
            }

            @Override
            public void onError(SpeedTestError speedTestError, String errorMessage) {
                RepeatWrapper.this.clearRepeatTask(this);
            }
        };
        this.mSpeedTestSocket.addSpeedTestListener(speedTestListener);
        this.mRepeatWindows = repeatWindow;
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RepeatWrapper.this.mSpeedTestSocket.removeSpeedTestListener(speedTestListener);
                RepeatWrapper.this.mSpeedTestSocket.forceStopTask();
                RepeatWrapper.this.cleanTimer();
                RepeatWrapper.this.mRepeatFinished = true;
                if (repeatListener != null) {
                    repeatListener.onCompletion(RepeatWrapper.this.mSpeedTestSocket.getLiveReport());
                }
            }
        }, repeatWindow);
        this.mTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (repeatListener != null) {
                    repeatListener.onReport(RepeatWrapper.this.mSpeedTestSocket.getLiveReport());
                }
            }
        }, reportPeriodMillis, (long)reportPeriodMillis);
        this.startDownloadRepeat(uri);
    }

    public void startUploadRepeat(final String uri, int repeatWindow, int reportPeriodMillis, final int fileSizeOctet, final IRepeatListener repeatListener) {
        this.initRepeat(false);
        this.mTimer = new Timer();
        final ISpeedTestListener speedTestListener = new ISpeedTestListener(){

            @Override
            public void onProgress(float percent, SpeedTestReport report) {
            }

            @Override
            public void onError(SpeedTestError speedTestError, String errorMessage) {
                RepeatWrapper.this.clearRepeatTask(this);
            }

            @Override
            public void onCompletion(SpeedTestReport report) {
                RepeatWrapper.this.mRepeatTransferRateList.add(report.getTransferRateOctet());
                RepeatWrapper.this.startUploadRepeat(uri, fileSizeOctet);
                RepeatWrapper.this.mRepeatRequestNum++;
            }
        };
        this.mSpeedTestSocket.addSpeedTestListener(speedTestListener);
        this.mRepeatWindows = repeatWindow;
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RepeatWrapper.this.mSpeedTestSocket.removeSpeedTestListener(speedTestListener);
                RepeatWrapper.this.mSpeedTestSocket.forceStopTask();
                RepeatWrapper.this.cleanTimer();
                RepeatWrapper.this.mRepeatFinished = true;
                if (repeatListener != null) {
                    repeatListener.onCompletion(RepeatWrapper.this.mSpeedTestSocket.getLiveReport());
                }
            }
        }, repeatWindow);
        this.mTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (repeatListener != null) {
                    repeatListener.onReport(RepeatWrapper.this.mSpeedTestSocket.getLiveReport());
                }
            }
        }, reportPeriodMillis, (long)reportPeriodMillis);
        this.startUploadRepeat(uri, fileSizeOctet);
    }

    public void cleanTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer.purge();
        }
    }

    private void initRepeat(boolean isDownload) {
        this.mRepeatDownload = isDownload;
        this.mFirstDownloadRepeat = isDownload;
        this.mRepeatUpload = !isDownload;
        this.mFirstUploadRepeat = !isDownload;
        this.initRepeatVars();
    }

    private void initRepeatVars() {
        this.mRepeatRequestNum = 0;
        this.mRepeatPacketSize = BigDecimal.ZERO;
        this.mRepeatTempPckSize = 0L;
        this.mRepeatFinished = false;
        this.mStartDateRepeat = 0L;
        this.mRepeatTransferRateList = new ArrayList<BigDecimal>();
    }

    private void clearRepeatTask(ISpeedTestListener listener) {
        this.mSpeedTestSocket.removeSpeedTestListener(listener);
        this.cleanTimer();
        this.mRepeatFinished = true;
        this.mSpeedTestSocket.closeSocket();
        this.mSpeedTestSocket.shutdownAndWait();
    }

    public boolean isFirstDownload() {
        return this.mFirstDownloadRepeat && this.mRepeatDownload;
    }

    public boolean isFirstUpload() {
        return this.mFirstUploadRepeat && this.mRepeatUpload;
    }

    public void setFirstDownloadRepeat(boolean state) {
        this.mFirstDownloadRepeat = state;
    }

    public void setStartDate(long timeStart) {
        this.mStartDateRepeat = timeStart;
    }

    public boolean isRepeatDownload() {
        return this.mRepeatDownload;
    }

    public void updatePacketSize(BigDecimal packetSize) {
        this.mRepeatPacketSize = this.mRepeatPacketSize.add(packetSize);
    }

    public void updateTempPacketSize(int read) {
        this.mRepeatTempPckSize += (long)read;
    }

    public boolean isRepeatUpload() {
        return this.mRepeatUpload;
    }

    public boolean isRepeat() {
        return this.mRepeatDownload || this.mRepeatUpload;
    }

    public void setFirstUploadRepeat(boolean state) {
        this.mFirstUploadRepeat = state;
    }
}

