/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.android.multievent;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import fr.bmartel.android.multievent.MultiEvent;

public class ConnectivityReceiver
extends BroadcastReceiver {
    private static final String TAG = ConnectivityReceiver.class.getSimpleName();
    private MultiEvent manager = null;
    private NetworkInfo.State wifiState = NetworkInfo.State.UNKNOWN;
    private NetworkInfo.State ethernetState = NetworkInfo.State.UNKNOWN;

    public ConnectivityReceiver(Context context, MultiEvent manager) {
        this.manager = manager;
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo wifi = connManager.getNetworkInfo(1);
        NetworkInfo ethernet = connManager.getNetworkInfo(9);
        if (wifi != null) {
            this.wifiState = wifi.getState();
        }
        if (ethernet != null) {
            this.ethernetState = ethernet.getState();
        }
    }

    public void onReceive(Context context, Intent intent) {
        int i;
        NetworkInfo.State oldState;
        ConnectivityManager conMan = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo wifi = conMan.getNetworkInfo(1);
        NetworkInfo ethernet = conMan.getNetworkInfo(9);
        if (wifi != null && this.wifiState != wifi.getState()) {
            oldState = this.wifiState;
            Log.i((String)TAG, (String)"wifi state has changed");
            this.wifiState = wifi.getState();
            for (i = 0; i < this.manager.getConnectivityListenerList().size(); ++i) {
                this.manager.getConnectivityListenerList().get(i).onWifiStateChange(oldState, this.wifiState);
            }
        }
        if (ethernet != null && this.ethernetState != ethernet.getState()) {
            oldState = this.ethernetState;
            Log.i((String)TAG, (String)"ethernet state has changed");
            this.ethernetState = ethernet.getState();
            for (i = 0; i < this.manager.getConnectivityListenerList().size(); ++i) {
                this.manager.getConnectivityListenerList().get(i).onEthernetStateChange(oldState, this.ethernetState);
            }
        }
    }

    public NetworkInfo.State getWifiState() {
        return this.wifiState;
    }

    public NetworkInfo.State getEthernetState() {
        return this.ethernetState;
    }
}

