/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.android.multievent;

import android.content.Context;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.os.Handler;
import fr.bmartel.android.multievent.MultiEvent;

public class SettingsObserver
extends ContentObserver {
    private Context context = null;
    private byte oldVolumeMedia = 0;
    private byte oldVolumeSystem = 0;
    private byte oldVolumeRing = 0;
    private byte oldVolumeNotification = 0;
    private byte oldVolumeDtmf = 0;
    private byte oldVolumeVoiceCall = 0;
    private byte maxVolumeMedia = 0;
    private byte maxVolumeSystem = 0;
    private byte maxVolumeRing = 0;
    private byte maxVolumeNotification = 0;
    private byte maxVolumeDtmf = 0;
    private byte maxVolumeVoiceCall = 0;
    private MultiEvent manager = null;

    public SettingsObserver(Context context, Handler handler, MultiEvent manager) {
        super(handler);
        this.context = context;
        this.manager = manager;
        AudioManager audio = (AudioManager)context.getSystemService("audio");
        if (audio != null) {
            this.oldVolumeMedia = (byte)audio.getStreamVolume(3);
            this.oldVolumeSystem = (byte)audio.getStreamVolume(1);
            this.oldVolumeRing = (byte)audio.getStreamVolume(2);
            this.oldVolumeNotification = (byte)audio.getStreamVolume(5);
            this.oldVolumeDtmf = (byte)audio.getStreamVolume(8);
            this.oldVolumeVoiceCall = (byte)audio.getStreamVolume(0);
            this.maxVolumeMedia = (byte)audio.getStreamMaxVolume(3);
            this.maxVolumeSystem = (byte)audio.getStreamMaxVolume(1);
            this.maxVolumeRing = (byte)audio.getStreamMaxVolume(2);
            this.maxVolumeNotification = (byte)audio.getStreamMaxVolume(5);
            this.maxVolumeDtmf = (byte)audio.getStreamMaxVolume(8);
            this.maxVolumeVoiceCall = (byte)audio.getStreamMaxVolume(0);
        }
    }

    public boolean deliverSelfNotifications() {
        return super.deliverSelfNotifications();
    }

    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        AudioManager audio = (AudioManager)this.context.getSystemService("audio");
        if (audio != null && this.manager != null) {
            int i;
            boolean changeVolumeVoiceCall;
            byte newVolumeMedia = (byte)audio.getStreamVolume(3);
            byte newVolumeSystem = (byte)audio.getStreamVolume(1);
            byte newVolumeRing = (byte)audio.getStreamVolume(2);
            byte newVolumeNotification = (byte)audio.getStreamVolume(5);
            byte newVolumeDtmf = (byte)audio.getStreamVolume(8);
            byte newVolumeVoiceCall = (byte)audio.getStreamVolume(0);
            boolean changeVolumeMedia = this.oldVolumeMedia - newVolumeMedia != 0;
            boolean changeVolumeSystem = this.oldVolumeSystem - newVolumeSystem != 0;
            boolean changeVolumeRing = this.oldVolumeRing - newVolumeRing != 0;
            boolean changeVolumeNotification = this.oldVolumeNotification - newVolumeNotification != 0;
            boolean changeVolumeDtmf = this.oldVolumeDtmf - newVolumeDtmf != 0;
            boolean bl = changeVolumeVoiceCall = this.oldVolumeVoiceCall - newVolumeVoiceCall != 0;
            if (changeVolumeMedia) {
                for (i = 0; i < this.manager.getVolumeMediaListenerList().size(); ++i) {
                    this.manager.getVolumeMediaListenerList().get(i).onVolume((byte)(this.oldVolumeMedia * 100 / this.maxVolumeMedia), (byte)(newVolumeMedia * 100 / this.maxVolumeMedia));
                }
            }
            if (changeVolumeSystem) {
                for (i = 0; i < this.manager.getVolumeSystemtListenerList().size(); ++i) {
                    this.manager.getVolumeSystemtListenerList().get(i).onVolume((byte)(this.oldVolumeSystem * 100 / this.maxVolumeSystem), (byte)(newVolumeSystem * 100 / this.maxVolumeSystem));
                }
            }
            if (changeVolumeRing) {
                for (i = 0; i < this.manager.getVolumeRingtListenerList().size(); ++i) {
                    this.manager.getVolumeRingtListenerList().get(i).onVolume((byte)(this.oldVolumeRing * 100 / this.maxVolumeRing), (byte)(newVolumeRing * 100 / this.maxVolumeRing));
                }
            }
            if (changeVolumeNotification) {
                for (i = 0; i < this.manager.getVolumeNotificationtListenerList().size(); ++i) {
                    this.manager.getVolumeNotificationtListenerList().get(i).onVolume((byte)(this.oldVolumeNotification * 100 / this.maxVolumeNotification), (byte)(newVolumeNotification * 100 / this.maxVolumeNotification));
                }
            }
            if (changeVolumeDtmf) {
                for (i = 0; i < this.manager.getVolumeDtmftListenerList().size(); ++i) {
                    this.manager.getVolumeDtmftListenerList().get(i).onVolume((byte)(this.oldVolumeDtmf * 100 / this.maxVolumeDtmf), (byte)(newVolumeDtmf * 100 / this.maxVolumeDtmf));
                }
            }
            if (changeVolumeVoiceCall) {
                for (i = 0; i < this.manager.getVolumeVoiceCalltListenerList().size(); ++i) {
                    this.manager.getVolumeVoiceCalltListenerList().get(i).onVolume((byte)(this.oldVolumeVoiceCall * 100 / this.maxVolumeVoiceCall), (byte)(newVolumeVoiceCall * 100 / this.maxVolumeVoiceCall));
                }
            }
        }
        this.oldVolumeMedia = (byte)audio.getStreamVolume(3);
        this.oldVolumeSystem = (byte)audio.getStreamVolume(1);
        this.oldVolumeRing = (byte)audio.getStreamVolume(2);
        this.oldVolumeNotification = (byte)audio.getStreamVolume(5);
        this.oldVolumeDtmf = (byte)audio.getStreamVolume(8);
        this.oldVolumeVoiceCall = (byte)audio.getStreamVolume(0);
    }

    public int getVolume(int type) {
        return this.manager.getAudioManager().getStreamVolume(type) * 100 / this.manager.getAudioManager().getStreamMaxVolume(type);
    }

    public void mute(int type, boolean state) {
        this.manager.getAudioManager().setStreamMute(type, state);
    }

    public void volumeUp(int type) {
        this.manager.getAudioManager().adjustStreamVolume(type, 1, 1);
    }

    public void volumeDown(int type) {
        this.manager.getAudioManager().adjustStreamVolume(type, -1, 1);
    }
}

