/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.android.multievent;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import fr.bmartel.android.multievent.ConnectivityReceiver;
import fr.bmartel.android.multievent.EventReceiver;
import fr.bmartel.android.multievent.PhoneListener;
import fr.bmartel.android.multievent.SettingsObserver;
import fr.bmartel.android.multievent.listener.IConnectivityListener;
import fr.bmartel.android.multievent.listener.IPhoneCallListener;
import fr.bmartel.android.multievent.listener.IScreenStateListener;
import fr.bmartel.android.multievent.listener.ISmsListener;
import fr.bmartel.android.multievent.listener.IVolumeListener;
import java.util.ArrayList;
import java.util.List;

public class MultiEvent {
    private String TAG = MultiEvent.class.getName();
    List<IVolumeListener> volumeMediaListenerList = new ArrayList<IVolumeListener>();
    List<IVolumeListener> volumeSystemListenerList = new ArrayList<IVolumeListener>();
    List<IVolumeListener> volumeRingListenerList = new ArrayList<IVolumeListener>();
    List<IVolumeListener> volumeNotificationListenerList = new ArrayList<IVolumeListener>();
    List<IVolumeListener> volumeVoiceCallListenerList = new ArrayList<IVolumeListener>();
    List<IVolumeListener> volumeDtmfListenerList = new ArrayList<IVolumeListener>();
    List<IPhoneCallListener> phoneCallListenerList = new ArrayList<IPhoneCallListener>();
    List<IScreenStateListener> screenStateListenerList = new ArrayList<IScreenStateListener>();
    List<ISmsListener> smsListenerList = new ArrayList<ISmsListener>();
    List<IConnectivityListener> connectivityListenerList = new ArrayList<IConnectivityListener>();
    private Context context = null;
    private SettingsObserver audioObserver = null;
    private EventReceiver eventReceiver = null;
    private AudioManager audioManager = null;
    private PowerManager powerManager = null;
    private ConnectivityReceiver connectivityReceiver = null;

    public MultiEvent(Context context) {
        this.audioManager = (AudioManager)context.getSystemService("audio");
        if (this.audioManager == null) {
            Log.e((String)this.TAG, (String)"Error audio manager is null");
        }
        this.powerManager = (PowerManager)context.getSystemService("power");
        if (this.powerManager == null) {
            Log.e((String)this.TAG, (String)"Error power manager is null");
        }
        if (context != null) {
            this.context = context;
            this.audioObserver = new SettingsObserver(context, new Handler(), this);
            context.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.audioObserver);
            if (this.checkReadPhoneStatePermission(context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager != null) {
                    PhoneListener PhoneListener2 = new PhoneListener(this);
                    telephonyManager.listen((PhoneStateListener)PhoneListener2, 32);
                } else {
                    Log.e((String)this.TAG, (String)"Telephony manager service is not available");
                }
            } else {
                Log.w((String)this.TAG, (String)"permission android.permission.READ_PHONE_STATE has not been granted. TELEPHONY_SERVICE is not summonned");
            }
            this.eventReceiver = new EventReceiver(this);
            IntentFilter screenStatusFilter = new IntentFilter();
            screenStatusFilter.addAction("android.intent.action.SCREEN_ON");
            screenStatusFilter.addAction("android.intent.action.SCREEN_OFF");
            screenStatusFilter.addAction("android.provider.Telephony.SMS_RECEIVED");
            context.registerReceiver((BroadcastReceiver)this.eventReceiver, screenStatusFilter);
            this.connectivityReceiver = new ConnectivityReceiver(context, this);
            IntentFilter connectivityFilter = new IntentFilter();
            connectivityFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver((BroadcastReceiver)this.connectivityReceiver, connectivityFilter);
        } else {
            Log.e((String)this.TAG, (String)"Error application context is null");
        }
    }

    public void addMediaVolumeListener(IVolumeListener listener) {
        this.volumeMediaListenerList.add(listener);
    }

    public void addVoiceCallVolumeListener(IVolumeListener listener) {
        this.volumeVoiceCallListenerList.add(listener);
    }

    public void addSystemVolumeListener(IVolumeListener listener) {
        this.volumeSystemListenerList.add(listener);
    }

    public void addRingVolumeListener(IVolumeListener listener) {
        this.volumeRingListenerList.add(listener);
    }

    public void addNotificationVolumeListener(IVolumeListener listener) {
        this.volumeNotificationListenerList.add(listener);
    }

    public void addDtmfVolumeListener(IVolumeListener listener) {
        this.volumeDtmfListenerList.add(listener);
    }

    public void addPhoneCallListener(IPhoneCallListener listener) {
        this.phoneCallListenerList.add(listener);
    }

    public void addScreenStateListener(IScreenStateListener listener) {
        this.screenStateListenerList.add(listener);
    }

    public void addConnectivityChangeListener(IConnectivityListener listener) {
        this.connectivityListenerList.add(listener);
    }

    private boolean checkReadPhoneStatePermission(Context context, String permission) {
        int res = context.checkCallingOrSelfPermission(permission);
        return res == 0;
    }

    public void addSmsListener(ISmsListener listener) {
        this.smsListenerList.add(listener);
    }

    public void removeListeners(IVolumeListener listener) {
        this.volumeMediaListenerList.remove(listener);
        this.volumeVoiceCallListenerList.remove(listener);
        this.volumeSystemListenerList.remove(listener);
        this.volumeRingListenerList.remove(listener);
        this.volumeNotificationListenerList.remove(listener);
        this.volumeDtmfListenerList.remove(listener);
        this.phoneCallListenerList.remove(listener);
        this.screenStateListenerList.remove(listener);
        this.smsListenerList.remove(listener);
        this.connectivityListenerList.remove(listener);
    }

    public void removeAllListeners() {
        this.volumeMediaListenerList.clear();
        this.volumeVoiceCallListenerList.clear();
        this.volumeSystemListenerList.clear();
        this.volumeRingListenerList.clear();
        this.volumeNotificationListenerList.clear();
        this.volumeDtmfListenerList.clear();
        this.phoneCallListenerList.clear();
        this.screenStateListenerList.clear();
        this.smsListenerList.clear();
        this.connectivityListenerList.clear();
    }

    public void close() {
        this.removeAllListeners();
        this.context.getContentResolver().unregisterContentObserver((ContentObserver)this.audioObserver);
        this.context.unregisterReceiver((BroadcastReceiver)this.eventReceiver);
        this.context.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
    }

    public List<IVolumeListener> getVolumeMediaListenerList() {
        return this.volumeMediaListenerList;
    }

    public List<IConnectivityListener> getConnectivityListenerList() {
        return this.connectivityListenerList;
    }

    public List<IVolumeListener> getVolumeVoiceCalltListenerList() {
        return this.volumeVoiceCallListenerList;
    }

    public List<IVolumeListener> getVolumeSystemtListenerList() {
        return this.volumeSystemListenerList;
    }

    public List<IVolumeListener> getVolumeRingtListenerList() {
        return this.volumeRingListenerList;
    }

    public List<IVolumeListener> getVolumeNotificationtListenerList() {
        return this.volumeNotificationListenerList;
    }

    public List<IVolumeListener> getVolumeDtmftListenerList() {
        return this.volumeDtmfListenerList;
    }

    public List<IPhoneCallListener> getPhoneCallListenerList() {
        return this.phoneCallListenerList;
    }

    public List<IScreenStateListener> getScreenStateListenerList() {
        return this.screenStateListenerList;
    }

    public List<ISmsListener> getSmsListenerList() {
        return this.smsListenerList;
    }

    public AudioManager getAudioManager() {
        return this.audioManager;
    }

    public int getVolume(int type) {
        if (this.audioManager != null) {
            return this.audioObserver.getVolume(type);
        }
        return 0;
    }

    public void mute(int type, boolean state) {
        if (this.audioManager != null) {
            this.audioObserver.mute(type, state);
        }
    }

    public void volumeUp(int type) {
        if (this.audioManager != null) {
            this.audioObserver.volumeUp(type);
        }
    }

    public void volumeDown(int type) {
        if (this.audioManager != null) {
            this.audioObserver.volumeDown(type);
        }
    }

    public void setVolume(int type, int value) {
        if (this.audioManager != null) {
            this.audioObserver.setVolume(type, value);
        }
    }

    @TargetApi(value=7)
    public boolean getScreenState() {
        if (this.powerManager != null && Build.VERSION.SDK_INT >= 7) {
            return this.powerManager.isScreenOn();
        }
        return false;
    }

    public NetworkInfo.State getWifiState() {
        return this.connectivityReceiver.getWifiState();
    }

    public NetworkInfo.State getEthernetState() {
        return this.connectivityReceiver.getEthernetState();
    }
}

