/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.commonmark.ext.notifications;

import fr.brouillard.oss.commonmark.ext.notifications.DefaultWrapperImplementations;
import fr.brouillard.oss.commonmark.ext.notifications.Notification;
import fr.brouillard.oss.commonmark.ext.notifications.NotificationBlock;
import fr.brouillard.oss.commonmark.ext.notifications.NotificationsExtension;
import java.util.Collections;
import java.util.Set;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;

public class NotificationNodeRenderer
implements NodeRenderer {
    private final HtmlNodeRendererContext context;
    private final HtmlWriter htmlWriter;
    private NotificationsExtension.DomElementMapper domElementMapper;
    private NotificationsExtension.ClassMapper classMapper;

    public NotificationNodeRenderer(HtmlNodeRendererContext context) {
        this(context, DefaultWrapperImplementations.DEFAULT_DOM_ELEMENT_MAPPER, DefaultWrapperImplementations.DEFAULT_CSS_CLASS_MAPPER);
    }

    public NotificationNodeRenderer(HtmlNodeRendererContext context, NotificationsExtension.DomElementMapper domElementMapper, NotificationsExtension.ClassMapper classMapper) {
        this.context = context;
        this.htmlWriter = context.getWriter();
        this.domElementMapper = domElementMapper;
        this.classMapper = classMapper;
    }

    public Set<Class<? extends Node>> getNodeTypes() {
        return Collections.singleton(NotificationBlock.class);
    }

    public void render(Node node) {
        NotificationBlock nb = (NotificationBlock)node;
        this.htmlWriter.line();
        Notification n = nb.getType();
        String domElement = this.domElementMapper.domElement(n);
        this.htmlWriter.tag(domElement, Collections.singletonMap("class", this.classMapper.cssClass(n)));
        this.renderChildren((Node)nb);
        this.htmlWriter.tag("/" + domElement);
        this.htmlWriter.line();
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

