/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.cssfx.impl;

import fr.brouillard.oss.cssfx.api.URIToPathConverter;
import fr.brouillard.oss.cssfx.impl.events.CSSFXEvent;
import fr.brouillard.oss.cssfx.impl.events.CSSFXEventListener;
import fr.brouillard.oss.cssfx.impl.log.CSSFXLogger;
import fr.brouillard.oss.cssfx.impl.monitoring.CleanupDetector;
import fr.brouillard.oss.cssfx.impl.monitoring.PathsWatcher;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;

public class CSSFXMonitor {
    private PathsWatcher pw;
    private List<URIToPathConverter> knownConverters = new CopyOnWriteArrayList<URIToPathConverter>();
    private ObservableList<? extends Window> windows;
    private ObservableList<Scene> scenes;
    private ObservableList<Node> nodes;
    private List<CSSFXEventListener> eventListeners = new CopyOnWriteArrayList<CSSFXEventListener>();
    private Set<Scene> knownScenes = Collections.newSetFromMap(new WeakHashMap());
    private Set<Window> knownWindows = Collections.newSetFromMap(new WeakHashMap());
    private Set<Node> knownNodes = Collections.newSetFromMap(new WeakHashMap());

    public void setStages(ObservableList<Stage> stages) {
        this.setWindows(stages);
    }

    public void setWindows(ObservableList<? extends Window> stages) {
        this.windows = stages;
    }

    public void setScenes(ObservableList<Scene> scenes) {
        this.scenes = scenes;
    }

    public void setNodes(ObservableList<Node> nodes) {
        this.nodes = nodes;
    }

    public void addAllConverters(Collection<URIToPathConverter> converters) {
        this.knownConverters.addAll(converters);
    }

    public void addAllConverters(URIToPathConverter ... converters) {
        this.knownConverters.addAll(Arrays.asList(converters));
    }

    public void addConverter(URIToPathConverter newConverter) {
        this.knownConverters.add(newConverter);
    }

    public void removeConverter(URIToPathConverter converter) {
        this.knownConverters.remove(converter);
    }

    public void addEventListener(CSSFXEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(CSSFXEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public void start() {
        CSSFXLogger.logger(CSSFXMonitor.class).info("CSS Monitoring is about to start", new Object[0]);
        this.pw = new PathsWatcher();
        Runnable starter = () -> {
            if (this.windows != null) {
                this.monitorWindows(this.windows);
            } else if (this.scenes != null) {
                this.monitorScenes(this.scenes);
            } else if (this.nodes != null) {
                this.monitorChildren(this.nodes);
            }
        };
        if (Platform.isFxApplicationThread()) {
            starter.run();
        } else {
            Platform.runLater((Runnable)starter);
        }
        this.pw.watch();
        CSSFXLogger.logger(CSSFXMonitor.class).info("CSS Monitoring started", new Object[0]);
    }

    public void stop() {
        this.pw.stop();
    }

    private void monitorWindows(ObservableList<? extends Window> observableWindows) {
        observableWindows.addListener((ListChangeListener)new ListChangeListener<Window>(){

            public void onChanged(ListChangeListener.Change<? extends Window> c) {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    for (Window addedWindow : c.getAddedSubList()) {
                        CSSFXMonitor.this.registerWindow(addedWindow);
                    }
                }
            }
        });
        for (Window stage : observableWindows) {
            this.registerWindow(stage);
        }
    }

    private void monitorStageScene(ReadOnlyObjectProperty<Scene> stageSceneProperty) {
        stageSceneProperty.addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> ov, Scene o, Scene n) {
                if (n != null) {
                    CSSFXMonitor.this.registerScene(n);
                }
            }
        });
        if (stageSceneProperty.getValue() != null) {
            this.registerScene((Scene)stageSceneProperty.getValue());
        }
    }

    private void monitorRoot(ObjectProperty<Parent> rootProperty) {
        rootProperty.addListener((ov, o, n) -> {
            if (n != null) {
                this.registerNode((Node)n);
            }
        });
        if (rootProperty.getValue() != null) {
            this.registerNode((Node)rootProperty.getValue());
        }
    }

    private void registerNode(Node node) {
        if (this.knownNodes.add(node)) {
            if (node instanceof Parent) {
                Parent p = (Parent)node;
                this.monitorStylesheets((ObservableList<String>)p.getStylesheets());
                this.monitorChildren((ObservableList<Node>)p.getChildrenUnmodifiable());
            }
            this.eventNotify(CSSFXEvent.newEvent(CSSFXEvent.EventType.NODE_ADDED, node));
        }
    }

    private void monitorScenes(ObservableList<Scene> observableScenes) {
        observableScenes.addListener((ListChangeListener)new ListChangeListener<Scene>(){

            public void onChanged(ListChangeListener.Change<? extends Scene> c) {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    for (Scene addedScene : c.getAddedSubList()) {
                        CSSFXMonitor.this.registerScene(addedScene);
                    }
                }
            }
        });
        for (Scene s : observableScenes) {
            this.registerScene(s);
        }
    }

    private void monitorChildren(ObservableList<Node> childrenUnmodifiable) {
        childrenUnmodifiable.addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    for (Node addedNode : c.getAddedSubList()) {
                        CSSFXMonitor.this.registerNode(addedNode);
                    }
                }
            }
        });
        for (Node node : childrenUnmodifiable) {
            this.registerNode(node);
        }
    }

    public void monitorStylesheets(ObservableList<String> stylesheets) {
        URIRegistrar registrar = new URIRegistrar(this.knownConverters, this.pw);
        stylesheets.addListener((ListChangeListener)new StyleSheetChangeListener(registrar));
        ArrayList<String> stylesheetsURI = new ArrayList<String>((Collection<String>)stylesheets);
        for (String uri : stylesheetsURI) {
            registrar.register(uri, stylesheets);
        }
        CleanupDetector.onCleanup(stylesheets, () -> Platform.runLater(() -> registrar.cleanup()));
    }

    private void registerScene(Scene scene) {
        if (this.knownScenes.add(scene)) {
            this.eventNotify(CSSFXEvent.newEvent(CSSFXEvent.EventType.SCENE_ADDED, scene));
            this.monitorStylesheets((ObservableList<String>)scene.getStylesheets());
            this.monitorRoot((ObjectProperty<Parent>)scene.rootProperty());
        }
    }

    private void registerWindow(Window stage) {
        if (this.knownWindows.add(stage)) {
            this.eventNotify(CSSFXEvent.newEvent(CSSFXEvent.EventType.STAGE_ADDED, stage));
            this.monitorStageScene((ReadOnlyObjectProperty<Scene>)stage.sceneProperty());
        }
    }

    private void eventNotify(CSSFXEvent<?> e) {
        for (CSSFXEventListener listener : this.eventListeners) {
            listener.onEvent(e);
        }
    }

    public static class URIStyleUpdater
    implements Runnable {
        private final String sourceURI;
        private final String originalURI;
        private final WeakReference<ObservableList<String>> cssURIsWeak;

        public URIStyleUpdater(String originalURI, String sourceURI, ObservableList<String> cssURIs) {
            this.originalURI = originalURI;
            this.sourceURI = sourceURI;
            this.cssURIsWeak = new WeakReference<ObservableList<String>>(cssURIs);
        }

        @Override
        public void run() {
            ObservableList cssURIs = (ObservableList)this.cssURIsWeak.get();
            if (cssURIs != null) {
                Runnable task = () -> {
                    for (int counter = 0; counter < cssURIs.size(); ++counter) {
                        String v = (String)cssURIs.get(counter);
                        if (!v.equals(this.originalURI) && !v.equals(this.sourceURI)) continue;
                        cssURIs.remove(counter);
                        cssURIs.add(counter, (Object)this.sourceURI);
                    }
                };
                Platform.runLater((Runnable)task);
            }
        }
    }

    private static class StyleSheetChangeListener
    implements ListChangeListener<String> {
        private URIRegistrar registrar;

        private StyleSheetChangeListener(URIRegistrar registrar) {
            this.registrar = registrar;
        }

        public void onChanged(ListChangeListener.Change<? extends String> c) {
            while (c.next()) {
                if (c.wasRemoved()) {
                    for (String removedURI : c.getRemoved()) {
                        this.registrar.unregister(removedURI);
                    }
                }
                if (!c.wasAdded()) continue;
                for (String newURI : c.getAddedSubList()) {
                    this.registrar.register(newURI, (ObservableList<? extends String>)c.getList());
                }
            }
        }
    }

    public static class URIRegistrar {
        final Map<String, Path> sourceURIs = new HashMap<String, Path>();
        final Map<Path, List<Runnable>> actions = new HashMap<Path, List<Runnable>>();
        final List<URIToPathConverter> converters;
        private PathsWatcher wp;
        private static final Pattern URL_QUICKMATCH = Pattern.compile("^\\p{Alpha}[\\p{Alnum}+.-]*:.*$");

        public URIRegistrar(List<URIToPathConverter> c, PathsWatcher wp) {
            this.converters = c;
            this.wp = wp;
        }

        private String classpathToURI(String str) {
            if (!URL_QUICKMATCH.matcher(str).matches()) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                URL resource = str.charAt(0) == '/' ? contextClassLoader.getResource(str.substring(1)) : contextClassLoader.getResource(str);
                if (resource != null) {
                    return resource.toString();
                }
                return str;
            }
            try {
                return new URL(str).toString();
            }
            catch (MalformedURLException e) {
                return str;
            }
        }

        public void register(String uri, ObservableList<? extends String> stylesheets) {
            if (!this.sourceURIs.containsKey(uri)) {
                String simplifiedURI = this.classpathToURI(uri);
                CSSFXLogger.logger(CSSFXMonitor.class).debug("searching source for css[%s]", uri);
                for (URIToPathConverter c : this.converters) {
                    Path sourceFile = c.convert(simplifiedURI);
                    LinkedList<URIStyleUpdater> runnables = new LinkedList<URIStyleUpdater>();
                    if (sourceFile != null) {
                        CSSFXLogger.logger(CSSFXMonitor.class).info("css[%s] will be mapped to source[%s]", uri, sourceFile);
                        Path directory = sourceFile.getParent();
                        URIStyleUpdater r = new URIStyleUpdater(uri, sourceFile.toUri().toString(), stylesheets);
                        this.wp.monitor(directory.toAbsolutePath().normalize(), sourceFile.toAbsolutePath().normalize(), r);
                        runnables.add(r);
                        this.sourceURIs.put(sourceFile.toUri().toString(), sourceFile);
                        if (Platform.isFxApplicationThread()) {
                            r.run();
                        } else {
                            Platform.runLater((Runnable)r);
                        }
                    }
                    this.actions.put(sourceFile, runnables);
                }
            }
        }

        public void unregister(String uri) {
        }

        public void cleanup() {
            this.actions.forEach((path, runnables) -> runnables.forEach(runnable -> this.wp.unregister(path.getParent().toAbsolutePath().normalize(), path.toAbsolutePath().normalize(), (Runnable)runnable)));
        }
    }
}

