/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.cssfx.impl;

import fr.brouillard.oss.cssfx.api.URIToPathConverter;
import fr.brouillard.oss.cssfx.impl.log.CSSFXLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIToPathConverters {
    private static final URIToPathConverter MAVEN_RESOURCE = new URIToPathConverter(){

        @Override
        public Path convert(String uri) {
            if (uri != null && uri.startsWith("file:")) {
                if (uri.contains("target/classes")) {
                    String[] classesTransform;
                    for (String ct : classesTransform = new String[]{"src/main/java", "src/main/resources"}) {
                        String potentialSourceURI = uri.replace("target/classes", ct);
                        try {
                            Path p = Paths.get(new URI(potentialSourceURI));
                            if (!Files.exists(p, new LinkOption[0])) continue;
                            return p;
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (uri.contains("target/test-classes")) {
                    String[] testClassesTransform;
                    for (String tct : testClassesTransform = new String[]{"src/test/java", "src/test/resources"}) {
                        String potentialSourceURI = uri.replace("target/test-classes", tct);
                        try {
                            Path p = Paths.get(new URI(potentialSourceURI));
                            if (!Files.exists(p, new LinkOption[0])) continue;
                            return p;
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            CSSFXLogger.logger(URIToPathConverters.class).debug("MAVEN converter failed to map css[%s] to a source file", uri);
            return null;
        }
    };
    private static final URIToPathConverter GRADLE_RESOURCE = new URIToPathConverter(){

        @Override
        public Path convert(String uri) {
            if (uri != null && uri.startsWith("file:")) {
                if (uri.contains("build/resources/main")) {
                    String[] classesTransform;
                    for (String ct : classesTransform = new String[]{"src/main/java", "src/main/resources"}) {
                        String potentialSourceURI = uri.replace("build/resources/main", ct);
                        try {
                            Path p = Paths.get(new URI(potentialSourceURI));
                            if (!Files.exists(p, new LinkOption[0])) continue;
                            return p;
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (uri.contains("build/resources/test")) {
                    String[] testClassesTransform;
                    for (String tct : testClassesTransform = new String[]{"src/test/java", "src/test/resources"}) {
                        String potentialSourceURI = uri.replace("build/resources/test", tct);
                        try {
                            Path p = Paths.get(new URI(potentialSourceURI));
                            if (!Files.exists(p, new LinkOption[0])) continue;
                            return p;
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            CSSFXLogger.logger(URIToPathConverters.class).debug("GRADLE converter failed to map css[%s] to a source file", uri);
            return null;
        }
    };
    private static final URIToPathConverter INTELLIJ_RESOURCE = new URIToPathConverter(){

        @Override
        public Path convert(String uri) {
            if (uri != null && uri.startsWith("file:")) {
                if (uri.contains("out/production/resources")) {
                    String[] classesTransform;
                    for (String ct : classesTransform = new String[]{"src/main/java", "src/main/resources"}) {
                        String potentialSourceURI = uri.replace("out/production/resources", ct);
                        try {
                            Path p = Paths.get(new URI(potentialSourceURI));
                            if (!Files.exists(p, new LinkOption[0])) continue;
                            return p;
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (uri.contains("out/test/resources")) {
                    String[] testClassesTransform;
                    for (String tct : testClassesTransform = new String[]{"src/test/java", "src/test/resources"}) {
                        String potentialSourceURI = uri.replace("out/test/resources", tct);
                        try {
                            Path p = Paths.get(new URI(potentialSourceURI));
                            if (!Files.exists(p, new LinkOption[0])) continue;
                            return p;
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            CSSFXLogger.logger(URIToPathConverters.class).debug("INTELLIJ converter failed to map css[%s] to a source file", uri);
            return null;
        }
    };
    private static Pattern[] JAR_PATTERNS = new Pattern[]{Pattern.compile("jar:file:/(.*)/target/(.*)\\.jar!/(.*\\.css)"), Pattern.compile("jar:file:/(.*)/build/(.*)\\.jar!/(.*\\.css)")};
    private static String[] JAR_SOURCES_REPLACEMENTS = new String[]{"src/main/java", "src/main/resources", "src/test/java", "src/test/resources"};
    private static final URIToPathConverter JAR_RESOURCE = new URIToPathConverter(){

        @Override
        public Path convert(String uri) {
            String sourceFileURIPattern = "file:/%s/%s/%s";
            for (Pattern jp : JAR_PATTERNS) {
                Matcher m = jp.matcher(uri);
                if (!m.matches()) continue;
                for (String string : JAR_SOURCES_REPLACEMENTS) {
                    String potentialSourceURI = String.format(sourceFileURIPattern, m.group(1), string, m.group(3));
                    try {
                        Path p = Paths.get(new URI(potentialSourceURI));
                        if (!Files.exists(p, new LinkOption[0])) continue;
                        return p;
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
            CSSFXLogger.logger(URIToPathConverters.class).debug("JAR converter failed to map css[%s] to a source file", uri);
            return null;
        }
    };
    public static URIToPathConverter[] DEFAULT_CONVERTERS = new URIToPathConverter[]{MAVEN_RESOURCE, GRADLE_RESOURCE, JAR_RESOURCE, INTELLIJ_RESOURCE};
}

