/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.cssfx.impl.monitoring;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;

public class CleanupDetector {
    private static HashSet<WeakReferenceWithRunnable> references = new HashSet();
    private static ReferenceQueue referenceQueue = new ReferenceQueue();

    public static void onCleanup(Object obj, Runnable r) {
        CleanupDetector.onCleanup(new WeakReferenceWithRunnable(obj, referenceQueue, r));
    }

    public static void onCleanup(WeakReferenceWithRunnable weakref) {
        references.add(weakref);
    }

    static {
        Thread cleanupDetectorThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        WeakReferenceWithRunnable r = (WeakReferenceWithRunnable)referenceQueue.remove();
                        references.remove(r);
                        r.r.run();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }, "CSSFX-cleanup-detector");
        cleanupDetectorThread.setDaemon(true);
        cleanupDetectorThread.start();
    }

    public static class WeakReferenceWithRunnable
    extends WeakReference {
        Runnable r = null;

        WeakReferenceWithRunnable(Object ref, ReferenceQueue queue, Runnable r) {
            super(ref, queue);
            this.r = r;
        }
    }
}

