/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.GAV;
import fr.brouillard.oss.jgitver.JGitverConfiguration;
import fr.brouillard.oss.jgitver.JGitverInformationProvider;
import fr.brouillard.oss.jgitver.JGitverSession;
import fr.brouillard.oss.jgitver.JGitverSessionHolder;
import fr.brouillard.oss.jgitver.JGitverUtils;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Scm;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=ModelProcessor.class)
public class JGitverModelProcessor
extends DefaultModelProcessor {
    public static final String FLATTEN_MAVEN_PLUGIN = "flatten-maven-plugin";
    public static final String ORG_CODEHAUS_MOJO = "org.codehaus.mojo";
    @Requirement
    private Logger logger = null;
    @Requirement
    private LegacySupport legacySupport = null;
    @Requirement
    private JGitverConfiguration configurationProvider;
    @Requirement
    private JGitverSessionHolder jgitverSession;

    public Model read(File input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    private Model provisionModel(Model model, Map<String, ?> options) throws IOException {
        MavenSession session = this.legacySupport.getSession();
        Optional<JGitverSession> optSession = this.jgitverSession.session();
        if (!optSession.isPresent()) {
            return model;
        }
        Source source = (Source)options.get("org.apache.maven.model.building.source");
        if (source == null) {
            return model;
        }
        File location = new File(source.getLocation());
        if (!location.isFile()) {
            return model;
        }
        if (this.configurationProvider.ignore(location)) {
            this.logger.debug("file " + location + " ignored by configuration");
            return model;
        }
        JGitverSession jgitverSession = optSession.get();
        File relativePath = location.getParentFile().getCanonicalFile();
        File multiModuleDirectory = jgitverSession.getMultiModuleDirectory();
        String calculatedVersion = jgitverSession.getVersion();
        if (StringUtils.containsIgnoreCase((CharSequence)relativePath.getCanonicalPath(), (CharSequence)multiModuleDirectory.getCanonicalPath())) {
            this.logger.debug("handling version of project Model from " + location);
            jgitverSession.addProject(GAV.from(model.clone()));
            if (Objects.nonNull(model.getVersion())) {
                model.setVersion(calculatedVersion);
            }
            if (Objects.nonNull(model.getParent())) {
                String modelParentRelativePath = model.getParent().getRelativePath();
                File relativePathParent = new File(relativePath.getCanonicalPath() + File.separator + modelParentRelativePath).getParentFile().getCanonicalFile();
                if (StringUtils.isNotBlank((CharSequence)modelParentRelativePath) && StringUtils.containsIgnoreCase((CharSequence)relativePathParent.getCanonicalPath(), (CharSequence)multiModuleDirectory.getCanonicalPath())) {
                    model.getParent().setVersion(calculatedVersion);
                }
            }
            if (relativePath.getCanonicalPath().equals(multiModuleDirectory.getCanonicalPath())) {
                if (JGitverUtils.shouldUseFlattenPlugin(session)) {
                    if (this.shouldSkipPomUpdate(model)) {
                        this.logger.info("skipPomUpdate property is activated, jgitver will not define any maven-flatten-plugin execution");
                    } else if (this.isFlattenPluginDirectlyUsed(model)) {
                        this.logger.info("maven-flatten-plugin detected, jgitver will not define it's own execution");
                    } else {
                        this.logger.info("adding maven-flatten-plugin execution with jgitver defaults");
                        this.addFlattenPlugin(model);
                    }
                } else {
                    this.addAttachPomMojo(model);
                }
                this.updateScmTag(jgitverSession.getCalculator(), model);
            }
            try {
                session.getUserProperties().put("jgitver.session", JGitverSession.serializeTo(jgitverSession));
            }
            catch (Exception ex) {
                throw new IOException("cannot serialize JGitverSession", ex);
            }
        } else {
            this.logger.debug("skipping Model from " + location);
        }
        return model;
    }

    private void addFlattenPlugin(Model model) {
        this.ensureBuildWithPluginsExistInModel(model);
        Plugin flattenPlugin = new Plugin();
        flattenPlugin.setGroupId(ORG_CODEHAUS_MOJO);
        flattenPlugin.setArtifactId(FLATTEN_MAVEN_PLUGIN);
        flattenPlugin.setVersion(System.getProperty("jgitver.flatten.version", "1.0.1"));
        PluginExecution flattenPluginExecution = new PluginExecution();
        flattenPluginExecution.setId("jgitver-flatten-pom");
        flattenPluginExecution.addGoal("flatten");
        flattenPluginExecution.setPhase(System.getProperty("jgitver.pom-replacement-phase", "validate"));
        flattenPlugin.getExecutions().add(flattenPluginExecution);
        Xpp3Dom executionConfiguration = this.buildFlattenPluginConfiguration();
        flattenPluginExecution.setConfiguration((Object)executionConfiguration);
        model.getBuild().getPlugins().add(flattenPlugin);
    }

    private void ensureBuildWithPluginsExistInModel(Model model) {
        if (Objects.isNull(model.getBuild())) {
            model.setBuild(new Build());
        }
        if (Objects.isNull(model.getBuild().getPlugins())) {
            model.getBuild().setPlugins(new ArrayList());
        }
    }

    private Xpp3Dom buildFlattenPluginConfiguration() {
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom flattenMode = new Xpp3Dom("flattenMode");
        flattenMode.setValue("defaults");
        Xpp3Dom updatePomFile = new Xpp3Dom("updatePomFile");
        updatePomFile.setValue("true");
        Xpp3Dom pomElements = new Xpp3Dom("pomElements");
        Xpp3Dom dependencyManagement = new Xpp3Dom("dependencyManagement");
        dependencyManagement.setValue("keep");
        pomElements.addChild(dependencyManagement);
        List<String> pomElementsName = Arrays.asList("build", "ciManagement", "contributors", "dependencies", "description", "developers", "distributionManagement", "inceptionYear", "issueManagement", "mailingLists", "modules", "name", "organization", "parent", "pluginManagement", "pluginRepositories", "prerequisites", "profiles", "properties", "reporting", "repositories", "scm", "url", "version");
        pomElementsName.forEach(elementName -> {
            Xpp3Dom node = new Xpp3Dom(elementName);
            node.setValue("resolve");
            pomElements.addChild(node);
        });
        configuration.addChild(flattenMode);
        configuration.addChild(updatePomFile);
        configuration.addChild(pomElements);
        return configuration;
    }

    private boolean shouldSkipPomUpdate(Model model) throws IOException {
        try {
            return this.configurationProvider.getConfiguration().skipPomUpdate;
        }
        catch (MavenExecutionException mee) {
            throw new IOException("cannot load jgitver configuration", mee);
        }
    }

    private boolean isFlattenPluginDirectlyUsed(Model model) {
        Predicate<Plugin> isFlattenPlugin = p -> ORG_CODEHAUS_MOJO.equals(p.getGroupId()) && FLATTEN_MAVEN_PLUGIN.equals(p.getArtifactId());
        List pluginList = Optional.ofNullable(model.getBuild()).map(PluginContainer::getPlugins).orElse(Collections.emptyList());
        return pluginList.stream().filter(isFlattenPlugin).findAny().isPresent();
    }

    private void updateScmTag(JGitverInformationProvider calculator, Model model) {
        if (model.getScm() != null) {
            Scm scm = model.getScm();
            if (this.isVersionFromTag(calculator)) {
                scm.setTag(calculator.getVersion());
            } else {
                calculator.meta(Metadatas.GIT_SHA1_FULL).ifPresent(arg_0 -> ((Scm)scm).setTag(arg_0));
            }
        }
    }

    private boolean isVersionFromTag(JGitverInformationProvider calculator) {
        List<String> versionTagsOnHead = Arrays.asList(calculator.meta(Metadatas.HEAD_VERSION_ANNOTATED_TAGS).orElse("").split(","));
        String baseTag = calculator.meta(Metadatas.BASE_TAG).orElse("");
        return versionTagsOnHead.contains(baseTag);
    }

    private void addAttachPomMojo(Model model) {
        this.ensureBuildWithPluginsExistInModel(model);
        Optional<Plugin> pluginOptional = model.getBuild().getPlugins().stream().filter(x -> "fr.brouillard.oss".equalsIgnoreCase(x.getGroupId()) && "jgitver-maven-plugin".equalsIgnoreCase(x.getArtifactId())).findFirst();
        StringBuilder pluginVersion = new StringBuilder();
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/fr.brouillard.oss/jgitver-maven-plugin/pom.properties");){
            Properties properties = new Properties();
            properties.load(inputStream);
            pluginVersion.append(properties.getProperty("version"));
        }
        catch (IOException ignored) {
            this.logger.warn(ignored.getMessage(), (Throwable)ignored);
        }
        Plugin plugin = pluginOptional.orElseGet(() -> {
            Plugin plugin2 = new Plugin();
            plugin2.setGroupId("fr.brouillard.oss");
            plugin2.setArtifactId("jgitver-maven-plugin");
            plugin2.setVersion(pluginVersion.toString());
            model.getBuild().getPlugins().add(0, plugin2);
            return plugin2;
        });
        if (Objects.isNull(plugin.getExecutions())) {
            plugin.setExecutions(new ArrayList());
        }
        String pluginRunPhase = System.getProperty("jgitver.pom-replacement-phase", "prepare-package");
        Optional<PluginExecution> pluginExecutionOptional = plugin.getExecutions().stream().filter(x -> pluginRunPhase.equalsIgnoreCase(x.getPhase())).findFirst();
        PluginExecution pluginExecution = pluginExecutionOptional.orElseGet(() -> {
            PluginExecution pluginExecution2 = new PluginExecution();
            pluginExecution2.setPhase(pluginRunPhase);
            plugin.getExecutions().add(pluginExecution2);
            return pluginExecution2;
        });
        if (Objects.isNull(pluginExecution.getGoals())) {
            pluginExecution.setGoals(new ArrayList());
        }
        if (!pluginExecution.getGoals().contains("attach-modified-poms")) {
            pluginExecution.getGoals().add("attach-modified-poms");
        }
        if (Objects.isNull(plugin.getDependencies())) {
            plugin.setDependencies(new ArrayList());
        }
        Optional<Dependency> dependencyOptional = plugin.getDependencies().stream().filter(x -> "fr.brouillard.oss".equalsIgnoreCase(x.getGroupId()) && "jgitver-maven-plugin".equalsIgnoreCase(x.getArtifactId())).findFirst();
        dependencyOptional.orElseGet(() -> {
            Dependency dependency = new Dependency();
            dependency.setGroupId("fr.brouillard.oss");
            dependency.setArtifactId("jgitver-maven-plugin");
            dependency.setVersion(pluginVersion.toString());
            plugin.getDependencies().add(dependency);
            return dependency;
        });
    }
}

