/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.GAV;
import fr.brouillard.oss.jgitver.JGitverInformationProvider;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.simpleframework.xml.Default;
import org.simpleframework.xml.DefaultType;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Transient;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;

@Root(name="jgitver")
@Default(value=DefaultType.FIELD)
public class JGitverSession {
    @Transient
    private JGitverInformationProvider calculator;
    @Element(name="calculatedVersion")
    private String version;
    @Element(name="multiModuleProjectDirectory")
    private File multiModuleDirectory;
    @ElementList(name="projects", entry="gav")
    private Set<GAV> projects = new LinkedHashSet<GAV>();

    JGitverSession() {
    }

    public JGitverSession(JGitverInformationProvider gitVersionCalculator, File multiModuleDirectory) {
        this.version = gitVersionCalculator.getVersion();
        this.calculator = gitVersionCalculator;
        this.multiModuleDirectory = multiModuleDirectory;
    }

    public String getVersion() {
        return this.version;
    }

    public JGitverInformationProvider getCalculator() {
        return this.calculator;
    }

    public File getMultiModuleDirectory() {
        return this.multiModuleDirectory;
    }

    public void addProject(GAV project) {
        this.projects.add(project);
    }

    public Set<GAV> getProjects() {
        return Collections.unmodifiableSet(this.projects);
    }

    public static String serializeTo(JGitverSession session) throws Exception {
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy);
        StringWriter sw = new StringWriter();
        serializer.write((Object)session, (Writer)sw);
        return sw.toString();
    }

    public static JGitverSession serializeFrom(String content) throws Exception {
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy);
        return (JGitverSession)serializer.read(JGitverSession.class, content);
    }
}

