/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.cfg;

import fr.brouillard.oss.jgitver.cfg.Configuration;
import fr.brouillard.oss.jgitver.cfg.InMemoryLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.MavenExecutionException;
import org.codehaus.plexus.logging.Logger;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;

public class ConfigurationLoader {
    private static final String NAMESPACE_1_0_0_beta = "http://jgitver.github.io/maven/configuration/1.0.0-beta";
    private static final String NAMESPACE_1_0_0 = "http://jgitver.github.io/maven/configuration/1.0.0";
    private final Logger logger;
    private final List<File> configurationFiles;

    public ConfigurationLoader(File rootDirectory, Logger logger) {
        this.logger = logger;
        this.configurationFiles = new ArrayList<File>();
        String cliConfigFile = System.getProperty("jgitver.config");
        if (cliConfigFile != null) {
            logger.debug("jgitver configuration file overridden with " + cliConfigFile);
            this.configurationFiles.add(new File(cliConfigFile));
        }
        File extensionMavenCoreDirectory = new File(rootDirectory, ".mvn");
        File defaultConfigurationXml = new File(extensionMavenCoreDirectory, "jgitver.config.xml");
        File backwardCompatibleConfigurationFile = new File(extensionMavenCoreDirectory, "jgtiver.config.xml");
        this.configurationFiles.add(defaultConfigurationXml);
        this.configurationFiles.add(backwardCompatibleConfigurationFile);
    }

    public Configuration load() throws MavenExecutionException {
        for (File cfgFile : this.configurationFiles) {
            this.logger.debug("trying to load configuration from: " + cfgFile);
            Configuration c = ConfigurationLoader.loadFromFile(cfgFile, this.logger);
            if (c == null) continue;
            this.logger.info("Using jgitver configuration file: " + cfgFile);
            return c;
        }
        this.logger.info("No suitable configuration file found, using defaults");
        return new Configuration();
    }

    public static Configuration loadFromRoot(File rootDirectory, Logger logger) throws MavenExecutionException {
        return new ConfigurationLoader(rootDirectory, logger).load();
    }

    private static Configuration loadFromFile(File configurationXml) throws MavenExecutionException {
        return ConfigurationLoader.loadFromFile(configurationXml, (Logger)new InMemoryLogger());
    }

    private static Configuration loadFromFile(File configurationXml, Logger logger) throws MavenExecutionException {
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy);
        if (configurationXml.exists()) {
            if (configurationXml.canRead()) {
                try {
                    return (Configuration)serializer.read(Configuration.class, configurationXml);
                }
                catch (Exception e) {
                    throw new MavenExecutionException("failure reading configuration from: " + configurationXml, (Throwable)e);
                }
            }
            logger.warn("jgitver configuration file " + configurationXml + " cannot be read, skipping it");
        } else {
            logger.debug("jgitver configuration file " + configurationXml + " does not exists, skipping it");
        }
        return null;
    }
}

