/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.BranchingPolicy;
import fr.brouillard.oss.jgitver.GitVersionCalculator;
import fr.brouillard.oss.jgitver.JGitverConfiguration;
import fr.brouillard.oss.jgitver.JGitverInformationProvider;
import fr.brouillard.oss.jgitver.JGitverMavenPluginProperties;
import fr.brouillard.oss.jgitver.JGitverModelProcessor;
import fr.brouillard.oss.jgitver.JGitverSession;
import fr.brouillard.oss.jgitver.JGitverSessionHolder;
import fr.brouillard.oss.jgitver.JGitverUtils;
import fr.brouillard.oss.jgitver.Providers;
import fr.brouillard.oss.jgitver.cfg.Configuration;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.building.ModelProcessor;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="jgitver")
public class JGitverExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private ModelProcessor modelProcessor;
    @Requirement
    private JGitverSessionHolder sessionHolder;
    @Requirement
    private JGitverConfiguration configurationProvider;

    public void afterSessionStart(MavenSession mavenSession) throws MavenExecutionException {
        if (JGitverUtils.shouldSkip(mavenSession)) {
            this.logger.info("  jgitver execution has been skipped by request of the user");
            this.sessionHolder.setSession(null);
        } else {
            File rootDirectory = mavenSession.getRequest().getMultiModuleProjectDirectory();
            this.logger.debug("using jgitver on directory: " + rootDirectory);
            Configuration cfg = this.configurationProvider.getConfiguration();
            try (GitVersionCalculator gitVersionCalculator = GitVersionCalculator.location((File)rootDirectory);){
                JGitverInformationProvider infoProvider;
                if (cfg.strategy != null) {
                    gitVersionCalculator.setStrategy(cfg.strategy);
                } else {
                    gitVersionCalculator.setMavenLike(cfg.mavenLike);
                }
                if (cfg.policy != null) {
                    gitVersionCalculator.setLookupPolicy(cfg.policy);
                }
                gitVersionCalculator.setAutoIncrementPatch(cfg.autoIncrementPatch).setUseDirty(cfg.useDirty).setUseDistance(cfg.useCommitDistance).setUseGitCommitTimestamp(cfg.useGitCommitTimestamp).setUseGitCommitId(cfg.useGitCommitId).setUseSnapshot(cfg.useSnapshot).setGitCommitIdLength(cfg.gitCommitIdLength).setUseDefaultBranchingPolicy(cfg.useDefaultBranchingPolicy).setNonQualifierBranches(cfg.nonQualifierBranches).setVersionPattern(cfg.versionPattern).setTagVersionPattern(cfg.tagVersionPattern).setScript(cfg.script).setScriptType(cfg.scriptType);
                if (cfg.maxSearchDepth >= 1 && cfg.maxSearchDepth != -1) {
                    gitVersionCalculator.setMaxDepth(cfg.maxSearchDepth);
                }
                if (JGitverUtils.shouldForceComputation(mavenSession)) {
                    gitVersionCalculator.setForceComputation(true);
                }
                if (cfg.regexVersionTag != null) {
                    gitVersionCalculator.setFindTagVersionPattern(cfg.regexVersionTag);
                }
                if (cfg.branchPolicies != null && !cfg.branchPolicies.isEmpty()) {
                    List policies = cfg.branchPolicies.stream().map(bp -> new BranchingPolicy(bp.pattern, bp.transformations)).collect(Collectors.toList());
                    gitVersionCalculator.setQualifierBranchingPolicies(policies);
                }
                this.logger.info(String.format("Using jgitver-maven-plugin [%s] (sha1: %s)", JGitverMavenPluginProperties.getVersion(), JGitverMavenPluginProperties.getSHA1()));
                long start = System.currentTimeMillis();
                String computedVersion = gitVersionCalculator.getVersion();
                long duration = System.currentTimeMillis() - start;
                this.logger.info(String.format("    version '%s' computed in %d ms", computedVersion, duration));
                this.logger.info("");
                boolean isDirty = gitVersionCalculator.meta(Metadatas.DIRTY).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
                if (cfg.failIfDirty && isDirty) {
                    throw new IllegalStateException("repository is dirty");
                }
                JGitverInformationProvider finalInfoProvider = infoProvider = Providers.decorate(gitVersionCalculator);
                infoProvider = JGitverUtils.versionOverride(mavenSession, this.logger).map(version -> Providers.fixVersion(version, finalInfoProvider)).orElse(infoProvider);
                JGitverUtils.fillPropertiesFromMetadatas(mavenSession.getUserProperties(), infoProvider, this.logger);
                JGitverSession session = new JGitverSession(infoProvider, rootDirectory);
                this.sessionHolder.setSession(session);
            }
            catch (Exception ex) {
                this.logger.warn("cannot autoclose GitVersionCalculator object for project: " + rootDirectory, (Throwable)ex);
            }
        }
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        this.sessionHolder.setSession(null);
    }

    public void afterProjectsRead(MavenSession mavenSession) throws MavenExecutionException {
        if (!JGitverUtils.shouldSkip(mavenSession)) {
            File projectBaseDir = mavenSession.getCurrentProject().getBasedir();
            try {
                if (projectBaseDir != null && !this.configurationProvider.ignore(new File(projectBaseDir, "pom.xml"))) {
                    Consumer<CharSequence> c = cs -> this.logger.warn(cs.toString());
                    if (JGitverModelProcessor.class.isAssignableFrom(this.modelProcessor.getClass())) {
                        if (!mavenSession.getUserProperties().containsKey("jgitver.session")) {
                            JGitverUtils.failAsOldMechanism(c);
                        }
                    } else {
                        JGitverUtils.failAsOldMechanism(c);
                    }
                    this.sessionHolder.session().ifPresent(jgitverSession -> {
                        this.logger.info("jgitver-maven-plugin is about to change project(s) version(s)");
                        jgitverSession.getProjects().forEach(gav -> this.logger.info("    " + gav.toString() + " -> " + jgitverSession.getVersion()));
                    });
                }
            }
            catch (IOException ex) {
                new MavenExecutionException("cannot evaluate if jgitver should ignore base project directory: " + projectBaseDir, (Throwable)ex);
            }
        }
    }
}

