/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.mojos;

import fr.brouillard.oss.jgitver.JGitverSession;
import fr.brouillard.oss.jgitver.JGitverUtils;
import java.util.Objects;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

@Mojo(name="attach-modified-poms", instantiationStrategy=InstantiationStrategy.SINGLETON, threadSafe=true)
public class JGitverAttachModifiedPomsMojo
extends AbstractMojo {
    public static final String GOAL_ATTACH_MODIFIED_POMS = "attach-modified-poms";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(property="jgitver.resolve-project-version", defaultValue="false")
    private Boolean resolveProjectVersion;

    public void execute() throws MojoExecutionException {
        if (Objects.isNull(this.mavenSession.getUserProperties().get("jgitver.session"))) {
            this.getLog().warn((CharSequence)"attach-modified-pomsshouldn't be executed alone. The Mojo is a part of the plugin and executed automatically.");
            return;
        }
        String content = this.mavenSession.getUserProperties().getProperty("jgitver.session");
        if ("-".equalsIgnoreCase(content)) {
            return;
        }
        try {
            JGitverSession jgitverSession = JGitverSession.serializeFrom(content);
            JGitverUtils.attachModifiedPomFilesToTheProject(this.mavenSession.getAllProjects(), jgitverSession.getProjects(), jgitverSession.getVersion(), this.resolveProjectVersion, (Logger)new ConsoleLogger());
            this.mavenSession.getUserProperties().setProperty("jgitver.session", "-");
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to execute goal: attach-modified-poms", ex);
        }
    }
}

