/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import java.io.IOException;
import java.util.Optional;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.RevCommit;

public interface DistanceCalculator {
    public static DistanceCalculator create(ObjectId start, Repository repository, int maxDepth) {
        return new DepthWalkDistanceCalculator(start, repository, maxDepth > 0 ? maxDepth : Integer.MAX_VALUE);
    }

    public static DistanceCalculator create(ObjectId start, Repository repository) {
        return DistanceCalculator.create(start, repository, Integer.MAX_VALUE);
    }

    public Optional<Integer> distanceTo(ObjectId var1);

    public static class DepthWalkDistanceCalculator
    implements DistanceCalculator {
        private final ObjectId startId;
        private final Repository repository;
        private final int maxDepth;

        DepthWalkDistanceCalculator(ObjectId start, Repository repository, int maxDepth) {
            this.startId = start;
            this.repository = repository;
            this.maxDepth = maxDepth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Integer> distanceTo(ObjectId target) {
            DepthWalk.RevWalk walk = null;
            try {
                walk = new DepthWalk.RevWalk(this.repository, this.maxDepth);
                RevCommit startCommit = walk.parseCommit((AnyObjectId)this.startId);
                walk.markRoot(startCommit);
                walk.setRetainBody(false);
                for (RevCommit commit : walk) {
                    if (!commit.getId().getName().equals(target.getName())) continue;
                    if (commit instanceof DepthWalk.Commit) {
                        DepthWalk.Commit dwc = (DepthWalk.Commit)commit;
                        Optional<Integer> optional = Optional.of(dwc.getDepth());
                        return optional;
                    }
                    throw new IllegalStateException(String.format("implementation of %s or jgit internal has been incorrectly changed", DepthWalkDistanceCalculator.class.getSimpleName()));
                }
            }
            catch (IOException ignore) {
                ignore.printStackTrace();
            }
            finally {
                if (walk != null) {
                    walk.dispose();
                    walk.close();
                }
            }
            return Optional.empty();
        }
    }
}

