/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.VersionCalculationException;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.impl.VersionStrategy;
import fr.brouillard.oss.jgitver.impl.pattern.VersionGrammarParser;
import fr.brouillard.oss.jgitver.impl.pattern.VersionPatternGrammarDefinition;
import fr.brouillard.oss.jgitver.metadata.MetadataProvider;
import fr.brouillard.oss.jgitver.metadata.MetadataRegistrar;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.petitparser.context.Result;

public class PatternVersionStrategy
extends VersionStrategy<PatternVersionStrategy> {
    public static final String DEFAULT_VERSION_PATTERN = "${v}${<meta.QUALIFIED_BRANCH_NAME}${<meta.COMMIT_DISTANCE}";
    public static final String DEFAULT_TAG_VERSION_PATTERN = "${v}";
    private String versionPattern = null;
    private String tagVersionPattern = null;
    private boolean autoIncrementPatch = false;

    public PatternVersionStrategy(VersionNamingConfiguration vnc, Repository repository, Git git, MetadataRegistrar registrar) {
        super(vnc, repository, git, registrar);
    }

    @Override
    public Version build(Commit head, List<Commit> parents) throws VersionCalculationException {
        try {
            String versionPattern;
            Commit base = this.findVersionCommit(head, parents);
            Ref tagToUse = this.findTagToUse(head, base);
            Version baseVersion = this.getBaseVersionAndRegisterMetadata(base, tagToUse);
            boolean useSnapshot = baseVersion.isSnapshot();
            if (!this.isBaseCommitOnHead(head, base) && this.autoIncrementPatch && GitUtils.isAnnotated(tagToUse)) {
                baseVersion = baseVersion.incrementPatch();
            }
            int headDistance = base.getHeadDistance();
            this.getRegistrar().registerMetadata(Metadatas.COMMIT_DISTANCE, "" + headDistance);
            try (RevWalk walk = new RevWalk(this.getRepository());){
                RevCommit rc = walk.parseCommit((AnyObjectId)head.getGitObject());
                String commitTimestamp = GitUtils.getTimestamp(rc.getAuthorIdent().getWhen().toInstant());
                this.getRegistrar().registerMetadata(Metadatas.COMMIT_TIMESTAMP, commitTimestamp);
                baseVersion = baseVersion.addQualifier(commitTimestamp);
            }
            if (!GitUtils.isDetachedHead(this.getRepository())) {
                String branch = this.getRepository().getBranch();
                baseVersion = this.enhanceVersionWithBranch(baseVersion, branch);
            } else {
                Optional<String> externalyProvidedBranchName = GitUtils.providedBranchName();
                if (externalyProvidedBranchName.isPresent()) {
                    baseVersion = this.enhanceVersionWithBranch(baseVersion, externalyProvidedBranchName.get());
                }
            }
            String string = versionPattern = this.versionPattern != null ? this.versionPattern : DEFAULT_VERSION_PATTERN;
            if (this.isBaseCommitOnHead(head, base) && GitUtils.isAnnotated(tagToUse)) {
                versionPattern = this.tagVersionPattern != null ? this.tagVersionPattern : DEFAULT_TAG_VERSION_PATTERN;
            }
            Function<String, Optional<String>> env = t -> Optional.ofNullable(System.getenv(t));
            Function<String, Optional<String>> sys = t -> Optional.ofNullable(System.getProperty(t));
            MetadataProvider metaProvider = (MetadataProvider)MetadataProvider.class.cast(this.getRegistrar());
            VersionPatternGrammarDefinition def = new VersionPatternGrammarDefinition(baseVersion, env, sys, metaProvider::meta);
            VersionGrammarParser parser = new VersionGrammarParser(def);
            Result parseResult = parser.parse(versionPattern);
            if (parseResult.isSuccess()) {
                return (Version)parseResult.get();
            }
            String msg = String.format("cannot parse version using pattern: %s\nparsing failure: %s", versionPattern, parseResult.getMessage());
            throw new VersionCalculationException(msg);
        }
        catch (Exception ex) {
            throw new VersionCalculationException("cannot compute version", ex);
        }
    }

    public PatternVersionStrategy setVersionPattern(String versionPattern) {
        return (PatternVersionStrategy)this.runAndGetSelf(() -> {
            this.versionPattern = versionPattern;
        });
    }

    public PatternVersionStrategy setTagVersionPattern(String tagVersionPattern) {
        return (PatternVersionStrategy)this.runAndGetSelf(() -> {
            this.tagVersionPattern = tagVersionPattern;
        });
    }

    public PatternVersionStrategy setAutoIncrementPatch(boolean autoIncrementPatch) {
        return (PatternVersionStrategy)this.runAndGetSelf(() -> {
            this.autoIncrementPatch = autoIncrementPatch;
        });
    }
}

