/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.Features;
import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.VersionCalculationException;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.impl.VersionStrategy;
import fr.brouillard.oss.jgitver.metadata.MetadataRegistrar;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ConfigurableVersionStrategy
extends VersionStrategy<ConfigurableVersionStrategy> {
    private boolean autoIncrementPatch = false;
    private boolean useDistance = true;
    private boolean useCommitTimestamp = false;
    private boolean useGitCommitId = false;
    private int gitCommitIdLength = 8;
    private boolean useDirty = false;
    private boolean useLongFormat;
    private boolean useSnapshot = false;

    public ConfigurableVersionStrategy(VersionNamingConfiguration vnc, Repository repository, Git git, MetadataRegistrar metadatas) {
        super(vnc, repository, git, metadatas);
    }

    @Override
    public Version build(Commit head, List<Commit> parents) throws VersionCalculationException {
        if (this.useSnapshot && this.useDistance) {
            throw new VersionCalculationException("Can't use useSnapshot and useDistance in same time");
        }
        try {
            Commit base = this.findVersionCommit(head, parents);
            Ref tagToUse = this.findTagToUse(head, base);
            Version baseVersion = this.getBaseVersionAndRegisterMetadata(base, tagToUse);
            this.getRegistrar().registerMetadata(Metadatas.BASE_COMMIT_ON_HEAD, "" + this.isBaseCommitOnHead(head, base));
            if (!this.isBaseCommitOnHead(head, base) && this.autoIncrementPatch && !this.useLongFormat && GitUtils.isAnnotated(tagToUse)) {
                baseVersion = baseVersion.incrementPatch();
            }
            int headDistance = base.getHeadDistance();
            boolean isTagSnapshot = baseVersion.isSnapshot();
            if (this.useDistance && !isTagSnapshot) {
                if (tagToUse == null) {
                    baseVersion = baseVersion.addQualifier("" + headDistance);
                } else if (this.useLongFormat || !this.isBaseCommitOnHead(head, base) || !GitUtils.isAnnotated(tagToUse)) {
                    baseVersion = baseVersion.addQualifier("" + headDistance);
                }
            }
            boolean needSnapshotQualifier = isTagSnapshot;
            if (this.useSnapshot) {
                needSnapshotQualifier = isTagSnapshot || !this.isBaseCommitOnHead(head, base) || !GitUtils.isAnnotated(tagToUse);
            }
            this.getRegistrar().registerMetadata(Metadatas.COMMIT_DISTANCE, "" + headDistance);
            if (Features.DISTANCE_TO_ROOT.isActive()) {
                int headToRootDistance = GitUtils.distanceToRoot(this.getRepository(), (AnyObjectId)head.getGitObject());
                this.getRegistrar().registerMetadata(Metadatas.COMMIT_DISTANCE_TO_ROOT, "" + headToRootDistance);
            }
            boolean needsCommitTimestamp = this.useCommitTimestamp && !isTagSnapshot;
            try (RevWalk walk = new RevWalk(this.getRepository());){
                RevCommit rc = walk.parseCommit((AnyObjectId)head.getGitObject());
                String commitTimestamp = GitUtils.getTimestamp(rc.getAuthorIdent().getWhen().toInstant());
                this.getRegistrar().registerMetadata(Metadatas.COMMIT_TIMESTAMP, commitTimestamp);
                if (needsCommitTimestamp) {
                    baseVersion = baseVersion.addQualifier(commitTimestamp);
                }
            }
            if (this.useLongFormat || this.useGitCommitId) {
                String commitIdQualifier = (this.useLongFormat ? "g" : "") + head.getGitObject().getName().substring(0, this.useLongFormat ? 8 : this.gitCommitIdLength);
                baseVersion = baseVersion.addQualifier(commitIdQualifier);
            }
            if (!GitUtils.isDetachedHead(this.getRepository())) {
                String branch = this.getRepository().getBranch();
                baseVersion = this.enhanceVersionWithBranch(baseVersion, branch);
            } else {
                Optional<String> externalyProvidedBranchName = GitUtils.providedBranchName();
                if (externalyProvidedBranchName.isPresent()) {
                    String externalBranchName = externalyProvidedBranchName.get();
                    baseVersion = this.enhanceVersionWithBranch(baseVersion, externalBranchName);
                    this.getRegistrar().registerMetadata(Metadatas.PROVIDED_BRANCH_NAME, externalBranchName);
                }
            }
            if (this.useDirty && this.isGitDirty()) {
                baseVersion = baseVersion.addQualifier("dirty");
            }
            return needSnapshotQualifier ? baseVersion.removeQualifier("SNAPSHOT").addQualifier("SNAPSHOT") : baseVersion;
        }
        catch (Exception ex) {
            throw new VersionCalculationException("cannot compute version", ex);
        }
    }

    public ConfigurableVersionStrategy setAutoIncrementPatch(boolean autoIncrementPatch) {
        return (ConfigurableVersionStrategy)this.runAndGetSelf(() -> {
            this.autoIncrementPatch = autoIncrementPatch;
        });
    }

    public ConfigurableVersionStrategy setUseDistance(boolean useDistance) {
        return (ConfigurableVersionStrategy)this.runAndGetSelf(() -> {
            this.useDistance = useDistance;
        });
    }

    public ConfigurableVersionStrategy setUseCommitTimestamp(boolean useCommitTimestamp) {
        return (ConfigurableVersionStrategy)this.runAndGetSelf(() -> {
            this.useCommitTimestamp = useCommitTimestamp;
        });
    }

    public ConfigurableVersionStrategy setUseGitCommitId(boolean useGitCommitId) {
        return (ConfigurableVersionStrategy)this.runAndGetSelf(() -> {
            this.useGitCommitId = useGitCommitId;
        });
    }

    public ConfigurableVersionStrategy setGitCommitIdLength(int gitCommitIdLength) {
        return (ConfigurableVersionStrategy)this.runAndGetSelf(() -> {
            this.gitCommitIdLength = gitCommitIdLength;
        });
    }

    public ConfigurableVersionStrategy setUseDirty(boolean useDirty) {
        return (ConfigurableVersionStrategy)this.runAndGetSelf(() -> {
            this.useDirty = useDirty;
        });
    }

    public ConfigurableVersionStrategy setUseLongFormat(boolean useLongFormat) {
        return (ConfigurableVersionStrategy)this.runAndGetSelf(() -> {
            this.useLongFormat = useLongFormat;
        });
    }

    public VersionStrategy setUseSnapshot(boolean useSnapshot) {
        return this.runAndGetSelf(() -> {
            this.useSnapshot = useSnapshot;
        });
    }
}

