/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.Features;
import fr.brouillard.oss.jgitver.ScriptType;
import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.VersionCalculationException;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.impl.VersionStrategy;
import fr.brouillard.oss.jgitver.metadata.MetadataProvider;
import fr.brouillard.oss.jgitver.metadata.MetadataRegistrar;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.maven.shared.scriptinterpreter.ProjectBeanShellScriptInterpreter;
import org.apache.maven.shared.scriptinterpreter.ProjectGroovyScriptInterpreter;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ScriptVersionStrategy
extends VersionStrategy<ScriptVersionStrategy> {
    private ScriptType scriptType = ScriptType.GROOVY;
    private String script = "";
    private static Function<String, String> IDENTITY = s -> s;
    private static Function<String, Boolean> TO_BOOLEAN = s -> {
        if (s == null || s.length() == 0) {
            return null;
        }
        return Boolean.valueOf(s);
    };
    private static Function<String, Integer> TO_INTEGER = s -> {
        if (s == null || s.length() == 0) {
            return null;
        }
        return Integer.valueOf(s);
    };
    private static Function<String, Version> TO_VERSION = Version::parse;

    public ScriptVersionStrategy(VersionNamingConfiguration vnc, Repository repository, Git git, MetadataRegistrar registrar) {
        super(vnc, repository, git, registrar);
    }

    @Override
    public Version build(Commit head, List<Commit> parents) throws VersionCalculationException {
        try {
            String[] qualifiers;
            Object interpreter;
            Commit base = this.findVersionCommit(head, parents);
            Ref tagToUse = this.findTagToUse(head, base);
            Version baseVersion = this.getBaseVersionAndRegisterMetadata(base, tagToUse);
            MetadataRegistrar registrar = this.getRegistrar();
            MetadataProvider metaProvider = (MetadataProvider)MetadataProvider.class.cast(registrar);
            HashMap metaProps = new HashMap();
            registrar.registerMetadata(Metadatas.COMMIT_DISTANCE, "" + base.getHeadDistance());
            if (Features.DISTANCE_TO_ROOT.isActive()) {
                int dtr = GitUtils.distanceToRoot(this.getRepository(), (AnyObjectId)head.getGitObject());
                registrar.registerMetadata(Metadatas.COMMIT_DISTANCE_TO_ROOT, "" + dtr);
            }
            String branch = this.getRepository().getBranch();
            registrar.registerMetadata(Metadatas.BRANCH_NAME, branch);
            this.getVersionNamingConfiguration().branchQualifier(branch).ifPresent(qualifier -> registrar.registerMetadata(Metadatas.QUALIFIED_BRANCH_NAME, (String)qualifier));
            GitUtils.providedBranchName().ifPresent(externalName -> {
                registrar.registerMetadata(Metadatas.QUALIFIED_BRANCH_NAME, (String)externalName);
                registrar.registerMetadata(Metadatas.PROVIDED_BRANCH_NAME, (String)externalName);
            });
            try (RevWalk walk = new RevWalk(this.getRepository());){
                RevCommit rc = walk.parseCommit((AnyObjectId)head.getGitObject());
                this.getRegistrar().registerMetadata(Metadatas.COMMIT_TIMESTAMP, GitUtils.getTimestamp(rc.getAuthorIdent().getWhen().toInstant()));
            }
            registrar.registerMetadata(Metadatas.BASE_COMMIT_ON_HEAD, "" + this.isBaseCommitOnHead(head, base));
            EnumSet.allOf(Metadatas.class).forEach(key -> metaProvider.meta((Metadatas)((Object)key)).ifPresent(value -> metaProps.put(key.name(), ScriptVersionStrategy.metaFunctor(key).apply((String)value))));
            HashMap globalVariables = new HashMap();
            globalVariables.put("env", System.getenv());
            globalVariables.put("sys", System.getProperties());
            globalVariables.put("metadata", Collections.unmodifiableMap(metaProps));
            if (this.script == null || this.script.length() == 0) {
                interpreter = new ProjectGroovyScriptInterpreter();
                this.script = this.defaultGroovyScript();
            } else {
                interpreter = ScriptType.BEAN_SHELL.equals((Object)this.scriptType) ? new ProjectBeanShellScriptInterpreter() : new ProjectGroovyScriptInterpreter();
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            interpreter.evaluateScript(this.script, Collections.emptyList(), globalVariables, new PrintStream(output));
            String csvResult = output.toString();
            String[] verComponents = csvResult.split(";");
            if (verComponents.length < 3) {
                throw new VersionCalculationException("invalid script result; expect at least 3 CSV columns (<major>;<minor>;<patch>): " + csvResult);
            }
            int major = this.extractPartialVersion(verComponents[0], "major");
            int minor = this.extractPartialVersion(verComponents[1], "minor");
            int patch = this.extractPartialVersion(verComponents[2], "patch");
            int qualifierCount = verComponents.length - 3;
            if (qualifierCount == 0) {
                qualifiers = new String[]{};
            } else {
                qualifiers = new String[qualifierCount];
                System.arraycopy(verComponents, 3, qualifiers, 0, qualifierCount);
            }
            return new Version(major, minor, patch, qualifiers);
        }
        catch (Exception ex) {
            throw new VersionCalculationException("cannot compute version", ex);
        }
    }

    /*
     * Exception decompiling
     */
    private String defaultGroovyScript() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int extractPartialVersion(String partialValue, String part) throws VersionCalculationException {
        try {
            return Integer.parseInt(partialValue);
        }
        catch (Exception cause) {
            throw new VersionCalculationException("invalid " + part + " value: " + partialValue, cause);
        }
    }

    public ScriptVersionStrategy setScriptType(ScriptType scriptType) {
        return (ScriptVersionStrategy)this.runAndGetSelf(() -> {
            this.scriptType = scriptType;
        });
    }

    public ScriptVersionStrategy setScript(String script) {
        return (ScriptVersionStrategy)this.runAndGetSelf(() -> {
            this.script = script;
        });
    }

    private static Function<String, ? extends Object> metaFunctor(Metadatas meta) {
        switch (meta) {
            case CALCULATED_VERSION: 
            case BASE_VERSION: 
            case NEXT_MAJOR_VERSION: 
            case NEXT_MINOR_VERSION: 
            case NEXT_PATCH_VERSION: {
                return TO_VERSION;
            }
            case CURRENT_VERSION_MAJOR: 
            case CURRENT_VERSION_MINOR: 
            case CURRENT_VERSION_PATCH: 
            case COMMIT_DISTANCE: 
            case COMMIT_DISTANCE_TO_ROOT: {
                return TO_INTEGER;
            }
            case DIRTY: 
            case ANNOTATED: 
            case DETACHED_HEAD: 
            case BASE_COMMIT_ON_HEAD: {
                return TO_BOOLEAN;
            }
        }
        return IDENTITY;
    }
}

