/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.Pair;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;

public interface DistanceCalculator {
    public static DistanceCalculator create(AnyObjectId start, Repository repository, int maxDepth) {
        CalculatorKind calculatorBuilder = GitUtils.calculatorBuilder();
        return calculatorBuilder.calculator(start, repository, maxDepth > 0 ? maxDepth : Integer.MAX_VALUE);
    }

    public static DistanceCalculator create(AnyObjectId start, Repository repository) {
        return DistanceCalculator.create(start, repository, Integer.MAX_VALUE);
    }

    public Optional<Integer> distanceTo(ObjectId var1);

    public static enum CalculatorKind {
        LOG{

            @Override
            DistanceCalculator calculator(AnyObjectId start, Repository repository, int maxDepth) {
                return new LogWalkDistanceCalculator(start, repository, maxDepth);
            }
        }
        ,
        DEPTH{

            @Override
            DistanceCalculator calculator(AnyObjectId start, Repository repository, int maxDepth) {
                return new DepthWalkDistanceCalculator(start, repository, maxDepth);
            }
        }
        ,
        FIRST_PARENT{

            @Override
            DistanceCalculator calculator(AnyObjectId start, Repository repository, int maxDepth) {
                return new FirstParentWalkDistanceCalculator(start, repository, maxDepth);
            }
        };


        abstract DistanceCalculator calculator(AnyObjectId var1, Repository var2, int var3);
    }

    public static class FirstParentWalkDistanceCalculator
    implements DistanceCalculator {
        private final AnyObjectId startId;
        private final Repository repository;
        private final int maxDepth;

        public FirstParentWalkDistanceCalculator(AnyObjectId start, Repository repository, int maxDepth) {
            this.startId = start;
            this.repository = repository;
            this.maxDepth = maxDepth;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<Integer> distanceTo(ObjectId target) {
            try (RevWalk walk = new RevWalk(this.repository);){
                RevCommit head = walk.parseCommit(this.startId);
                LinkedList<Pair<Integer, RevCommit>> parentsStack = new LinkedList<Pair<Integer, RevCommit>>();
                parentsStack.add(Pair.of(0, head));
                HashSet<RevCommit> processedRevs = new HashSet<RevCommit>();
                int commitCount = 0;
                while (!parentsStack.isEmpty()) {
                    RevCommit[] parents = head.getParents();
                    if (head.getId().getName().equals(target.getName())) {
                        Optional<Integer> optional = Optional.of(commitCount);
                        return optional;
                    }
                    RevCommit firstParent = null;
                    if (parents != null && parents.length > 0) {
                        firstParent = parents[0];
                    }
                    if (firstParent != null && !processedRevs.contains(firstParent)) {
                        head = walk.parseCommit((AnyObjectId)firstParent);
                        processedRevs.add(firstParent);
                        for (int i = 1; i < parents.length; ++i) {
                            parentsStack.push(Pair.of(commitCount, parents[i]));
                        }
                    } else {
                        Pair previous = (Pair)parentsStack.poll();
                        commitCount = (Integer)previous.getLeft();
                        RevCommit nextParent = (RevCommit)previous.getRight();
                        head = walk.parseCommit((AnyObjectId)nextParent);
                        processedRevs.add(nextParent);
                    }
                    if (commitCount >= this.maxDepth) {
                        Optional<Integer> optional = Optional.empty();
                        return optional;
                    }
                    ++commitCount;
                }
                return Optional.empty();
            }
            catch (IOException ignore) {
                ignore.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static class DepthWalkDistanceCalculator
    implements DistanceCalculator {
        private final AnyObjectId startId;
        private final Repository repository;
        private final int maxDepth;

        public DepthWalkDistanceCalculator(AnyObjectId start, Repository repository, int maxDepth) {
            this.startId = start;
            this.repository = repository;
            this.maxDepth = maxDepth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Integer> distanceTo(ObjectId target) {
            DepthWalk.RevWalk walk = null;
            try {
                walk = new DepthWalk.RevWalk(this.repository, this.maxDepth);
                RevCommit startCommit = walk.parseCommit(this.startId);
                walk.markRoot(startCommit);
                walk.setRetainBody(false);
                for (RevCommit commit : walk) {
                    if (!commit.getId().getName().equals(target.getName())) continue;
                    if (commit instanceof DepthWalk.Commit) {
                        DepthWalk.Commit dwc = (DepthWalk.Commit)commit;
                        Optional<Integer> optional = Optional.of(dwc.getDepth());
                        return optional;
                    }
                    throw new IllegalStateException(String.format("implementation of %s or jgit internal has been incorrectly changed", DepthWalkDistanceCalculator.class.getSimpleName()));
                }
            }
            catch (IOException ignore) {
                ignore.printStackTrace();
            }
            finally {
                if (walk != null) {
                    walk.dispose();
                    walk.close();
                }
            }
            return Optional.empty();
        }
    }

    public static class LogWalkDistanceCalculator
    implements DistanceCalculator {
        private final AnyObjectId startId;
        private final Repository repository;
        private final int maxDepth;

        public LogWalkDistanceCalculator(AnyObjectId start, Repository repository, int maxDepth) {
            this.startId = start;
            this.repository = repository;
            this.maxDepth = maxDepth;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<Integer> distanceTo(ObjectId target) {
            Objects.requireNonNull(target);
            try (RevWalk walk = new RevWalk(this.repository);){
                RevCommit startCommit = walk.parseCommit(this.startId);
                walk.setRetainBody(false);
                walk.markStart(startCommit);
                walk.sort(RevSort.TOPO);
                System.out.printf("from %s :: %s\n", this.startId.name(), target.name());
                Iterator commitIterator = walk.iterator();
                int distance = 0;
                do {
                    if (!commitIterator.hasNext()) return Optional.empty();
                    RevCommit commit = (RevCommit)commitIterator.next();
                    System.out.printf("%d - %s\n", distance, commit.getId().name());
                    if (!commit.getId().getName().equals(target.getName())) continue;
                    Optional<Integer> optional = Optional.of(distance);
                    return optional;
                } while (++distance <= this.maxDepth);
                Optional<Integer> optional = Optional.empty();
                return optional;
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
            return Optional.empty();
        }
    }
}

