/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.Lambdas;
import fr.brouillard.oss.jgitver.impl.VersionCalculationException;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.metadata.MetadataRegistrar;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import fr.brouillard.oss.jgitver.metadata.TagType;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public abstract class VersionStrategy<T extends VersionStrategy> {
    private VersionNamingConfiguration vnc;
    private Repository repository;
    private Git git;
    private MetadataRegistrar registrar;
    private int searchDepthLimit = Integer.MAX_VALUE;

    protected MetadataRegistrar getRegistrar() {
        return this.registrar;
    }

    public VersionStrategy(VersionNamingConfiguration vnc, Repository repository, Git git, MetadataRegistrar registrar) {
        this.vnc = vnc;
        this.repository = repository;
        this.git = git;
        this.registrar = registrar;
    }

    public abstract Version build(Commit var1, List<Commit> var2) throws VersionCalculationException;

    public int searchDepthLimit() {
        return this.searchDepthLimit;
    }

    public T setSearchDepthLimit(int newLimit) {
        return this.runAndGetSelf(() -> {
            this.searchDepthLimit = newLimit > 0 ? newLimit : 0;
        });
    }

    public boolean isVersionTag(Ref tag) {
        String tagName = this.tagNameFromRef(tag);
        return this.getVersionNamingConfiguration().getSearchPattern().matcher(tagName).matches();
    }

    public StrategySearchMode searchMode() {
        return StrategySearchMode.STOP_AT_FIRST;
    }

    private String tagNameFromRef(Ref tag) {
        return tag.getName().replace("refs/tags/", "");
    }

    protected TagType computeTagType(Ref tagToUse, Ref annotatedTag) {
        if (annotatedTag != null && tagToUse.getObjectId().toString().equals(annotatedTag.getObjectId().toString())) {
            return TagType.ANNOTATED;
        }
        return TagType.LIGHTWEIGHT;
    }

    protected T runAndGetSelf(Runnable runnable) {
        runnable.run();
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    protected Version getBaseVersionAndRegisterMetadata(Commit base, Ref tagToUse) {
        Version baseVersion = Version.DEFAULT_VERSION;
        if (tagToUse != null) {
            String tagName = GitUtils.tagNameFromRef(tagToUse);
            baseVersion = this.versionFromTag(tagToUse);
            TagType tagType = this.computeTagType(tagToUse, this.maxVersionTag(base.getAnnotatedTags()).orElse(null));
            this.getRegistrar().registerMetadata(Metadatas.BASE_TAG_TYPE, tagType.name());
            this.getRegistrar().registerMetadata(Metadatas.BASE_TAG, tagName);
        }
        try {
            this.getRegistrar().registerMetadata(Metadatas.DETACHED_HEAD, "" + GitUtils.isDetachedHead(this.getRepository()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getRegistrar().registerMetadata(Metadatas.ANNOTATED, "" + GitUtils.isAnnotated(tagToUse));
        this.getRegistrar().registerMetadata(Metadatas.BASE_VERSION, baseVersion.toString());
        this.getRegistrar().registerMetadata(Metadatas.CURRENT_VERSION_MAJOR, Integer.toString(baseVersion.getMajor()));
        this.getRegistrar().registerMetadata(Metadatas.CURRENT_VERSION_MINOR, Integer.toString(baseVersion.getMinor()));
        this.getRegistrar().registerMetadata(Metadatas.CURRENT_VERSION_PATCH, Integer.toString(baseVersion.getPatch()));
        return baseVersion;
    }

    protected Version tagToVersion(String tagName) {
        return Version.parse(this.getVersionNamingConfiguration().extractVersionFrom(tagName));
    }

    protected boolean isGitDirty() {
        return Lambdas.unchecked(GitUtils::isDirty).apply(this.getGit());
    }

    protected Ref findTagToUse(Commit head, Commit base) {
        return this.isBaseCommitOnHead(head, base) && !this.isGitDirty() ? this.maxVersionTag(base.getAnnotatedTags(), base.getLightTags()) : this.maxVersionTag(base.getLightTags(), base.getAnnotatedTags());
    }

    protected Commit findVersionCommit(Commit head, List<Commit> parents) {
        if (!head.getAnnotatedTags().isEmpty() || !head.getLightTags().isEmpty()) {
            return head;
        }
        return parents.size() > 1 ? this.findMaxVersionCommit(head, parents) : parents.get(0);
    }

    protected Commit findMaxVersionCommit(Commit head, List<Commit> parents) {
        return parents.stream().map(commit -> this.toVersionTarget(head, (Commit)commit)).max(Comparator.naturalOrder()).map(VersionTarget::getTarget).orElse(parents.get(0));
    }

    protected Ref maxVersionTag(List<Ref> primaryTags, List<Ref> secondaryTags) {
        return this.maxVersionTag(primaryTags).orElseGet(() -> this.maxVersionTag(secondaryTags).orElse(null));
    }

    protected Optional<Ref> maxVersionTag(List<Ref> tags) {
        return tags.stream().map(this::toVersionTarget).max(Comparator.naturalOrder()).map(VersionTarget::getTarget);
    }

    public Version versionFromTag(Ref ref) {
        return this.tagToVersion(GitUtils.tagNameFromRef(ref));
    }

    protected VersionTarget<Ref> toVersionTarget(Ref tagRef) {
        return new VersionTarget<Ref>(this.versionFromTag(tagRef), tagRef);
    }

    protected VersionTarget<Commit> toVersionTarget(Commit head, Commit commit) {
        Ref tagToUse = this.findTagToUse(head, commit);
        return new VersionTarget<Commit>(this.versionFromTag(tagToUse), commit);
    }

    protected VersionNamingConfiguration getVersionNamingConfiguration() {
        return this.vnc;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected Git getGit() {
        return this.git;
    }

    protected boolean isBaseCommitOnHead(Commit head, Commit base) {
        return head.getGitObject().name().equals(base.getGitObject().name());
    }

    protected Version enhanceVersionWithBranch(Version baseVersion, String branch) {
        this.getRegistrar().registerMetadata(Metadatas.BRANCH_NAME, branch);
        Optional<String> branchQualifier = this.getVersionNamingConfiguration().branchQualifier(branch);
        if (branchQualifier.isPresent()) {
            this.getRegistrar().registerMetadata(Metadatas.QUALIFIED_BRANCH_NAME, branchQualifier.get());
            baseVersion = baseVersion.addQualifier(branchQualifier.get());
        }
        return baseVersion;
    }

    private static class VersionTarget<T>
    implements Comparable<VersionTarget<T>> {
        private final Version version;
        private final T target;

        VersionTarget(Version version, T target) {
            this.version = version;
            this.target = target;
        }

        Version getVersion() {
            return this.version;
        }

        T getTarget() {
            return this.target;
        }

        @Override
        public int compareTo(VersionTarget versionTarget) {
            return this.version.compareTo(versionTarget.version);
        }
    }

    public static enum StrategySearchMode {
        STOP_AT_FIRST,
        DEPTH;

    }
}

