/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    public static final Version DEFAULT_VERSION = new Version(0, 0, 0, new String[0]);
    public static final Version EMPTY_REPOSITORY_VERSION = DEFAULT_VERSION.addQualifier("EMPTY_GIT_REPOSITORY");
    public static final Version NOT_GIT_VERSION = DEFAULT_VERSION.addQualifier("NOT_A_GIT_REPOSITORY");
    private final int major;
    private final int minor;
    private final int patch;
    private final String stringRepresentation;
    private final List<String> qualifiers;
    private static final Pattern globalVersionPattern = Pattern.compile("^([0-9]+)(?:\\.([0-9]+))?(?:\\.([0-9]+))?(\\-[a-zA-Z0-9][a-zA-Z0-9\\-_]*)?$");

    public Version(Version other) {
        this(other.major, other.minor, other.patch, other.qualifiers);
    }

    public Version(int major, int minor, int patch, String ... qualifiers) {
        this(major, minor, patch, Arrays.asList(qualifiers));
    }

    private Version(int major, int minor, int patch, List<String> qualifiers) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifiers = qualifiers != null ? new ArrayList<String>(qualifiers) : Collections.emptyList();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%d.%d.%d", major, minor, patch));
        this.qualifiers.forEach(q -> sb.append('-').append((String)q));
        this.stringRepresentation = sb.toString();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public Version addQualifier(String qualifier) {
        ArrayList<String> newQualifiers = new ArrayList<String>(this.qualifiers);
        newQualifiers.add(qualifier);
        return new Version(this.major, this.minor, this.patch, newQualifiers.toArray(new String[newQualifiers.size()]));
    }

    public Version removeQualifier(String qualifier) {
        ArrayList<String> newQualifiers = new ArrayList<String>(this.qualifiers);
        newQualifiers.remove(qualifier);
        return new Version(this.major, this.minor, this.patch, newQualifiers.toArray(new String[newQualifiers.size()]));
    }

    public Version noQualifier() {
        return new Version(this.major, this.minor, this.patch, Collections.emptyList());
    }

    public static Version parse(String versionAsString) {
        Matcher globalVersionMatcher = globalVersionPattern.matcher(versionAsString);
        if (globalVersionMatcher.matches()) {
            int major = Integer.parseInt(globalVersionMatcher.group(1));
            int minor = Integer.parseInt(Optional.ofNullable(globalVersionMatcher.group(2)).orElse("0"));
            int patch = Integer.parseInt(Optional.ofNullable(globalVersionMatcher.group(3)).orElse("0"));
            String qualifiersAsString = globalVersionMatcher.group(4);
            String[] qualifiers = new String[]{};
            if (qualifiersAsString != null) {
                qualifiers = qualifiersAsString.replaceFirst("-", "").split("\\-");
            }
            return new Version(major, minor, patch, qualifiers);
        }
        throw new IllegalStateException("cannot parse " + versionAsString + " as a semver compatible version");
    }

    public Version incrementPatch() {
        return new Version(this.major, this.minor, this.patch + 1, this.qualifiers);
    }

    public Version incrementMinor() {
        return new Version(this.major, this.minor + 1, 0, this.qualifiers);
    }

    public Version incrementMajor() {
        return new Version(this.major + 1, 0, 0, this.qualifiers);
    }

    public Version increasePatch() {
        return this.incrementPatch();
    }

    public boolean isSnapshot() {
        return this.qualifiers.stream().anyMatch("SNAPSHOT"::equals);
    }

    public boolean isQualified() {
        return this.qualifiers.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        if (this.patch != version.patch) {
            return false;
        }
        if (!this.stringRepresentation.equals(version.stringRepresentation)) {
            return false;
        }
        return this.qualifiers != null ? this.qualifiers.equals(version.qualifiers) : version.qualifiers == null;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + this.stringRepresentation.hashCode();
        result = 31 * result + (this.qualifiers != null ? this.qualifiers.hashCode() : 0);
        return result;
    }
}

